/*
 * Decompiled with CFR 0.152.
 */
package rearth.belts.blocks;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import rearth.belts.util.MathHelpers;

public class ConveyorSupportBlock
extends HorizontalDirectionalBlock {
    private static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>();

    private VoxelShape createShapeForDirection(Direction direction) {
        return Shapes.or((VoxelShape)MathHelpers.rotateVoxelShape(Shapes.box((double)0.4375, (double)0.0, (double)0.375, (double)0.5625, (double)0.25, (double)0.625), direction, AttachFace.FLOOR), (VoxelShape)MathHelpers.rotateVoxelShape(Shapes.box((double)0.125, (double)0.25, (double)0.375, (double)0.875, (double)0.5, (double)0.625), direction, AttachFace.FLOOR)).optimize();
    }

    public ConveyorSupportBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (dir == Direction.SOUTH) {
            dir = Direction.NORTH;
        }
        if (dir == Direction.EAST) {
            dir = Direction.WEST;
        }
        return SHAPES.computeIfAbsent(dir, this::createShapeForDirection);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(ctx)).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }
}

