/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util.modes;

import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class Surface
extends BaseMode {
    public Surface(boolean isExchanging) {
        super(isExchanging);
    }

    @Override
    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)"buildinggadgets2", (String)"surface");
    }

    @Override
    public ArrayList<StatePos> collectWorld(Direction hitSide, Player player, BlockPos start, BlockState state) {
        ItemStack gadget = BaseGadget.getGadget(player);
        int range = GadgetNBT.getToolRange(gadget);
        int bound = range / 2;
        Level level = player.level();
        ArrayList<StatePos> coordinates = new ArrayList<StatePos>();
        BlockState lookingAtState = level.getBlockState(start);
        BlockPos startAt = this.isExchanging ? start : start.relative(hitSide);
        AABB box = GadgetUtils.getSquareArea(startAt, hitSide, bound);
        BlockPos.betweenClosedStream((AABB)box).map(BlockPos::immutable).forEach(pos -> {
            if (this.isPosValid(level, player, (BlockPos)pos, state) && this.isPosValidCustom(level, (BlockPos)pos, lookingAtState, gadget, hitSide)) {
                coordinates.add(new StatePos(state, pos.subtract((Vec3i)start)));
            }
        });
        boolean connected = GadgetNBT.getSetting(gadget, GadgetNBT.ToggleableSettings.CONNECTED_AREA.getName());
        if (this.isExchanging && connected) {
            return this.removeUnConnected(level, player, startAt.subtract((Vec3i)start), coordinates, hitSide);
        }
        return coordinates;
    }

    public boolean isPosValidCustom(Level level, BlockPos pos, BlockState compareState, ItemStack gadget, Direction hitSide) {
        if (this.isExchanging) {
            return true;
        }
        boolean fuzzy = GadgetNBT.getSetting(gadget, GadgetNBT.ToggleableSettings.FUZZY.getName());
        BlockState belowState = level.getBlockState(pos.relative(hitSide.getOpposite()));
        return !(fuzzy ? belowState.isAir() : !belowState.equals(compareState));
    }
}

