/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.corelib.codec.CodecUtils;
import de.maxhenkel.camera.items.ImageItem;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ImageData {
    public static final Codec<ImageData> CODEC = RecordCodecBuilder.create(i -> i.group((App)UUIDUtil.CODEC.fieldOf("id").forGetter(ImageData::getId), (App)Codec.LONG.fieldOf("time").forGetter(ImageData::getTime), (App)Codec.STRING.fieldOf("owner").forGetter(ImageData::getOwner), (App)ResourceLocation.CODEC.optionalFieldOf("biome").forGetter(o -> Optional.ofNullable(o.getBiome())), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("entities").forGetter(imageData -> Optional.ofNullable(imageData.getEntities())), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).optionalFieldOf("dimension").forGetter(imageData -> Optional.ofNullable(imageData.getDimension())), (App)BlockPos.CODEC.optionalFieldOf("position").forGetter(imageData -> Optional.ofNullable(imageData.getPosition()))).apply((Applicative)i, ImageData::new));
    public static final StreamCodec<ByteBuf, Optional<ResourceLocation>> OPTIONAL_RESOURCE_LOCATION_STREAM_CODEC = CodecUtils.optionalStreamCodecByteBuf(ResourceLocation.STREAM_CODEC);
    public static final StreamCodec<ByteBuf, Optional<List<ResourceLocation>>> OPTIONAL_RESOURCE_LOCATION_LIST_STREAM_CODEC = CodecUtils.optionalStreamCodecByteBuf(CodecUtils.listStreamCodecByteBuf(ResourceLocation.STREAM_CODEC));
    public static final StreamCodec<ByteBuf, Optional<ResourceKey<Level>>> OPTIONAL_DIMENSION_STREAM_CODEC = CodecUtils.optionalStreamCodecByteBuf(ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION));
    public static final StreamCodec<ByteBuf, Optional<BlockPos>> OPTIONAL_BLOCK_POS_STREAM_CODEC = CodecUtils.optionalStreamCodecByteBuf(BlockPos.STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, ImageData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ImageData>(){

        public ImageData decode(RegistryFriendlyByteBuf buf) {
            return new ImageData((UUID)UUIDUtil.STREAM_CODEC.decode((Object)buf), (Long)ByteBufCodecs.VAR_LONG.decode((Object)buf), (String)ByteBufCodecs.STRING_UTF8.decode((Object)buf), (Optional)OPTIONAL_RESOURCE_LOCATION_STREAM_CODEC.decode((Object)buf), (Optional)OPTIONAL_RESOURCE_LOCATION_LIST_STREAM_CODEC.decode((Object)buf), (Optional)OPTIONAL_DIMENSION_STREAM_CODEC.decode((Object)buf), (Optional)OPTIONAL_BLOCK_POS_STREAM_CODEC.decode((Object)buf));
        }

        public void encode(RegistryFriendlyByteBuf buf, ImageData data) {
            UUIDUtil.STREAM_CODEC.encode((Object)buf, (Object)data.getId());
            ByteBufCodecs.VAR_LONG.encode((Object)buf, (Object)data.getTime());
            ByteBufCodecs.STRING_UTF8.encode((Object)buf, (Object)data.getOwner());
            OPTIONAL_RESOURCE_LOCATION_STREAM_CODEC.encode((Object)buf, Optional.ofNullable(data.getBiome()));
            OPTIONAL_RESOURCE_LOCATION_LIST_STREAM_CODEC.encode((Object)buf, Optional.ofNullable(data.getEntities()));
            OPTIONAL_DIMENSION_STREAM_CODEC.encode((Object)buf, Optional.ofNullable(data.getDimension()));
            OPTIONAL_BLOCK_POS_STREAM_CODEC.encode((Object)buf, Optional.ofNullable(data.getPosition()));
        }
    };
    private UUID id;
    private long time;
    private String owner;
    @Nullable
    private ResourceLocation biome;
    @Nullable
    private List<ResourceLocation> entities;
    @Nullable
    private ResourceKey<Level> dimension;
    @Nullable
    private BlockPos position;

    private ImageData() {
    }

    private ImageData(UUID id, long time, String owner) {
        this.id = id;
        this.time = time;
        this.owner = owner;
    }

    private ImageData(UUID id, long time, String owner, Optional<ResourceLocation> biome, Optional<List<ResourceLocation>> entities, Optional<ResourceKey<Level>> dimension, Optional<BlockPos> position) {
        this.id = id;
        this.time = time;
        this.owner = owner;
        this.biome = biome.orElse(null);
        this.entities = entities.orElse(null);
        this.dimension = dimension.orElse(null);
        this.position = position.orElse(null);
    }

    public UUID getId() {
        return this.id;
    }

    public long getTime() {
        return this.time;
    }

    public String getOwner() {
        return this.owner;
    }

    @Nullable
    public ResourceLocation getBiome() {
        return this.biome;
    }

    @Nullable
    public List<ResourceLocation> getEntities() {
        return this.entities;
    }

    @Nullable
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Nullable
    public BlockPos getPosition() {
        return this.position;
    }

    @Nullable
    public static ImageData fromStack(ItemStack stack) {
        ImageData.convert(stack);
        return (ImageData)stack.get(Main.IMAGE_DATA_COMPONENT);
    }

    public static ImageData create(ServerPlayer player, UUID imageID) {
        ImageData data = new ImageData();
        data.id = imageID;
        data.time = System.currentTimeMillis();
        data.owner = player.getName().getString();
        if (((Boolean)Main.SERVER_CONFIG.advancedImageData.get()).booleanValue()) {
            Biome biome = (Biome)player.level().getBiome(player.blockPosition()).value();
            data.biome = player.getServer().registryAccess().registry(Registries.BIOME).map(biomes -> biomes.getKey((Object)biome)).orElse(null);
            data.entities = player.level().getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(128.0), e -> ImageData.canEntityBeSeen(player, (Entity)e)).stream().sorted(Comparator.comparingDouble(arg_0 -> ((ServerPlayer)player).distanceTo(arg_0))).map(ImageData::getEntityID).distinct().limit(((Integer)Main.SERVER_CONFIG.advancedDataMaxEntities.get()).intValue()).collect(Collectors.toList());
            data.dimension = player.level().dimension();
            data.position = player.blockPosition();
        }
        return data;
    }

    private static ResourceLocation getEntityID(Entity entity) {
        return BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
    }

    private static boolean canEntityBeSeen(ServerPlayer player, Entity entity) {
        Vec3 lookVec;
        if (player == entity) {
            return false;
        }
        Vec3 playerVec = new Vec3(player.getX(), player.getEyeY(), player.getZ());
        Vec3 entityVec = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
        Vec3 lookVecToEntity = entityVec.subtract(playerVec).normalize();
        if (ImageData.angle(lookVecToEntity, lookVec = player.getLookAngle().normalize()) > 90.0) {
            return false;
        }
        return player.level().clip(new ClipContext(playerVec, entityVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).getType() == HitResult.Type.MISS;
    }

    private static double angle(Vec3 vec1, Vec3 vec2) {
        return Math.toDegrees(Math.acos(vec1.dot(vec2) / (vec1.length() * vec2.length())));
    }

    public static ImageData dummy() {
        ImageData data = new ImageData();
        data.id = new UUID(0L, 0L);
        data.time = System.currentTimeMillis();
        data.owner = "Steve";
        return data;
    }

    public void addToImage(ItemStack stack) {
        if (!(stack.getItem() instanceof ImageItem)) {
            return;
        }
        stack.set(Main.IMAGE_DATA_COMPONENT, (Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageData imageData = (ImageData)o;
        return Objects.equals(this.id, imageData.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public static void convert(ItemStack stack) {
        if (!(stack.getItem() instanceof ImageItem)) {
            return;
        }
        if (stack.has(Main.IMAGE_DATA_COMPONENT)) {
            return;
        }
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            return;
        }
        CompoundTag itemTag = customData.copyTag();
        if (!itemTag.contains("image", 10)) {
            return;
        }
        CompoundTag imageTag = itemTag.getCompound("image");
        itemTag.remove("image");
        if (imageTag.isEmpty()) {
            stack.remove(DataComponents.CUSTOM_DATA);
        } else {
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)itemTag));
        }
        ImageData imageData = ImageData.fromImageTag(imageTag);
        if (imageData == null) {
            return;
        }
        stack.set(Main.IMAGE_DATA_COMPONENT, (Object)imageData);
    }

    @Nullable
    public static ImageData fromImageTag(CompoundTag imageTag) {
        if (!imageTag.contains("image_id_most", 4) || !imageTag.contains("image_id_least", 4)) {
            return null;
        }
        UUID imageID = new UUID(imageTag.getLong("image_id_most"), imageTag.getLong("image_id_least"));
        long time = imageTag.getLong("image_time");
        String owner = imageTag.getString("owner");
        ResourceLocation biome = null;
        if (imageTag.contains("biome", 8)) {
            biome = ResourceLocation.tryParse((String)imageTag.getString("biome"));
        }
        ArrayList<ResourceLocation> entityList = null;
        if (imageTag.contains("entities", 9)) {
            ListTag entities = imageTag.getList("entities", 8);
            entityList = new ArrayList<ResourceLocation>();
            for (Tag e : entities) {
                ResourceLocation resourceLocation = ResourceLocation.tryParse((String)e.getAsString());
                if (resourceLocation == null) continue;
                entityList.add(resourceLocation);
            }
        }
        ImageData data = new ImageData();
        data.id = imageID;
        data.time = time;
        data.owner = owner;
        data.biome = biome;
        data.entities = entityList;
        return data;
    }
}

