/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.advancement.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public record MapColorPredicate(@NotNull List<MapColor> colors) {
    public static final Codec<MapColorPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.xmap(MapColor::byId, color -> color.id).listOf().fieldOf("colors").forGetter(MapColorPredicate::colors)).apply((Applicative)instance, MapColorPredicate::new));

    public boolean matches(@NotNull MapColor color) {
        if (this.colors.isEmpty()) {
            return true;
        }
        return this.colors.stream().anyMatch(c -> c.equals(color));
    }
}

