/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.client.render;

import com.mojang.math.Transformation;
import io.github.mortuusars.chalk.Config;
import io.github.mortuusars.chalk.block.ChalkMarkBlock;
import io.github.mortuusars.chalk.core.MarkSymbol;
import io.github.mortuusars.chalk.core.SymbolOrientation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ChalkMarkBakedModel
implements BakedModel {
    public static final ModelProperty<Direction> FACING = new ModelProperty();
    public static final ModelProperty<SymbolOrientation> ORIENTATION = new ModelProperty();
    public static final ModelProperty<MarkSymbol> SYMBOL = new ModelProperty();
    public static final ModelProperty<Boolean> GLOWING = new ModelProperty();
    private static final ModelState MODEL_STATE = new SimpleModelState(Transformation.identity(), false);
    private static final Vector3f ROTATION_ORIGIN = new Vector3f(0.5f, 0.5f, 0.5f);
    private static final FaceBakery faceBakery = new FaceBakery();
    private final BakedModel baseModel;
    private static final HashMap<Direction, Vector3f> FROM_COORDS = new HashMap();
    private static final HashMap<Direction, Vector3f> TO_COORDS;

    public ChalkMarkBakedModel(BakedModel baseModel) {
        this.baseModel = baseModel;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.cutout()});
    }

    public static ModelData getEmptyModelData() {
        return ModelData.builder().with(FACING, (Object)Direction.UP).with(SYMBOL, (Object)MarkSymbol.CENTER).with(ORIENTATION, (Object)SymbolOrientation.NORTH).with(GLOWING, (Object)false).build();
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        SymbolOrientation orientation = (SymbolOrientation)((Object)state.getValue(ChalkMarkBlock.ORIENTATION));
        Direction facing = (Direction)state.getValue((Property)ChalkMarkBlock.FACING);
        boolean glowing = (Boolean)state.getValue((Property)ChalkMarkBlock.GLOWING);
        MarkSymbol symbol = (MarkSymbol)((Object)state.getValue(ChalkMarkBlock.SYMBOL));
        return modelData.derive().with(ORIENTATION, (Object)orientation).with(FACING, (Object)facing).with(GLOWING, (Object)glowing).with(SYMBOL, (Object)symbol).build();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        if (side != null) {
            return Collections.emptyList();
        }
        if (!data.has(FACING)) {
            return this.baseModel.getQuads(state, side, rand, data, renderType);
        }
        if (!data.has(SYMBOL)) {
            return this.baseModel.getQuads(state, side, rand, data, renderType);
        }
        if (!data.has(ORIENTATION)) {
            return this.baseModel.getQuads(state, side, rand, data, renderType);
        }
        if (!data.has(GLOWING)) {
            return this.baseModel.getQuads(state, side, rand, data, renderType);
        }
        Direction facing = (Direction)data.get(FACING);
        MarkSymbol symbol = (MarkSymbol)((Object)data.get(SYMBOL));
        SymbolOrientation orientation = (SymbolOrientation)((Object)data.get(ORIENTATION));
        boolean isGlowing = Boolean.TRUE.equals(data.get(GLOWING));
        if (facing == null || symbol == null || orientation == null) {
            return this.baseModel.getQuads(state, side, rand, data, renderType);
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        BakedQuad quad = this.getBakedQuad(facing, symbol, orientation);
        if (isGlowing) {
            quad = ChalkMarkBakedModel.convertToFullBright(quad);
        }
        quads.add(quad);
        return quads;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState p_235039_, @Nullable Direction facing, @NotNull RandomSource random) {
        return Collections.emptyList();
    }

    private static BakedQuad convertToFullBright(BakedQuad quad) {
        int[] vertexData = (int[])quad.getVertices().clone();
        int step = vertexData.length / 4;
        vertexData[6] = 0xF000F0;
        vertexData[6 + step] = 0xF000F0;
        vertexData[6 + 2 * step] = 0xF000F0;
        vertexData[6 + 3 * step] = 0xF000F0;
        return new BakedQuad(vertexData, quad.getTintIndex(), quad.getDirection(), quad.getSprite(), false);
    }

    private BakedQuad getBakedQuad(@NotNull Direction facing, MarkSymbol symbol, SymbolOrientation symbolRotation) {
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(symbol.getTextureLocation());
        BlockElementFace blockPartFace = new BlockElementFace(facing, 0, "", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, facing == Direction.DOWN ? 180 : 0));
        int rotationOffset = (Integer)Config.Client.SYMBOL_ROTATION_OFFSETS.get((Object)symbol).get();
        int rotation = (symbolRotation.getRotation() + (facing == Direction.DOWN ? -rotationOffset : rotationOffset)) % 360;
        if (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE || facing.getAxis() == Direction.Axis.Y) {
            rotation = 360 - rotation;
        }
        BlockElementRotation blockPartRotation = new BlockElementRotation(ROTATION_ORIGIN, facing.getAxis(), (float)rotation, false);
        Vector3f from = FROM_COORDS.get(facing);
        Vector3f to = TO_COORDS.get(facing);
        return faceBakery.bakeQuad(from, to, blockPartFace, texture, facing, MODEL_STATE, blockPartRotation, true);
    }

    public boolean useAmbientOcclusion() {
        return this.baseModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.baseModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.baseModel.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.baseModel.isCustomRenderer();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        return this.baseModel.getParticleIcon();
    }

    @NotNull
    public ItemOverrides getOverrides() {
        return this.baseModel.getOverrides();
    }

    static {
        FROM_COORDS.put(Direction.DOWN, new Vector3f(0.0f, 15.9f, 0.0f));
        FROM_COORDS.put(Direction.UP, new Vector3f(0.0f, 0.0f, 0.0f));
        FROM_COORDS.put(Direction.NORTH, new Vector3f(0.0f, 0.0f, 15.9f));
        FROM_COORDS.put(Direction.SOUTH, new Vector3f(0.0f, 0.0f, 0.0f));
        FROM_COORDS.put(Direction.WEST, new Vector3f(15.9f, 0.0f, 0.0f));
        FROM_COORDS.put(Direction.EAST, new Vector3f(0.0f, 0.0f, 0.0f));
        TO_COORDS = new HashMap();
        TO_COORDS.put(Direction.DOWN, new Vector3f(16.0f, 16.0f, 16.0f));
        TO_COORDS.put(Direction.UP, new Vector3f(16.0f, 0.1f, 16.0f));
        TO_COORDS.put(Direction.NORTH, new Vector3f(16.0f, 16.0f, 16.0f));
        TO_COORDS.put(Direction.SOUTH, new Vector3f(16.0f, 16.0f, 0.1f));
        TO_COORDS.put(Direction.WEST, new Vector3f(16.0f, 16.0f, 16.0f));
        TO_COORDS.put(Direction.EAST, new Vector3f(0.1f, 16.0f, 16.0f));
    }
}

