/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.data.generation;

import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.item.component.ChalkBoxContents;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class LootTables {

    public static class ChestLootTables
    implements LootTableSubProvider {
        private final HolderLookup.Provider provider;

        public ChestLootTables(HolderLookup.Provider provider) {
            this.provider = provider;
        }

        public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(Chalk.LootTables.ABANDONED_MINESHAFT_CHALKS, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add((LootPoolEntryContainer.Builder)this.chalkBox(List.of(this.chalkStack(DyeColor.WHITE, 23), ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, this.chalkStack(DyeColor.LIGHT_GRAY, 0), ItemStack.EMPTY, this.chalkStack(DyeColor.RED, 17), ItemStack.EMPTY), 0).setWeight(2)).add((LootPoolEntryContainer.Builder)this.chalkBox(List.of(ItemStack.EMPTY, this.chalkStack(DyeColor.LIGHT_GRAY, 0), ItemStack.EMPTY, ItemStack.EMPTY, this.chalkStack(DyeColor.WHITE, 0), ItemStack.EMPTY, ItemStack.EMPTY, this.chalkStack(DyeColor.LIGHT_BLUE, 6), new ItemStack((ItemLike)Items.GLOWSTONE_DUST, 7)), 3).setWeight(2)).add((LootPoolEntryContainer.Builder)this.chalkBox(List.of(this.chalkStack(DyeColor.BLUE, 5), ItemStack.EMPTY, this.chalkStack(DyeColor.PINK, 50), ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, this.chalkStack(DyeColor.YELLOW, 0), ItemStack.EMPTY, new ItemStack((ItemLike)Items.GLOW_INK_SAC)), 5).setWeight(2)).add((LootPoolEntryContainer.Builder)this.chalkBox(List.of(ItemStack.EMPTY, this.chalkStack(DyeColor.LIGHT_GRAY, 0), ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, this.chalkStack(DyeColor.GREEN, 14), ItemStack.EMPTY, ItemStack.EMPTY), 0).setWeight(2)).add(this.chalk(DyeColor.WHITE, 10)).add(this.chalk(DyeColor.LIGHT_GRAY, 8)).add(this.chalk(DyeColor.BLACK, 4)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(50))));
            consumer.accept(Chalk.LootTables.DESERT_PYRAMID_CHALKS, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add((LootPoolEntryContainer.Builder)this.chalkBox(List.of(this.chalkStack(DyeColor.WHITE, 23), ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, this.chalkStack(DyeColor.LIGHT_GRAY, 12), ItemStack.EMPTY, ItemStack.EMPTY, this.chalkStack(DyeColor.RED, 0), ItemStack.EMPTY), 0).setWeight(2)).add((LootPoolEntryContainer.Builder)this.chalkBox(List.of(ItemStack.EMPTY, this.chalkStack(DyeColor.LIGHT_GRAY, 5), ItemStack.EMPTY, this.chalkStack(DyeColor.WHITE, 0), ItemStack.EMPTY, ItemStack.EMPTY, this.chalkStack(DyeColor.LIGHT_BLUE, 15), ItemStack.EMPTY, new ItemStack((ItemLike)Items.GLOWSTONE_DUST, 4)), 4).setWeight(2)).add((LootPoolEntryContainer.Builder)this.chalkBox(List.of(this.chalkStack(DyeColor.BLUE, 5), ItemStack.EMPTY, this.chalkStack(DyeColor.ORANGE, 26), ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, this.chalkStack(DyeColor.YELLOW, 0), ItemStack.EMPTY, ItemStack.EMPTY), 0).setWeight(2)).add(this.chalk(DyeColor.WHITE, 5)).add(this.chalk(DyeColor.LIGHT_GRAY, 5)).add(this.chalk(DyeColor.GRAY, 5)).add(this.chalk(DyeColor.BLACK, 5)).add(this.chalk(DyeColor.YELLOW, 5)).add(this.chalk(DyeColor.LIGHT_BLUE, 5)).add(this.chalk(DyeColor.ORANGE, 5)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(60))));
            consumer.accept(Chalk.LootTables.SIMPLE_DUNGEON_CHALKS, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add((LootPoolEntryContainer.Builder)this.chalkBox(List.of(this.chalkStack(DyeColor.WHITE, 23), ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, this.chalkStack(DyeColor.LIGHT_GRAY, 12), ItemStack.EMPTY, ItemStack.EMPTY, this.chalkStack(DyeColor.RED, 0), ItemStack.EMPTY), 0).setWeight(2)).add((LootPoolEntryContainer.Builder)this.chalkBox(List.of(ItemStack.EMPTY, this.chalkStack(DyeColor.LIGHT_GRAY, 0), ItemStack.EMPTY, this.chalkStack(DyeColor.WHITE, 7), ItemStack.EMPTY, ItemStack.EMPTY, this.chalkStack(DyeColor.LIGHT_BLUE, 15), ItemStack.EMPTY, new ItemStack((ItemLike)Items.GLOWSTONE_DUST, 7)), 2).setWeight(2)).add((LootPoolEntryContainer.Builder)this.chalkBox(List.of(this.chalkStack(DyeColor.BLUE, 5), ItemStack.EMPTY, this.chalkStack(DyeColor.PINK, 50), ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, this.chalkStack(DyeColor.YELLOW, 0), ItemStack.EMPTY, new ItemStack((ItemLike)Items.GLOW_INK_SAC)), 5).setWeight(2)).add((LootPoolEntryContainer.Builder)this.chalkBox(List.of(ItemStack.EMPTY, this.chalkStack(DyeColor.MAGENTA, 6), ItemStack.EMPTY, this.chalkStack(DyeColor.CYAN, 0), ItemStack.EMPTY, ItemStack.EMPTY, this.chalkStack(DyeColor.LIME, 4), ItemStack.EMPTY, ItemStack.EMPTY), 0).setWeight(2)).add(this.chalk(DyeColor.WHITE, 5)).add(this.chalk(DyeColor.LIGHT_GRAY, 5)).add(this.chalk(DyeColor.BLACK, 5)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(50))));
            consumer.accept(Chalk.LootTables.VILLAGE_CHALKS, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add(this.chalk(DyeColor.WHITE, 5)).add(this.chalk(DyeColor.LIGHT_GRAY, 4)).add(this.chalk(DyeColor.GRAY, 3)).add(this.chalk(DyeColor.BLACK, 2)).add(this.chalk(DyeColor.YELLOW, 5)).add(this.chalk(DyeColor.LIGHT_BLUE, 5)).add(this.chalk(DyeColor.ORANGE, 5)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(50))));
        }

        private LootPoolSingletonContainer.Builder<?> chalk(DyeColor color, int weight) {
            return LootItem.lootTableItem((ItemLike)Chalk.Items.getChalk(color)).setWeight(weight);
        }

        private LootPoolSingletonContainer.Builder<?> chalkBox(List<ItemStack> items, int glowAmount) {
            return LootItem.lootTableItem((ItemLike)((ItemLike)Chalk.Items.CHALK_BOX.get())).apply((LootItemFunction.Builder)SetComponentsFunction.setComponent(Chalk.DataComponents.CHALK_BOX_CONTENTS, (Object)new ChalkBoxContents(items, glowAmount)));
        }

        private ItemStack chalkStack(DyeColor color, int damage) {
            ItemStack itemStack = new ItemStack((ItemLike)Chalk.Items.getChalk(color));
            if (damage > 0) {
                itemStack.setDamageValue(damage);
            }
            return itemStack;
        }
    }
}

