/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.item;

import com.google.common.base.Preconditions;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.Config;
import io.github.mortuusars.chalk.block.ChalkMarkBlock;
import io.github.mortuusars.chalk.core.IChalkDrawingTool;
import io.github.mortuusars.chalk.core.Mark;
import io.github.mortuusars.chalk.core.MarkSymbol;
import io.github.mortuusars.chalk.data.ChalkColors;
import io.github.mortuusars.chalk.item.ChalkItem;
import io.github.mortuusars.chalk.item.component.ChalkBoxContents;
import io.github.mortuusars.chalk.menu.ChalkBoxMenu;
import io.github.mortuusars.chalk.network.Packets;
import io.github.mortuusars.chalk.network.packet.OpenCreativeChalkBoxC2SP;
import io.github.mortuusars.chalk.utils.MarkDrawingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChalkBoxItem
extends Item
implements IChalkDrawingTool {
    public static final int SLOTS = 9;
    public static final int CHALK_SLOTS = 8;
    public static final int GLOWINGS_SLOT_INDEX = 8;
    public static final ResourceLocation SELECTED_PROPERTY = Chalk.resource("selected");

    public ChalkBoxItem(Item.Properties properties) {
        super(properties.setNoRepair());
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        return (Boolean)Config.Client.CHALK_BOX_TOOLTIP_CONTENTS.get() != false && !this.getContents(stack).isEmpty() ? Optional.of(this.getContents(stack)) : Optional.empty();
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        if (!((Boolean)Config.Client.CHALK_BOX_TOOLTIP_DETAILS.get()).booleanValue()) {
            return;
        }
        if (!Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"gui.chalk.tooltip.hold_for_details"));
        } else {
            AbstractContainerScreen screen;
            Screen screen2;
            if (Minecraft.getInstance().player != null && (screen2 = Minecraft.getInstance().screen) instanceof AbstractContainerScreen && (screen = (AbstractContainerScreen)screen2).getSlotUnderMouse() != null && screen.getSlotUnderMouse().container instanceof Inventory) {
                tooltipComponents.add((Component)Component.translatable((String)"item.chalk.chalk_box.tooltip.open"));
            }
            tooltipComponents.add((Component)Component.translatable((String)"item.chalk.chalk_box.tooltip.insert"));
            tooltipComponents.add((Component)Component.translatable((String)"item.chalk.chalk_box.tooltip.change_selected"));
        }
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack stack, @NotNull ItemStack otherStack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess slotAccess) {
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        if (otherStack.isEmpty() && slot.container instanceof Inventory) {
            if (player.isCreative()) {
                Packets.sendToServer(new OpenCreativeChalkBoxC2SP(slot.getContainerSlot()), new CustomPacketPayload[0]);
            } else if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.openGUI(serverPlayer, stack);
            }
            return true;
        }
        if (otherStack.getItem() instanceof ChalkItem) {
            for (int i = 0; i < 8; ++i) {
                if (!this.getItemInSlot(stack, i).isEmpty()) continue;
                this.setItemInSlot(stack, i, otherStack.copy());
                player.playSound((SoundEvent)Chalk.SoundEvents.CHALK_BOX_CHANGE.get(), 0.9f, 0.9f + player.level().random.nextFloat() * 0.2f);
                otherStack.setCount(0);
                return true;
            }
        } else if (((Boolean)Config.Common.CHALK_BOX_GLOWING_ENABLED.get()).booleanValue() && otherStack.is(Chalk.Tags.Items.GLOWINGS)) {
            ItemStack existingItem = this.getItemInSlot(stack, 8);
            int glowAmountBefore = this.getGlowAmount(stack);
            if (existingItem.isEmpty()) {
                this.setItemInSlot(stack, 8, otherStack.copy());
                otherStack.setCount(0);
            } else {
                if (existingItem.getCount() >= existingItem.getMaxStackSize() || !ItemStack.isSameItemSameComponents((ItemStack)existingItem, (ItemStack)otherStack)) {
                    return true;
                }
                int insertedAmount = Math.min(otherStack.getCount(), existingItem.getMaxStackSize() - existingItem.getCount());
                if (insertedAmount <= 0) {
                    return true;
                }
                existingItem.setCount(existingItem.getCount() + insertedAmount);
                otherStack.split(insertedAmount);
                this.setItemInSlot(stack, 8, existingItem);
            }
            player.playSound((SoundEvent)Chalk.SoundEvents.CHALK_BOX_CHANGE.get(), 0.9f, 0.9f + player.level().random.nextFloat() * 0.2f);
            if (glowAmountBefore < this.getGlowAmount(stack)) {
                player.playSound((SoundEvent)Chalk.SoundEvents.GLOW_APPLIED.get(), 1.0f, 1.0f);
                player.playSound((SoundEvent)Chalk.SoundEvents.GLOWING.get(), 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return false;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Item item;
        ItemStack chalkBoxStack = context.getItemInHand();
        if (!chalkBoxStack.is((Item)this)) {
            return InteractionResult.FAIL;
        }
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (context.getHand() == InteractionHand.OFF_HAND && (player.getMainHandItem().getItem() instanceof ChalkItem || player.getMainHandItem().is((Item)this))) {
            return InteractionResult.FAIL;
        }
        ItemStack selectedChalk = this.getSelectedChalk(chalkBoxStack);
        if (selectedChalk.isEmpty()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.openGUI(serverPlayer, chalkBoxStack);
            }
            return InteractionResult.SUCCESS;
        }
        MarkDrawingContext drawingContext = this.createDrawingContext(context);
        if (!drawingContext.canDraw() || !((item = selectedChalk.getItem()) instanceof IChalkDrawingTool)) {
            return InteractionResult.FAIL;
        }
        IChalkDrawingTool chalkDrawingTool = (IChalkDrawingTool)item;
        if (player.isSecondaryUseActive()) {
            drawingContext.openSymbolSelectionScreen();
            return InteractionResult.CONSUME;
        }
        Mark mark = drawingContext.createRegularMark(chalkDrawingTool.getMarkColorValue(selectedChalk), this.isGlowing(chalkBoxStack));
        if (this.drawMark(drawingContext, mark)) {
            return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
        }
        return InteractionResult.FAIL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack usedStack = player.getItemInHand(usedHand);
        if (!usedStack.is((Item)this)) {
            return InteractionResultHolder.pass((Object)usedStack);
        }
        if (player.isSecondaryUseActive()) {
            if (!this.rotateSelectedChalk(usedStack)) return InteractionResultHolder.fail((Object)usedStack);
            level.playSound(player, player.position().x, player.position().y, player.position().z, (SoundEvent)Chalk.SoundEvents.CHALK_BOX_CHANGE.get(), SoundSource.PLAYERS, 0.9f, 0.9f + level.random.nextFloat() * 0.2f);
            return InteractionResultHolder.sidedSuccess((Object)usedStack, (boolean)level.isClientSide);
        } else {
            if (!(player instanceof ServerPlayer)) return InteractionResultHolder.sidedSuccess((Object)usedStack, (boolean)level.isClientSide);
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.openGUI(serverPlayer, usedStack);
        }
        return InteractionResultHolder.sidedSuccess((Object)usedStack, (boolean)level.isClientSide);
    }

    public void openGUI(ServerPlayer player, ItemStack chalkBoxStack) {
        if (!(chalkBoxStack.getItem() instanceof ChalkBoxItem)) {
            Chalk.LOGGER.error("Cannot open Chalk Box menu: {} is not a ChalkBoxItem.", (Object)chalkBoxStack);
            return;
        }
        int chalkBoxSlotIndex = player.getInventory().findSlotMatchingItem(chalkBoxStack);
        if (chalkBoxSlotIndex < 0) {
            Chalk.LOGGER.error("Cannot open Chalk Box menu: {} is not found in player's inventory.", (Object)chalkBoxStack);
            return;
        }
        Component title = chalkBoxStack.has(DataComponents.CUSTOM_NAME) ? chalkBoxStack.getHoverName() : Component.translatable((String)"container.chalk.chalk_box");
        SimpleMenuProvider menuProvider = new SimpleMenuProvider((containerID, playerInventory, playerEntity) -> new ChalkBoxMenu(containerID, playerInventory, chalkBoxSlotIndex), title);
        player.openMenu((MenuProvider)menuProvider, buffer -> buffer.writeVarInt(chalkBoxSlotIndex));
        player.level().playSound(null, player.position().x, player.position().y, player.position().z, (SoundEvent)Chalk.SoundEvents.CHALK_BOX_OPEN.get(), SoundSource.PLAYERS, 0.9f, 0.9f + player.level().random.nextFloat() * 0.2f);
    }

    @Override
    public Mark getMark(ItemStack chalkBoxStack, MarkDrawingContext drawingContext, MarkSymbol symbol) {
        DyeColor dyeColor;
        ItemStack selectedChalk = this.getSelectedChalk(chalkBoxStack);
        Item item = selectedChalk.getItem();
        if (item instanceof IChalkDrawingTool) {
            IChalkDrawingTool chalkItem = (IChalkDrawingTool)item;
            dyeColor = chalkItem.getMarkColor(selectedChalk).orElse(DyeColor.WHITE);
        } else {
            dyeColor = DyeColor.WHITE;
        }
        DyeColor color = dyeColor;
        return drawingContext.createMark(ChalkColors.fromDyeColor(color), symbol, this.isGlowing(chalkBoxStack));
    }

    @Override
    public void onMarkDrawn(Player player, InteractionHand hand, BlockPos markBlockPos, BlockState markBlockState) {
        if (player.isCreative()) {
            return;
        }
        ItemStack chalkBoxStack = player.getItemInHand(hand);
        int selectedChalkIndex = this.getContents(chalkBoxStack).getSelectedChalkIndex();
        Preconditions.checkState((selectedChalkIndex >= 0 ? 1 : 0) != 0, (String)"Chalk Box has no selected drawing tool. {}", (Object)chalkBoxStack);
        ItemStack selectedChalk = this.getItemInSlot(chalkBoxStack, selectedChalkIndex);
        selectedChalk.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        this.setItemInSlot(chalkBoxStack, selectedChalkIndex, selectedChalk.isEmpty() ? ItemStack.EMPTY : selectedChalk);
        if (((Boolean)markBlockState.getValue((Property)ChalkMarkBlock.GLOWING)).booleanValue()) {
            this.consumeGlow(chalkBoxStack);
        }
    }

    @NotNull
    public ChalkBoxContents getContents(ItemStack stack) {
        @Nullable ChalkBoxContents contents = (ChalkBoxContents)stack.get(Chalk.DataComponents.CHALK_BOX_CONTENTS);
        return contents != null ? contents : ChalkBoxContents.EMPTY;
    }

    public ItemStack getItemInSlot(ItemStack stack, int slot) {
        Preconditions.checkElementIndex((int)slot, (int)9, (String)("Slot " + slot + " is invalid. Chalk Box has 9 slots."));
        @Nullable ChalkBoxContents contents = (ChalkBoxContents)stack.get(Chalk.DataComponents.CHALK_BOX_CONTENTS);
        return contents != null ? contents.items().get(slot) : ItemStack.EMPTY;
    }

    public ItemStack getSelectedChalk(ItemStack stack) {
        for (int i = 0; i < 8; ++i) {
            ItemStack itemInSlot = this.getItemInSlot(stack, i);
            if (itemInSlot.isEmpty()) continue;
            return itemInSlot;
        }
        return ItemStack.EMPTY;
    }

    public void setItemInSlot(ItemStack chalkBoxStack, int slot, ItemStack stack) {
        Preconditions.checkElementIndex((int)slot, (int)9, (String)("Slot " + slot + " is invalid. Chalk Box has 9 slots."));
        if (!stack.isEmpty()) {
            Preconditions.checkArgument((stack.getItem() instanceof ChalkItem || slot == 8 ? 1 : 0) != 0, (String)"%s cannot be inserted into slot '%s'. Only ChalkItem can be inserted into slots 0-%s.", (Object)stack, (Object)slot, (Object)7);
            Preconditions.checkArgument((stack.is(Chalk.Tags.Items.GLOWINGS) || slot != 8 ? 1 : 0) != 0, (String)"%s cannot be inserted into slot '%s'. Only #chalk:glowings can be inserted into slot {}", (Object)stack, (Object)slot, (Object)8);
        }
        ChalkBoxContents contents = chalkBoxStack.has(Chalk.DataComponents.CHALK_BOX_CONTENTS) ? (ChalkBoxContents)chalkBoxStack.get(Chalk.DataComponents.CHALK_BOX_CONTENTS) : ChalkBoxContents.EMPTY;
        Preconditions.checkState((contents != null ? 1 : 0) != 0);
        ChalkBoxContents.Mutable mutableContents = contents.toMutable();
        mutableContents.setItem(stack, slot);
        chalkBoxStack.set(Chalk.DataComponents.CHALK_BOX_CONTENTS, (Object)mutableContents.toImmutable());
        if (slot == 8) {
            this.updateGlow(chalkBoxStack);
        }
    }

    private boolean rotateSelectedChalk(ItemStack chalkBoxStack) {
        Preconditions.checkArgument((boolean)(chalkBoxStack.getItem() instanceof ChalkBoxItem), (Object)"Item was not a Chalk Box.");
        ChalkBoxContents contents = this.getContents(chalkBoxStack);
        int selectedChalkIndex = this.getContents(chalkBoxStack).getSelectedChalkIndex();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(contents.items().stream().limit(8L).toList());
        int chalks = (int)items.stream().filter(stack -> stack.getItem() instanceof IChalkDrawingTool).count();
        if (selectedChalkIndex < 0 || chalks < 2) {
            return false;
        }
        int rotateAmount = 0;
        for (int i = selectedChalkIndex + 1; i < 8; ++i) {
            if (!(contents.items().get(i).getItem() instanceof IChalkDrawingTool)) continue;
            rotateAmount = i;
            break;
        }
        if (rotateAmount == 0) {
            return false;
        }
        Collections.rotate(items, -rotateAmount);
        items.add(contents.items().get(8));
        chalkBoxStack.set(Chalk.DataComponents.CHALK_BOX_CONTENTS, (Object)contents.toMutable().setItems(items).toImmutable());
        return true;
    }

    public float getSelectedChalkColor(ItemStack stack) {
        ChalkBoxContents contents = this.getContents(stack);
        for (ItemStack item : contents.items()) {
            Item item2 = item.getItem();
            if (!(item2 instanceof ChalkItem)) continue;
            ChalkItem chalkItem = (ChalkItem)item2;
            return chalkItem.getColor().getId() + 1;
        }
        return 0.0f;
    }

    @Override
    public Optional<DyeColor> getMarkColor(ItemStack chalkBoxStack) {
        Optional<DyeColor> optional;
        ItemStack selectedChalk = this.getSelectedChalk(chalkBoxStack);
        Item item = selectedChalk.getItem();
        if (item instanceof IChalkDrawingTool) {
            IChalkDrawingTool drawingTool = (IChalkDrawingTool)item;
            optional = drawingTool.getMarkColor(selectedChalk);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public int getMarkColorValue(ItemStack chalkBoxStack) {
        return this.getMarkColor(chalkBoxStack).map(ChalkColors::fromDyeColor).orElse(-1);
    }

    public boolean isItemValid(ItemStack chalkBoxStack, int slot, @NotNull ItemStack stack) {
        if (slot < 0 || slot >= 9) {
            return false;
        }
        if (slot == 8) {
            return stack.is(Chalk.Tags.Items.GLOWINGS);
        }
        return stack.getItem() instanceof ChalkItem;
    }

    @Override
    public boolean isGlowing(ItemStack chalkBoxStack) {
        return (Boolean)Config.Common.CHALK_BOX_GLOWING_ENABLED.get() != false && this.getContents(chalkBoxStack).glowAmount() > 0;
    }

    public int getGlowAmount(ItemStack chalkBoxStack) {
        return (Boolean)Config.Common.CHALK_BOX_GLOWING_ENABLED.get() != false ? this.getContents(chalkBoxStack).glowAmount() : 0;
    }

    public void consumeGlow(ItemStack chalkBoxStack) {
        this.setGlowAmount(chalkBoxStack, this.getGlowAmount(chalkBoxStack) - 1);
    }

    public void setGlowAmount(ItemStack chalkBoxStack, int glow) {
        ChalkBoxContents.Mutable mutableContents = this.getContents(chalkBoxStack).toMutable();
        mutableContents.setGlowingUses(Math.max(0, glow));
        chalkBoxStack.set(Chalk.DataComponents.CHALK_BOX_CONTENTS, (Object)mutableContents.toImmutable());
        this.updateGlow(chalkBoxStack);
    }

    protected void updateGlow(ItemStack chalkBoxStack) {
        if (this.getGlowAmount(chalkBoxStack) > 0) {
            return;
        }
        ItemStack glowingItemStack = this.getItemInSlot(chalkBoxStack, 8);
        if (!glowingItemStack.isEmpty()) {
            this.setGlowAmount(chalkBoxStack, (Integer)Config.Common.CHALK_BOX_GLOWING_AMOUNT_PER_ITEM.get());
            glowingItemStack.shrink(1);
            this.setItemInSlot(chalkBoxStack, 8, glowingItemStack);
        }
    }
}

