/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.menu;

import com.google.common.base.Preconditions;
import io.github.mortuusars.chalk.item.ChalkBoxItem;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ChalkBoxItemStackHandler
extends ItemStackHandler {
    private final ItemStack chalkBoxStack;
    private final ChalkBoxItem chalkBoxItem;

    public ChalkBoxItemStackHandler(ItemStack chalkBoxStack) {
        super(9);
        Preconditions.checkArgument((boolean)(chalkBoxStack.getItem() instanceof ChalkBoxItem), (String)"{} is not a ChalkBoxItem", (Object)chalkBoxStack);
        this.chalkBoxStack = chalkBoxStack;
        this.chalkBoxItem = (ChalkBoxItem)chalkBoxStack.getItem();
        List<ItemStack> items = this.chalkBoxItem.getContents(chalkBoxStack).items();
        for (int index = 0; index < items.size(); ++index) {
            this.stacks.set(index, (Object)items.get(index));
        }
    }

    public ItemStack getChalkBoxStack() {
        return this.chalkBoxStack;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.chalkBoxItem.isItemValid(this.chalkBoxStack, slot, stack);
    }

    protected void onContentsChanged(int slot) {
        int prevGlowingAmount = this.chalkBoxItem.getGlowAmount(this.chalkBoxStack);
        this.chalkBoxItem.setItemInSlot(this.chalkBoxStack, slot, this.getStackInSlot(slot));
        if (slot == 8 && this.chalkBoxItem.getGlowAmount(this.chalkBoxStack) > prevGlowingAmount) {
            this.stacks.set(slot, (Object)this.chalkBoxItem.getItemInSlot(this.chalkBoxStack, slot));
        }
    }
}

