/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.block;

import com.leclowndu93150.chisel.block.entity.AutoChiselBlockEntity;
import com.leclowndu93150.chisel.init.ChiselBlockEntities;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockAutoChisel
extends BaseEntityBlock {
    public static final MapCodec<BlockAutoChisel> CODEC = BlockAutoChisel.simpleCodec(BlockAutoChisel::new);
    private static final VoxelShape COLLISION_SHAPE = Shapes.or((VoxelShape)BlockAutoChisel.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BlockAutoChisel.box((double)0.0, (double)10.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), BlockAutoChisel.box((double)15.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), BlockAutoChisel.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), BlockAutoChisel.box((double)0.0, (double)10.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), BlockAutoChisel.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape SELECTION_SHAPE = Shapes.block();

    public BlockAutoChisel(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof AutoChiselBlockEntity) {
            AutoChiselBlockEntity autoChisel = (AutoChiselBlockEntity)blockEntity;
            player.openMenu((MenuProvider)autoChisel);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (stack.has(DataComponents.CUSTOM_NAME) && (blockEntity = level.getBlockEntity(pos)) instanceof AutoChiselBlockEntity) {
            AutoChiselBlockEntity autoChisel = (AutoChiselBlockEntity)blockEntity;
            autoChisel.setCustomName(stack.getHoverName());
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof AutoChiselBlockEntity) {
            AutoChiselBlockEntity autoChisel = (AutoChiselBlockEntity)blockEntity;
            autoChisel.dropContents(level, pos);
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SELECTION_SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AutoChiselBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return BlockAutoChisel.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ChiselBlockEntities.AUTO_CHISEL.get()), (lvl, pos, st, be) -> be.tick());
    }
}

