/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.leclowndu93150.chisel.client.util.ClientUtil;
import com.leclowndu93150.chisel.item.ItemOffsetTool;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(modid="chisel", value={Dist.CLIENT})
public class OffsetToolRenderer {
    @SubscribeEvent
    public static void onBlockHighlight(RenderHighlightEvent.Block event) {
        boolean holdingOffsetTool;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        boolean bl = holdingOffsetTool = !mainHand.isEmpty() && mainHand.getItem() instanceof ItemOffsetTool || !offHand.isEmpty() && offHand.getItem() instanceof ItemOffsetTool;
        if (!holdingOffsetTool) {
            return;
        }
        BlockHitResult target = event.getTarget();
        Direction face = target.getDirection();
        BlockPos pos = target.getBlockPos();
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource bufferSource = event.getMultiBufferSource();
        poseStack.pushPose();
        float x = Math.max(0, face.getStepX());
        float y = Math.max(0, face.getStepY());
        float z = Math.max(0, face.getStepZ());
        Vec3 viewport = mc.gameRenderer.getMainCamera().getPosition();
        poseStack.translate(-viewport.x, -viewport.y, -viewport.z);
        poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        Matrix4f mat = poseStack.last().pose();
        VertexConsumer linesBuf = bufferSource.getBuffer(RenderType.lines());
        if (face.getStepX() != 0) {
            linesBuf.addVertex(mat, x, 0.0f, 0.0f).setColor(0, 0, 0, 255).setNormal(0.0f, 1.0f, 0.0f);
            linesBuf.addVertex(mat, x, 1.0f, 1.0f).setColor(0, 0, 0, 255).setNormal(0.0f, 1.0f, 0.0f);
            linesBuf.addVertex(mat, x, 1.0f, 0.0f).setColor(0, 0, 0, 255).setNormal(0.0f, 1.0f, 0.0f);
            linesBuf.addVertex(mat, x, 0.0f, 1.0f).setColor(0, 0, 0, 255).setNormal(0.0f, 1.0f, 0.0f);
        } else if (face.getStepY() != 0) {
            linesBuf.addVertex(mat, 0.0f, y, 0.0f).setColor(0, 0, 0, 255).setNormal(0.0f, 1.0f, 0.0f);
            linesBuf.addVertex(mat, 1.0f, y, 1.0f).setColor(0, 0, 0, 255).setNormal(0.0f, 1.0f, 0.0f);
            linesBuf.addVertex(mat, 1.0f, y, 0.0f).setColor(0, 0, 0, 255).setNormal(0.0f, 1.0f, 0.0f);
            linesBuf.addVertex(mat, 0.0f, y, 1.0f).setColor(0, 0, 0, 255).setNormal(0.0f, 1.0f, 0.0f);
        } else {
            linesBuf.addVertex(mat, 0.0f, 0.0f, z).setColor(0, 0, 0, 255).setNormal(0.0f, 1.0f, 0.0f);
            linesBuf.addVertex(mat, 1.0f, 1.0f, z).setColor(0, 0, 0, 255).setNormal(0.0f, 1.0f, 0.0f);
            linesBuf.addVertex(mat, 1.0f, 0.0f, z).setColor(0, 0, 0, 255).setNormal(0.0f, 1.0f, 0.0f);
            linesBuf.addVertex(mat, 0.0f, 1.0f, z).setColor(0, 0, 0, 255).setNormal(0.0f, 1.0f, 0.0f);
        }
        Vec3 hit = target.getLocation();
        Vec3 localHit = hit.subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        Direction moveDir = OffsetToolRenderer.getMoveDir(face, localHit);
        VertexConsumer triBuf = bufferSource.getBuffer(ClientUtil.OFFSET_OVERLAY);
        int clampedX = Math.max(0, moveDir.getStepX());
        int clampedY = Math.max(0, moveDir.getStepY());
        int clampedZ = Math.max(0, moveDir.getStepZ());
        boolean isX = moveDir.getStepX() != 0;
        boolean isY = moveDir.getStepY() != 0;
        boolean isZ = moveDir.getStepZ() != 0;
        int alpha = 85;
        float offset = 0.001f;
        if (face.getStepX() != 0) {
            float xOff = x + (face.getStepX() > 0 ? offset : -offset);
            triBuf.addVertex(mat, xOff, 0.5f, 0.5f).setColor(255, 255, 255, alpha);
            triBuf.addVertex(mat, xOff, isY ? (float)clampedY : 0.0f, isZ ? (float)clampedZ : 0.0f).setColor(255, 255, 255, alpha);
            triBuf.addVertex(mat, xOff, isY ? (float)clampedY : 1.0f, isZ ? (float)clampedZ : 1.0f).setColor(255, 255, 255, alpha);
        } else if (face.getStepY() != 0) {
            float yOff = y + (face.getStepY() > 0 ? offset : -offset);
            triBuf.addVertex(mat, 0.5f, yOff, 0.5f).setColor(255, 255, 255, alpha);
            triBuf.addVertex(mat, isX ? (float)clampedX : 0.0f, yOff, isZ ? (float)clampedZ : 0.0f).setColor(255, 255, 255, alpha);
            triBuf.addVertex(mat, isX ? (float)clampedX : 1.0f, yOff, isZ ? (float)clampedZ : 1.0f).setColor(255, 255, 255, alpha);
        } else {
            float zOff = z + (face.getStepZ() > 0 ? offset : -offset);
            triBuf.addVertex(mat, 0.5f, 0.5f, zOff).setColor(255, 255, 255, alpha);
            triBuf.addVertex(mat, isX ? (float)clampedX : 0.0f, isY ? (float)clampedY : 0.0f, zOff).setColor(255, 255, 255, alpha);
            triBuf.addVertex(mat, isX ? (float)clampedX : 1.0f, isY ? (float)clampedY : 1.0f, zOff).setColor(255, 255, 255, alpha);
        }
        poseStack.popPose();
    }

    private static Direction getMoveDir(Direction face, Vec3 hitVec) {
        HashMap map = Maps.newHashMap();
        if (face.getStepX() != 0) {
            OffsetToolRenderer.fillMap(map, hitVec.z - (double)((int)hitVec.z), hitVec.y - (double)((int)hitVec.y), Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH);
        } else if (face.getStepY() != 0) {
            OffsetToolRenderer.fillMap(map, hitVec.x - (double)((int)hitVec.x), hitVec.z - (double)((int)hitVec.z), Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);
        } else if (face.getStepZ() != 0) {
            OffsetToolRenderer.fillMap(map, hitVec.x - (double)((int)hitVec.x), hitVec.y - (double)((int)hitVec.y), Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST);
        }
        ArrayList keys = Lists.newArrayList(map.keySet());
        Collections.sort(keys);
        return map.isEmpty() ? Direction.DOWN : (Direction)map.get(keys.get(0));
    }

    private static void fillMap(Map<Double, Direction> map, double x, double y, Direction ... dirs) {
        map.put(Line2D.ptLineDistSq(0.0, 0.0, 1.0, 0.0, x, y), dirs[0]);
        map.put(Line2D.ptLineDistSq(0.0, 1.0, 1.0, 1.0, x, y), dirs[1]);
        map.put(Line2D.ptLineDistSq(0.0, 0.0, 0.0, 1.0, x, y), dirs[2]);
        map.put(Line2D.ptLineDistSq(1.0, 0.0, 1.0, 1.0, x, y), dirs[3]);
    }
}

