/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.compat;

import com.leclowndu93150.chisel.init.ChiselRegistries;
import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class ChiselRebornCompat {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<String> registeredAliases = new HashSet<String>();
    private static final String CHIPPED_INTEGRATION_MODID = "chisel_chipped_integration";
    private static final String ANTIBLOCKS_RECHISELED_MODID = "antiblocksrechiseled";
    private static final String[] COLORS = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    private static final String[] WOOD_TYPES = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "crimson"};
    private static final String[] ROCK_VARIANTS_REBORN = new String[]{"array", "braid", "chaotic_bricks", "chaotic_medium", "chaotic_small", "circular", "cracked", "cracked_bricks", "cut", "dent", "encased_bricks", "french", "jellybean", "large_tile", "layer", "mosaic", "ornate", "panel", "pillar", "prism", "road", "slant", "small_bricks", "soft_bricks", "solid_bricks", "tiles_medium", "tiles_small", "triple_bricks", "twist", "weaver", "zag"};
    private static final String[] PLANK_VARIANTS_REBORN = new String[]{"braid", "crude_horizontal", "crude_paneling", "crude_vertical", "encased", "encased_large", "encased_smooth", "large", "log_bordered", "paneling", "shipping_crate", "smooth", "stacked", "vertical"};

    public static void registerAliases() {
        LOGGER.info("Registering Chisel Reborn compatibility aliases...");
        int count = 0;
        count += ChiselRebornCompat.registerRawVariantAliases();
        count += ChiselRebornCompat.registerRockBlockAliases();
        count += ChiselRebornCompat.registerConcreteAliases();
        count += ChiselRebornCompat.registerWoolAliases();
        count += ChiselRebornCompat.registerPlankAliases();
        count += ChiselRebornCompat.registerGoldAliases();
        count += ChiselRebornCompat.registerIronAliases();
        count += ChiselRebornCompat.registerDiamondAliases();
        count += ChiselRebornCompat.registerEmeraldAliases();
        count += ChiselRebornCompat.registerLapisAliases();
        count += ChiselRebornCompat.registerRedstoneAliases();
        count += ChiselRebornCompat.registerGlassAliases();
        count += ChiselRebornCompat.registerGlowstoneAliases();
        count += ChiselRebornCompat.registerDirtAliases();
        count += ChiselRebornCompat.registerNetherbrickAliases();
        count += ChiselRebornCompat.registerFallbackAliases();
        LOGGER.info("Registered {} Chisel Reborn compatibility aliases", (Object)(count += ChiselRebornCompat.registerTechnicalTransparentAliases()));
        int chippedCount = ChiselRebornCompat.registerChiselChippedIntegrationAliases();
        LOGGER.info("Registered {} Chisel Chipped Integration compatibility aliases", (Object)chippedCount);
        int antiBlocksCount = ChiselRebornCompat.registerAntiBlocksReChiseledAliases();
        LOGGER.info("Registered {} AntiBlocks ReChiseled compatibility aliases", (Object)antiBlocksCount);
    }

    private static String mapVariant(String rebornVariant) {
        return switch (rebornVariant) {
            case "layer" -> "layers";
            case "slant" -> "slanted";
            case "twist" -> "twisted";
            case "large_tile" -> "tiles_large";
            case "french" -> "french_1";
            case "cut" -> "cuts";
            default -> rebornVariant;
        };
    }

    private static String mapPlankVariant(String rebornVariant) {
        return switch (rebornVariant) {
            case "large" -> "large_planks";
            case "crude_horizontal" -> "crude_horizontal_planks";
            case "vertical" -> "vertical_planks";
            case "crude_vertical" -> "crude_vertical_planks";
            case "encased" -> "encased_planks";
            case "encased_large" -> "encased_large_planks";
            case "log_bordered" -> "braced_planks";
            default -> rebornVariant;
        };
    }

    private static int registerRawVariantAliases() {
        int count = 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/andesite", "andesite") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/granite", "granite") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/diorite", "diorite") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/cobblestone", "cobblestone") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/stone", "stone") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/bricks", "bricks") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/sandstone", "sandstone") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/red_sandstone", "red_sandstone") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/end_stone", "end_stone") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/prismarine", "prismarine") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/ice", "ice") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/coal_block", "coal_block") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/deepslate", "deepslate") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/blackstone", "blackstone") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/purpur", "purpur_block") ? 1 : 0;
        count += ChiselRebornCompat.registerAliasToVanilla("raw/quartz", "quartz_block") ? 1 : 0;
        for (String color : COLORS) {
            count += ChiselRebornCompat.registerAliasToVanilla("raw/" + color + "_concrete", color + "_concrete") ? 1 : 0;
        }
        return count;
    }

    private static int registerRockBlockAliases() {
        String modernVariant;
        String[] directMappingBases;
        int count = 0;
        for (String base : directMappingBases = new String[]{"andesite", "bricks", "cobblestone", "diorite", "end_stone", "granite", "prismarine", "sandstone", "red_sandstone", "ice"}) {
            for (String rebornVariant : ROCK_VARIANTS_REBORN) {
                String modernVariant2 = ChiselRebornCompat.mapVariant(rebornVariant);
                count += ChiselRebornCompat.registerAlias(rebornVariant + "/" + base, base + "/" + modernVariant2) ? 1 : 0;
            }
        }
        for (String rebornVariant : ROCK_VARIANTS_REBORN) {
            modernVariant = ChiselRebornCompat.mapVariant(rebornVariant);
            count += ChiselRebornCompat.registerAlias(rebornVariant + "/stone", "stone_bricks/" + modernVariant) ? 1 : 0;
        }
        count += ChiselRebornCompat.registerAlias("largeornate/stone", "stone_bricks/extra/largeornate") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("poison/stone", "stone_bricks/extra/poison") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("sunken/stone", "stone_bricks/extra/sunken") ? 1 : 0;
        for (String rebornVariant : ROCK_VARIANTS_REBORN) {
            modernVariant = ChiselRebornCompat.mapVariant(rebornVariant);
            count += ChiselRebornCompat.registerAlias(rebornVariant + "/quartz", "quartz/" + modernVariant) ? 1 : 0;
        }
        for (String rebornVariant : ROCK_VARIANTS_REBORN) {
            modernVariant = ChiselRebornCompat.mapVariant(rebornVariant);
            count += ChiselRebornCompat.registerAlias(rebornVariant + "/purpur", "purpur/" + modernVariant) ? 1 : 0;
        }
        for (String rebornVariant : ROCK_VARIANTS_REBORN) {
            modernVariant = ChiselRebornCompat.mapVariant(rebornVariant);
            count += ChiselRebornCompat.registerAlias(rebornVariant + "/coal_block", "coal/" + modernVariant) ? 1 : 0;
        }
        count += ChiselRebornCompat.registerAlias("large_bricks/coal_block", "coal/solid_bricks") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("masonry/coal_block", "coal/solid_bricks") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("bevel_creeper/sandstone", "sandstone/extra/bevel_creeper") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("glyphs/sandstone", "sandstone/extra/glyphs") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("small/sandstone", "sandstone/extra/small") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("bevel_skeleton/red_sandstone", "red_sandstone/extra/bevel_skeleton") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("glyphs/red_sandstone", "red_sandstone/extra/glyphs") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("small/red_sandstone", "red_sandstone/extra/small") ? 1 : 0;
    }

    private static int registerConcreteAliases() {
        int count = 0;
        for (String color : COLORS) {
            for (String rebornVariant : ROCK_VARIANTS_REBORN) {
                String modernPath;
                String modernVariant = ChiselRebornCompat.mapVariant(rebornVariant);
                String rebornPath = rebornVariant + "/" + color + "_concrete";
                count += ChiselRebornCompat.registerAlias(rebornPath, modernPath = "concrete_" + color + "/" + modernVariant) ? 1 : 0;
            }
        }
        return count;
    }

    private static int registerWoolAliases() {
        int count = 0;
        String[] woolVariants = new String[]{"legacy", "llama"};
        for (String color : COLORS) {
            for (String variant : woolVariants) {
                String modernPath;
                String rebornPath = variant + "/" + color + "_wool";
                count += ChiselRebornCompat.registerAlias(rebornPath, modernPath = "wool_" + color + "/" + variant) ? 1 : 0;
            }
        }
        return count;
    }

    private static int registerPlankAliases() {
        int count = 0;
        for (String wood : WOOD_TYPES) {
            for (String rebornVariant : PLANK_VARIANTS_REBORN) {
                String modernPath;
                String modernVariant = ChiselRebornCompat.mapPlankVariant(rebornVariant);
                String rebornPath = rebornVariant + "/" + wood + "_planks";
                count += ChiselRebornCompat.registerAlias(rebornPath, modernPath = "planks_" + wood + "/" + modernVariant) ? 1 : 0;
            }
        }
        return count;
    }

    private static int registerGoldAliases() {
        String[] metalVariants;
        int count = 0;
        for (String v : metalVariants = new String[]{"caution", "crate", "thermal", "machine", "badgreggy", "bolted", "scaffold"}) {
            count += ChiselRebornCompat.registerAlias(v + "/gold_block", "gold/" + v) ? 1 : 0;
        }
        count += ChiselRebornCompat.registerAlias("largeingot/gold_block", "gold/large_ingot") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("smallingot/gold_block", "gold/small_ingot") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("brick/gold_block", "gold/brick") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("coin_heads/gold_block", "gold/coin_heads") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("coin_tails/gold_block", "gold/coin_tails") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("crate_dark/gold_block", "gold/crate_dark") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("crate_light/gold_block", "gold/crate_light") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("plates/gold_block", "gold/plates") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("rivets/gold_block", "gold/rivets") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("space/gold_block", "gold/space") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("spaceblack/gold_block", "gold/space_black") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("simple/gold_block", "gold/simple") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("cart/gold_block", "gold/cart") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("star/gold_block", "gold/star") ? 1 : 0;
    }

    private static int registerIronAliases() {
        String[] metalVariants;
        int count = 0;
        for (String v : metalVariants = new String[]{"caution", "crate", "thermal", "machine", "badgreggy", "bolted", "scaffold"}) {
            count += ChiselRebornCompat.registerAlias(v + "/iron_block", "iron/" + v) ? 1 : 0;
        }
        count += ChiselRebornCompat.registerAlias("largeingot/iron_block", "iron/large_ingot") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("smallingot/iron_block", "iron/small_ingot") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("brick/iron_block", "iron/brick") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("coin_heads/iron_block", "iron/coin_heads") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("coin_tails/iron_block", "iron/coin_tails") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("crate_dark/iron_block", "iron/crate_dark") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("crate_light/iron_block", "iron/crate_light") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("plates/iron_block", "iron/plates") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("rivets/iron_block", "iron/rivets") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("space/iron_block", "iron/space") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("spaceblack/iron_block", "iron/space_black") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("simple/iron_block", "iron/simple") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("moon/iron_block", "iron/moon") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("vents/iron_block", "iron/vents") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("gears/iron_block", "iron/vents") ? 1 : 0;
    }

    private static int registerDiamondAliases() {
        int count = 0;
        count += ChiselRebornCompat.registerAlias("embossed/diamond_block", "diamond/terrain_diamond_embossed") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("gem/diamond_block", "diamond/terrain_diamond_gem") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("cells/diamond_block", "diamond/terrain_diamond_cells") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("space/diamond_block", "diamond/terrain_diamond_space") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("spaceblack/diamond_block", "diamond/terrain_diamond_spaceblack") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("simple/diamond_block", "diamond/terrain_diamond_simple") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("bismuth/diamond_block", "diamond/terrain_diamond_bismuth") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("crushed/diamond_block", "diamond/terrain_diamond_crushed") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("four/diamond_block", "diamond/terrain_diamond_four") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("fourornate/diamond_block", "diamond/terrain_diamond_fourornate") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("zelda/diamond_block", "diamond/terrain_diamond_zelda") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("ornatelayer/diamond_block", "diamond/terrain_diamond_ornatelayer") ? 1 : 0;
    }

    private static int registerEmeraldAliases() {
        int count = 0;
        count += ChiselRebornCompat.registerAlias("panel/emerald_block", "emerald/panel") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("panelclassic/emerald_block", "emerald/panelclassic") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("smooth/emerald_block", "emerald/smooth") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("chunky/emerald_block", "emerald/chunk") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("goldborder/emerald_block", "emerald/goldborder") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("zelda/emerald_block", "emerald/zelda") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("cells/emerald_block", "emerald/cell") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("bismuth/emerald_block", "emerald/cellbismuth") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("four/emerald_block", "emerald/four") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("fourornate/emerald_block", "emerald/fourornate") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("ornate/emerald_block", "emerald/ornate") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("masonry/emerald_block", "emerald/masonryemerald") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("circular/emerald_block", "emerald/emeraldcircle") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("prism/emerald_block", "emerald/emeraldprismatic") ? 1 : 0;
    }

    private static int registerLapisAliases() {
        int count = 0;
        count += ChiselRebornCompat.registerAlias("chunky/lapis_block", "lapis/terrain_lapisblock_chunky") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("large_tile/lapis_block", "lapis/terrain_lapisblock_panel") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("zelda/lapis_block", "lapis/terrain_lapisblock_zelda") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("ornate/lapis_block", "lapis/terrain_lapisornate") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("panel/lapis_block", "lapis/terrain_lapistile") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("panelclassic/lapis_block", "lapis/a1_blocklapis_panel") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("smooth/lapis_block", "lapis/a1_blocklapis_smooth") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("ornatelayer/lapis_block", "lapis/a1_blocklapis_ornatelayer") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("masonry/lapis_block", "lapis/masonrylapis") ? 1 : 0;
    }

    private static int registerRedstoneAliases() {
        String[] stoneVariants;
        int count = 0;
        for (String rebornVariant : stoneVariants = new String[]{"array", "braid", "chaotic_medium", "chaotic_small", "circular", "cracked", "cracked_bricks", "dent", "encased_bricks", "french", "jellybean", "large_tile", "layer", "mosaic", "ornate", "panel", "pillar", "prism", "road", "slant", "small_bricks", "soft_bricks", "solid_bricks", "tiles_medium", "tiles_small", "triple_bricks", "twist"}) {
            String modernVariant = ChiselRebornCompat.mapVariant(rebornVariant);
            count += ChiselRebornCompat.registerAlias(rebornVariant + "/redstone_block", "redstone/" + modernVariant) ? 1 : 0;
        }
        return count;
    }

    private static int registerGlassAliases() {
        int count = 0;
        count += ChiselRebornCompat.registerAlias("bubble/glass", "glass/terrain_glassbubble") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("japanese/glass", "glass/japanese") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("dungeon/glass", "glass/terrain_glassdungeon") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("light/glass", "glass/terrain_glasslight") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("noborder/glass", "glass/terrain_glassnoborder") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("ornatesteel/glass", "glass/terrain_glass_ornatesteel") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("ornatesteel_old/glass", "glass/terrain_glass_ornatesteel") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("screen/glass", "glass/terrain_glass_screen") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("shale/glass", "glass/terrain_glassshale") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("steelframe/glass", "glass/terrain_glass_steelframe") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("stone/glass", "glass/terrain_glassstone") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("streak/glass", "glass/terrain_glassstreak") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("thick/glass", "glass/terrain_glass_thickgrid") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("thin/glass", "glass/terrain_glass_thingrid") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("ironfencemodern/glass", "glass/a1_glasswindow_ironfencemodern") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("chrono/glass", "glass/chrono") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("chinese/glass", "glass/chinese2") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("chinese2/glass", "glass/chinese2") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("japanese2/glass", "glass/japanese2") ? 1 : 0;
    }

    private static int registerGlowstoneAliases() {
        String[] stoneVariants;
        int count = 0;
        for (String rebornVariant : stoneVariants = new String[]{"array", "braid", "chaotic_medium", "chaotic_small", "circular", "cracked", "cracked_bricks", "dent", "encased_bricks", "french", "jellybean", "large_tile", "layer", "mosaic", "ornate", "panel", "pillar", "prism", "road", "slant", "small_bricks", "soft_bricks", "solid_bricks", "tiles_medium", "tiles_small", "triple_bricks", "twist"}) {
            String modernVariant = ChiselRebornCompat.mapVariant(rebornVariant);
            count += ChiselRebornCompat.registerAlias(rebornVariant + "/glowstone", "glowstone/" + modernVariant) ? 1 : 0;
        }
        count += ChiselRebornCompat.registerAlias("bismuth/glowstone", "glowstone/extra/bismuth") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("large_tile_bismuth/glowstone", "glowstone/extra/tiles_large_bismuth") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("tiles_medium_bismuth/glowstone", "glowstone/extra/tiles_medium_bismuth") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("neon/glowstone", "glowstone/extra/neon") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("neon_panel/glowstone", "glowstone/extra/neon_panel") ? 1 : 0;
    }

    private static int registerDirtAliases() {
        int count = 0;
        count += ChiselRebornCompat.registerAlias("bricks/dirt", "dirt/bricks") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("bricks2/dirt", "dirt/bricks2") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("bricks3/dirt", "dirt/bricks3") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("chunky/dirt", "dirt/chunky") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("cobble/dirt", "dirt/cobble") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("happy/dirt", "dirt/happy") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("horizontal/dirt", "dirt/horizontal") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("layer/dirt", "dirt/layers") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("panel/dirt", "dirt/plate") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("reinforced/dirt", "dirt/reinforceddirt") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("reinforcedcobble/dirt", "dirt/reinforcedcobbledirt") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("vertical/dirt", "dirt/vert") ? 1 : 0;
    }

    private static int registerNetherbrickAliases() {
        int count = 0;
        count += ChiselRebornCompat.registerAlias("pillar/nether_brick", "netherbrick/a1_netherbrick_brinstar") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("mosaic/nether_brick", "netherbrick/netherfancybricks") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("slant/nether_brick", "netherbrick/a1_netherbrick_red") ? 1 : 0;
    }

    private static int registerFallbackAliases() {
        int count = 0;
        for (String rebornVariant : ROCK_VARIANTS_REBORN) {
            String modernVariant = ChiselRebornCompat.mapVariant(rebornVariant);
            count += ChiselRebornCompat.registerAlias(rebornVariant + "/deepslate", "basalt/" + modernVariant) ? 1 : 0;
        }
        count += ChiselRebornCompat.registerAlias("largeornate/deepslate", "basalt/panel") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("poison/deepslate", "basalt/panel") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("sunken/deepslate", "basalt/panel") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("pillar/blackstone", "basalt/pillar") ? 1 : 0;
    }

    private static int registerTechnicalTransparentAliases() {
        int count = 0;
        count += ChiselRebornCompat.registerAlias("technical/scaffoldtransparent", "technical_transparent/scaffoldtransparent") ? 1 : 0;
        count += ChiselRebornCompat.registerAlias("technical/fanfasttransparent", "technical_transparent/fanfasttransparent") ? 1 : 0;
        return count += ChiselRebornCompat.registerAlias("technical/fanstilltransparent", "technical_transparent/fanstilltransparent") ? 1 : 0;
    }

    private static boolean registerAlias(String fromPath, String toPath) {
        if (registeredAliases.contains(fromPath)) {
            LOGGER.debug("Skipping duplicate alias: {} (already registered)", (Object)fromPath);
            return false;
        }
        registeredAliases.add(fromPath);
        ResourceLocation from = ResourceLocation.fromNamespaceAndPath((String)"chisel", (String)fromPath);
        ResourceLocation to = ResourceLocation.fromNamespaceAndPath((String)"chisel", (String)toPath);
        ChiselRegistries.BLOCKS.addAlias(from, to);
        ChiselRegistries.ITEMS.addAlias(from, to);
        return true;
    }

    private static boolean registerAliasToVanilla(String fromPath, String vanillaBlock) {
        if (registeredAliases.contains(fromPath)) {
            LOGGER.debug("Skipping duplicate alias: {} (already registered)", (Object)fromPath);
            return false;
        }
        registeredAliases.add(fromPath);
        ResourceLocation from = ResourceLocation.fromNamespaceAndPath((String)"chisel", (String)fromPath);
        ResourceLocation to = ResourceLocation.withDefaultNamespace((String)vanillaBlock);
        ChiselRegistries.BLOCKS.addAlias(from, to);
        ChiselRegistries.ITEMS.addAlias(from, to);
        return true;
    }

    private static boolean registerCrossModAlias(String fromMod, String fromPath, String toPath) {
        String key = fromMod + ":" + fromPath;
        if (registeredAliases.contains(key)) {
            return false;
        }
        registeredAliases.add(key);
        ResourceLocation from = ResourceLocation.fromNamespaceAndPath((String)fromMod, (String)fromPath);
        ResourceLocation to = ResourceLocation.fromNamespaceAndPath((String)"chisel", (String)toPath);
        ChiselRegistries.BLOCKS.addAlias(from, to);
        ChiselRegistries.ITEMS.addAlias(from, to);
        return true;
    }

    private static boolean registerCrossModAliasToVanilla(String fromMod, String fromPath, String vanillaBlock) {
        String key = fromMod + ":" + fromPath;
        if (registeredAliases.contains(key)) {
            return false;
        }
        registeredAliases.add(key);
        ResourceLocation from = ResourceLocation.fromNamespaceAndPath((String)fromMod, (String)fromPath);
        ResourceLocation to = ResourceLocation.withDefaultNamespace((String)vanillaBlock);
        ChiselRegistries.BLOCKS.addAlias(from, to);
        ChiselRegistries.ITEMS.addAlias(from, to);
        return true;
    }

    private static int registerChiselChippedIntegrationAliases() {
        String[] otherMetals;
        int count = 0;
        for (String color : COLORS) {
            count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "wool_legacy_" + color, "wool_" + color + "/legacy") ? 1 : 0;
            count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "wool_llama_" + color, "wool_" + color + "/llama") ? 1 : 0;
        }
        for (String color : COLORS) {
            count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "carpet_legacy_" + color, "carpet_" + color + "/legacy") ? 1 : 0;
            count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "carpet_llama_" + color, "carpet_" + color + "/llama") ? 1 : 0;
        }
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_blue_circuits", "factory/tilemosaic") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_blue_framed_circuit", "factory/frameblue") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_blue_wireframe", "factory/wireframeblue") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_circuit", "factory/circuit") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_dotted_rusty_plate", "factory/dots") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_gold_framed_purple_plates", "factory/goldplating") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_gold_plated_circuit", "factory/goldplate") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_grinder", "factory/grinder") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_ice_ice_ice", "factory/iceiceice") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_metalbox", "factory/metalbox") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_metal_column", "factory/column") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_old_vents", "factory/plating") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_orange_white_caution_stripes", "factory/hazardorange") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_purple_wireframe", "factory/wireframe") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_rusty_plate", "factory/rust2") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_segmented_rusty_plates", "factory/rustplates") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_slighly_rusty_plate", "factory/platex") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_vents", "factory/vent") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_very_rusty_plate", "factory/rust") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_wireframe", "factory/wireframewhite") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "factory_yellow_black_caution_stripes", "factory/hazard") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "laboratory_checkered_tiles", "laboratory/checkertile") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "laboratory_console", "laboratory/infocon") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "laboratory_dark_medium_tiles", "laboratory/floortile") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "laboratory_dotted_panel", "laboratory/dottedpanel") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "laboratory_fuzzy_screen", "laboratory/fuzzscreen") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "laboratory_large_steel", "laboratory/largesteel") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "laboratory_large_tiles", "laboratory/largetile") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "laboratory_left_faced_arrows", "laboratory/directionleft") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "laboratory_medium_tiles", "laboratory/smalltile") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "laboratory_right_faced_arrows", "laboratory/directionright") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "laboratory_roundel", "laboratory/roundel") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "laboratory_screen", "laboratory/fuzzscreen") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "laboratory_small_steel", "laboratory/smallsteel") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "laboratory_tiles", "laboratory/floortile") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "laboratory_vents", "laboratory/wallvents") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "laboratory_white_panel", "laboratory/wallpanel") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_cables", "technical/cables") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_caution_framed_plates", "technical/cautiontape") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_engineering_pipes_0", "technical/engineering") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_engineering_pipes_1", "technical/engineering") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_engineering_pipes_2", "technical/engineering") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_engineering_pipes_3", "technical/engineering") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_exhaust_plating", "technical/exhaustplating") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_extremely_corroded_panels", "technical/weatheredgreenpanels") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_extremely_rusted_panels", "technical/weatheredorangepanels") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_fan", "technical/fanfast") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_gears", "technical/spinningstuffanim") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_glowing_vent", "technical/ventglowing") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_grate", "technical/grate") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_industrial_relic", "technical/industrialrelic") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_insulation", "technical/insulationv2") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_large_pipes", "technical/pipeslarge") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_large_rusty_scaffold", "technical/scaffoldlarge") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_make_shift_plating", "technical/makeshiftpanels") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_malfunction_fan", "technical/malfunctionfan") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_massive_fan", "technical/massivefan") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_massive_hexagonal_plating", "technical/massivehexplating") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_megacell", "technical/megacell") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_old_vent", "technical/vent") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_pipes", "technical/piping") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_rusty_bolted_plates", "technical/rustyboltedplates") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_rusty_grate", "technical/graterusty") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_rusty_scaffold", "technical/scaffold") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_small_pipes", "technical/pipessmall") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_still_fan", "technical/fanstill") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_sturdy", "technical/sturdy") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_transparent_fan", "technical_transparent/fanfasttransparent") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_transparent_rusty_scaffold", "technical_transparent/scaffoldtransparent") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_transparent_still_fan", "technical_transparent/fanstilltransparent") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "technical_vent", "technical/vent") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "tyrian_black_scaled_plates", "tyrian/black") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "tyrian_black_strips", "tyrian/black2") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "tyrian_blue_plates", "tyrian/blueplating") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "tyrian_dent", "tyrian/dent") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "tyrian_diagonal_plates", "tyrian/diagonal") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "tyrian_disordered_metal_bits", "tyrian/shining") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "tyrian_disordered_purple_bits", "tyrian/chaotic") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "tyrian_metal_plates", "tyrian/tyrian") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "tyrian_opening", "tyrian/opening") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "tyrian_platform", "tyrian/platform") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "tyrian_purple_plates", "tyrian/softplate") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "tyrian_routes", "tyrian/routes") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "tyrian_rust", "tyrian/rust") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "tyrian_shiny_plate", "tyrian/plate") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "tyrian_shiny_plates", "tyrian/elaborate") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "tyrian_small_uneven_tiles", "tyrian/platetiles") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_iron_bolted", "iron/bolted") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_iron_caution", "iron/caution") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_iron_egregious", "iron/badgreggy") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_iron_industrial_relic", "iron/machine") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_iron_scaffold", "iron/scaffold") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_iron_shipping_crate", "iron/crate") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_iron_thermal", "iron/thermal") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_gold_bolted", "gold/bolted") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_gold_caution", "gold/caution") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_gold_egregious", "gold/badgreggy") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_gold_industrial_relic", "gold/machine") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_gold_scaffold", "gold/scaffold") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_gold_shipping_crate", "gold/crate") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_gold_thermal", "gold/thermal") ? 1 : 0;
        for (String metal : otherMetals = new String[]{"aluminum", "bronze", "cobalt", "copper", "electrum", "invar", "lead", "nickel", "platinum", "silver", "steel", "tin", "uranium"}) {
            count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_" + metal + "_bolted", "metals_" + metal + "/bolted") ? 1 : 0;
            count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_" + metal + "_caution", "metals_" + metal + "/caution") ? 1 : 0;
            count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_" + metal + "_egregious", "metals_" + metal + "/badgreggy") ? 1 : 0;
            count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_" + metal + "_industrial_relic", "metals_" + metal + "/machine") ? 1 : 0;
            count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_" + metal + "_scaffold", "metals_" + metal + "/scaffold") ? 1 : 0;
            count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_" + metal + "_shipping_crate", "metals_" + metal + "/crate") ? 1 : 0;
            count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "metal_" + metal + "_thermal", "metals_" + metal + "/thermal") ? 1 : 0;
        }
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "futura_me_controller", "futura/controller") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "futura_gray_screen", "futura/screen_metallic") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "futura_cyan_screen", "futura/screen_cyan") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "futura_rainbowliciously_wavy", "futura/wavy") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "futura_purple_me_controller", "futura/controller_purple") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "futura_fabulously_wavy", "futura/uber_wavy") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "futura_me_controller_ae_2", "futura/ae2_controller") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "futura_mysterious_cube", "futura/mysterious_cube") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_diamond_bismuth", "diamond/terrain_diamond_bismuth") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_diamond_cells", "diamond/terrain_diamond_cells") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_diamond_crushed", "diamond/terrain_diamond_crushed") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_diamond_embossed", "diamond/terrain_diamond_embossed") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_diamond_gem", "diamond/terrain_diamond_gem") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_diamond_gold_encrusted", "diamond/terrain_diamond_ornatelayer") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_diamond_ornate_tiles", "diamond/terrain_diamond_fourornate") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_diamond_simple", "diamond/terrain_diamond_simple") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_diamond_purple_space", "diamond/terrain_diamond_space") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_diamond_space", "diamond/terrain_diamond_spaceblack") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_diamond_tiles", "diamond/terrain_diamond_four") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_diamond_zelda", "diamond/terrain_diamond_zelda") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_emerald_bismuth", "emerald/cellbismuth") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_emerald_cell", "emerald/cell") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_emerald_circular", "emerald/emeraldcircle") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_emerald_cobble", "emerald/chunk") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_emerald_gold_encrusted", "emerald/goldborder") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_emerald_masonry", "emerald/masonryemerald") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_emerald_ornate", "emerald/ornate") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_emerald_ornate_tiles", "emerald/fourornate") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_emerald_panel", "emerald/panelclassic") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_emerald_prism", "emerald/emeraldprismatic") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_emerald_smooth", "emerald/smooth") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_emerald_tile", "emerald/panel") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_emerald_tiles", "emerald/four") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_emerald_zelda", "emerald/zelda") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_lapis_cobble", "lapis/terrain_lapisblock_chunky") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_lapis_gold_encrusted", "lapis/a1_blocklapis_ornatelayer") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_lapis_masonry", "lapis/masonrylapis") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_lapis_panel", "lapis/terrain_lapistile") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_lapis_shiny_tile", "lapis/a1_blocklapis_panel") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_lapis_smooth", "lapis/a1_blocklapis_smooth") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_lapis_tile", "lapis/terrain_lapisblock_panel") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_lapis_wood_framed", "lapis/terrain_lapisornate") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_lapis_zelda", "lapis/terrain_lapisblock_zelda") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_arrayed_bricks", "redstone/array") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_big_tile", "redstone/tiles_large") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_braid", "redstone/braid") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_bricks", "redstone/solid_bricks") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_circular", "redstone/circular") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_cracked", "redstone/cracked") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_cracked_bricks", "redstone/cracked_bricks") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_dent", "redstone/dent") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_disordered_tiles", "redstone/chaotic_medium") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_encased_bricks", "redstone/encased_bricks") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_french_1", "redstone/french_1") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_french_2", "redstone/french_2") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_jellybean", "redstone/jellybean") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_layers", "redstone/layers") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_mosaic", "redstone/mosaic") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_ornate", "redstone/ornate") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_panel", "redstone/panel") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_pillar", "redstone/pillar") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_prism", "redstone/prism") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_road", "redstone/road") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_slanted", "redstone/slanted") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_small_bricks", "redstone/small_bricks") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_small_disordered_tiles", "redstone/chaotic_small") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_small_tiles", "redstone/tiles_small") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_tiles", "redstone/tiles_medium") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_twisted", "redstone/twisted") ? 1 : 0;
        count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_weathered_bricks", "redstone/soft_bricks") ? 1 : 0;
        return count += ChiselRebornCompat.registerCrossModAlias(CHIPPED_INTEGRATION_MODID, "gem_redstone_wide_bricks", "redstone/triple_bricks") ? 1 : 0;
    }

    private static int registerAntiBlocksReChiseledAliases() {
        int count = 0;
        return count;
    }
}

