/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.data;

import com.leclowndu93150.chisel.data.LenientExistingFileHelper;
import com.leclowndu93150.chisel.data.provider.ChiselBlockStateProvider;
import com.leclowndu93150.chisel.data.provider.ChiselBlockTagsProvider;
import com.leclowndu93150.chisel.data.provider.ChiselItemModelProvider;
import com.leclowndu93150.chisel.data.provider.ChiselItemTagsProvider;
import com.leclowndu93150.chisel.data.provider.ChiselLanguageProvider;
import com.leclowndu93150.chisel.data.provider.ChiselLootTableProvider;
import com.leclowndu93150.chisel.data.provider.ChiselRecipeProvider;
import com.leclowndu93150.chisel.data.provider.ChiselWorldGenProvider;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="chisel", bus=EventBusSubscriber.Bus.MOD)
public class ChiselDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        LenientExistingFileHelper lenientHelper = new LenientExistingFileHelper(Collections.emptyList(), Collections.singleton("chisel"), true, null, null);
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new ChiselBlockStateProvider(output, lenientHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ChiselItemModelProvider(output));
        generator.addProvider(event.includeClient(), (DataProvider)new ChiselLanguageProvider(output));
        ChiselBlockTagsProvider blockTagsProvider = new ChiselBlockTagsProvider(output, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ChiselItemTagsProvider(output, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ChiselRecipeProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ChiselLootTableProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ChiselWorldGenProvider(output, lookupProvider));
        Runtime.getRuntime().addShutdownHook(new Thread(lenientHelper::printMissingSummary));
    }
}

