/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.integration.jei;

import com.leclowndu93150.chisel.Chisel;
import com.leclowndu93150.chisel.api.carving.ICarvingGroup;
import com.leclowndu93150.chisel.carving.CarvingHelper;
import com.leclowndu93150.chisel.init.ChiselItems;
import com.leclowndu93150.chisel.integration.jei.CraftableBlockCache;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ChiselRecipeCategory
implements IRecipeCategory<ICarvingGroup> {
    public static final RecipeType<ICarvingGroup> RECIPE_TYPE = RecipeType.create((String)"chisel", (String)"chiseling", ICarvingGroup.class);
    private static final ResourceLocation TEXTURE_LOC = Chisel.id("textures/chiseljei.png");
    private final IDrawable icon;
    private final IDrawable background;
    private final IDrawable arrowUp;
    private final IDrawable arrowDown;
    @Nullable
    private IRecipeLayoutBuilder layout;
    @Nullable
    private IFocusGroup focus;

    public ChiselRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ChiselItems.IRON_CHISEL.get()));
        this.background = guiHelper.createDrawable(TEXTURE_LOC, 0, 0, 165, 126);
        this.arrowDown = guiHelper.createDrawable(TEXTURE_LOC, 166, 0, 18, 15);
        this.arrowUp = guiHelper.createDrawable(TEXTURE_LOC, 166, 15, 18, 15);
    }

    @Nonnull
    public RecipeType<ICarvingGroup> getRecipeType() {
        return RECIPE_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)"jei.chisel.chiseling");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(ICarvingGroup recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (this.layout == null) {
            return;
        }
        if (this.focus == null || this.focus.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK, RecipeIngredientRole.OUTPUT).count() == 0L) {
            this.arrowDown.draw(guiGraphics, 73, 21);
        } else {
            this.arrowUp.draw(guiGraphics, 73, 21);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, ICarvingGroup group, IFocusGroup focusGroup) {
        int i;
        this.layout = recipeLayout;
        this.focus = focusGroup;
        List<ItemStack> groupStacks = CarvingHelper.getItemsInGroup(group.getItemTag()).stream().map(ItemStack::new).toList();
        IRecipeSlotBuilder inputSlot = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 74, 4);
        if (focusGroup.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK, RecipeIngredientRole.OUTPUT).count() > 0L) {
            inputSlot.addItemStacks(focusGroup.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK, RecipeIngredientRole.OUTPUT).map(f -> (ItemStack)f.getTypedValue().getIngredient()).toList());
        } else {
            inputSlot.addItemStacks(groupStacks);
        }
        int rowWidth = 9;
        int xStart = 3;
        int yStart = 37;
        int maxSlots = 45;
        ArrayList stacks = new ArrayList();
        for (i = 0; i < groupStacks.size(); ++i) {
            int slot = i % maxSlots;
            if (stacks.size() <= slot) {
                stacks.add(new ArrayList());
            }
            ((List)stacks.get(slot)).add(groupStacks.get(i).copy());
        }
        if (groupStacks.size() > maxSlots) {
            int leftover;
            for (int i2 = leftover = groupStacks.size() % maxSlots; i2 < maxSlots; ++i2) {
                ((List)stacks.get(i2)).add(ItemStack.EMPTY);
            }
        }
        for (i = 0; i < stacks.size(); ++i) {
            int x = xStart + i % rowWidth * 18;
            int y = yStart + i / rowWidth * 18;
            recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStacks((List)stacks.get(i));
        }
        ItemStack craftableBlock = CraftableBlockCache.get(group.getId());
        if (!craftableBlock.isEmpty()) {
            recipeLayout.addSlot(RecipeIngredientRole.RENDER_ONLY, 147, 4).addItemStack(craftableBlock);
        }
    }
}

