/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.network.server;

import com.leclowndu93150.chisel.Chisel;
import com.leclowndu93150.chisel.api.IChiselItem;
import com.leclowndu93150.chisel.api.carving.IChiselMode;
import com.leclowndu93150.chisel.carving.ChiselMode;
import com.leclowndu93150.chisel.carving.ChiselModeRegistry;
import com.leclowndu93150.chisel.item.ItemChisel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ChiselModePayload(int slot, String modeName) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChiselModePayload> TYPE = new CustomPacketPayload.Type(Chisel.id("chisel_mode"));
    public static final StreamCodec<FriendlyByteBuf, ChiselModePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ChiselModePayload::slot, (StreamCodec)ByteBufCodecs.STRING_UTF8, ChiselModePayload::modeName, ChiselModePayload::new);

    public ChiselModePayload(int slot, IChiselMode mode) {
        this(slot, mode.name());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                Item patt2$temp;
                IChiselItem chiselItem;
                Item patt1$temp;
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ItemStack stack = player.getInventory().getItem(this.slot);
                IChiselMode mode = ChiselModeRegistry.INSTANCE.getModeByName(this.modeName);
                if (mode == null) {
                    mode = ChiselMode.SINGLE;
                }
                if ((patt1$temp = stack.getItem()) instanceof IChiselItem && (chiselItem = (IChiselItem)patt1$temp).supportsMode((Player)player, stack, mode) && (patt2$temp = stack.getItem()) instanceof ItemChisel) {
                    ItemChisel itemChisel = (ItemChisel)patt2$temp;
                    itemChisel.setMode(stack, mode);
                }
            }
        });
    }
}

