/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cleanview;

import com.mojang.blaze3d.platform.InputConstants;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;

enum Proxy {
    INSTANCE;

    KeyMapping keyToggle = new KeyMapping("key.togglecleanview", InputConstants.Type.KEYSYM, -1, "key.categories.misc");
    boolean lastState = false;
    boolean enabled = true;
    EntityDataAccessor<List<ParticleOptions>> effectParticles = null;
    WeakReference<Entity> lastCam = new WeakReference<Object>(null);

    void handleClientTickEvent(ClientTickEvent.Pre event) {
        boolean state = this.keyToggle.isDown();
        if (state != this.lastState) {
            if (state) {
                this.enabled = !this.enabled;
            }
            this.lastState = state;
        }
        Entity ent = Minecraft.getInstance().getCameraEntity();
        Entity prevEnt = (Entity)this.lastCam.get();
        if (!this.enabled) {
            ent = null;
        }
        if (prevEnt != ent) {
            List<ParticleOptions> particles;
            if (prevEnt instanceof LivingEntity && !(particles = ((LivingEntity)prevEnt).getActiveEffectsMap().values().stream().filter(MobEffectInstance::isVisible).map(MobEffectInstance::getParticleOptions).toList()).isEmpty()) {
                prevEnt.getEntityData().set(this.effectParticles, particles);
            }
            this.lastCam = new WeakReference<Entity>(ent);
        }
        if (ent instanceof LivingEntity) {
            ent.getEntityData().set(this.effectParticles, List.of());
        }
    }

    void init() {
        this.setup();
        NeoForge.EVENT_BUS.addListener(this::handleClientTickEvent);
    }

    void setup() {
        Field f;
        Throwable t = null;
        try {
            f = LivingEntity.class.getDeclaredField("DATA_EFFECT_PARTICLES");
        }
        catch (Throwable t1) {
            t = t1;
            try {
                f = LivingEntity.class.getDeclaredField("f_314048_");
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
                f = null;
            }
        }
        try {
            if (f != null) {
                f.setAccessible(true);
                this.effectParticles = (EntityDataAccessor)f.get(null);
            }
        }
        catch (Throwable t3) {
            if (t == null) {
                t = t3;
            }
            t.addSuppressed(t3);
        }
        if (this.effectParticles == null) {
            throw new IllegalStateException("[CleanView] Failed to acquire specific field for the mod.", t);
        }
    }

    void registerKeyMappings(Consumer<KeyMapping> register) {
        register.accept(this.keyToggle);
    }
}

