/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.recipehandler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredientsAdapter;

public class RecipeDefinition
implements IRecipeDefinition {
    private final Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> inputs;
    private final Map<IngredientComponent<?, ?>, List<Boolean>> inputsReusable;
    private final IMixedIngredients output;

    public RecipeDefinition(Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> inputs, IMixedIngredients output) {
        this(inputs, Maps.newIdentityHashMap(), output);
    }

    public RecipeDefinition(Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> inputs, Map<IngredientComponent<?, ?>, List<Boolean>> inputsReusable, IMixedIngredients output) {
        this.inputs = inputs;
        this.inputsReusable = inputsReusable;
        this.output = output;
        for (Map.Entry<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> entry : this.inputs.entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            throw new IllegalArgumentException(String.format("Invalid RecipeDefinition input, empty list for %s", entry.getKey().getName()));
        }
    }

    @Override
    public Set<IngredientComponent<?, ?>> getInputComponents() {
        return this.inputs.keySet();
    }

    @Override
    public <T, M> List<IPrototypedIngredientAlternatives<T, M>> getInputs(IngredientComponent<T, M> ingredientComponent) {
        return this.inputs.getOrDefault(ingredientComponent, Collections.emptyList());
    }

    @Override
    public <T, M> boolean isInputReusable(IngredientComponent<T, M> ingredientComponent, int index) {
        List<Boolean> values = this.inputsReusable.get(ingredientComponent);
        return values != null && index < values.size() && values.get(index) != false;
    }

    @Override
    public IMixedIngredients getOutput() {
        return this.output;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IRecipeDefinition) {
            IRecipeDefinition that = (IRecipeDefinition)obj;
            if (MixedIngredientsAdapter.identitySetsEqual(this.getInputComponents(), that.getInputComponents()) && this.getOutput().equals(that.getOutput())) {
                for (IngredientComponent<?, ?> component : this.getInputComponents()) {
                    List<IPrototypedIngredientAlternatives<?, ?>> thisInputs = this.getInputs(component);
                    if (!thisInputs.equals(that.getInputs(component))) {
                        return false;
                    }
                    for (int i = 0; i < thisInputs.size(); ++i) {
                        if (this.isInputReusable(component, i) == that.isInputReusable(component, i)) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 0x242 | this.output.hashCode();
    }

    public String toString() {
        return "[RecipeDefinition input: " + this.inputs.toString() + "; inputsReusable: " + this.inputsReusable.toString() + "; output: " + this.output.toString() + "]";
    }

    public static <T, R, M> RecipeDefinition ofAlternatives(IngredientComponent<T, M> component, List<IPrototypedIngredientAlternatives<T, M>> alternatives, IMixedIngredients output) {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        inputs.put(component, alternatives);
        return new RecipeDefinition(inputs, output);
    }

    public static <T, R, M> RecipeDefinition ofIngredients(IngredientComponent<T, M> component, List<List<IPrototypedIngredient<T, M>>> ingredients, IMixedIngredients output) {
        return RecipeDefinition.ofAlternatives(component, ingredients.stream().map(PrototypedIngredientAlternativesList::new).collect(Collectors.toList()), output);
    }

    public static <T, R, M> RecipeDefinition ofIngredient(IngredientComponent<T, M> component, List<IPrototypedIngredient<T, M>> ingredient, IMixedIngredients output) {
        ArrayList ingredients = Lists.newArrayList();
        ingredients.add(ingredient);
        return RecipeDefinition.ofIngredients(component, ingredients, output);
    }

    @Override
    public int compareTo(IRecipeDefinition that) {
        int compOutput = this.getOutput().compareTo(that.getOutput());
        if (compOutput != 0) {
            return compOutput;
        }
        int compComp = MixedIngredients.compareCollection(this.getInputComponents(), that.getInputComponents());
        if (compComp != 0) {
            return compComp;
        }
        for (IngredientComponent<?, ?> component : this.getInputComponents()) {
            int i;
            List<IPrototypedIngredientAlternatives<?, ?>> thisInputs = this.getInputs(component);
            List<IPrototypedIngredientAlternatives<?, ?>> thatInputs = that.getInputs(component);
            if (thisInputs.size() != thatInputs.size()) {
                return thisInputs.size() - thatInputs.size();
            }
            Object[] aArray = thisInputs.toArray();
            Object[] bArray = thatInputs.toArray();
            for (i = 0; i < aArray.length; ++i) {
                int compCol = MixedIngredients.compareCollection(((IPrototypedIngredientAlternatives)aArray[i]).getAlternatives(), ((IPrototypedIngredientAlternatives)bArray[i]).getAlternatives());
                if (compCol == 0) continue;
                return compCol;
            }
            for (i = 0; i < thisInputs.size(); ++i) {
                int compare = Boolean.compare(this.isInputReusable(component, i), that.isInputReusable(component, i));
                if (compare == 0) continue;
                return compare;
            }
        }
        return 0;
    }
}

