/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.ingredient.capability;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.CapabilityRegistry;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class IngredientComponentCapability<T, C>
extends BaseCapability<T, C> {
    private static final CapabilityRegistry<IngredientComponentCapability<?, ?>> registry = new CapabilityRegistry(IngredientComponentCapability::new);
    final Map<IngredientComponent<?, ?>, List<ICapabilityProvider<IngredientComponent<?, ?>, C, T>>> providers = new IdentityHashMap();

    public static <T, C> IngredientComponentCapability<T, C> create(ResourceLocation name, Class<T> typeClass, Class<C> contextClass) {
        return (IngredientComponentCapability)((Object)registry.create(name, typeClass, contextClass));
    }

    public static <T> IngredientComponentCapability<T, Void> createVoid(ResourceLocation name, Class<T> typeClass) {
        return IngredientComponentCapability.create(name, typeClass, Void.TYPE);
    }

    public static synchronized List<IngredientComponentCapability<?, ?>> getAll() {
        return registry.getAll();
    }

    private IngredientComponentCapability(ResourceLocation name, Class<T> typeClass, Class<C> contextClass) {
        super(name, typeClass, contextClass);
    }

    @ApiStatus.Internal
    @Nullable
    public T getCapability(IngredientComponent<?, ?> ingredientComponent, C context) {
        for (ICapabilityProvider provider : this.providers.getOrDefault(ingredientComponent, List.of())) {
            Object ret = provider.getCapability(ingredientComponent, context);
            if (ret == null) continue;
            return (T)ret;
        }
        return null;
    }
}

