/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.gametest;

import com.google.common.collect.Sets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;

@GameTestHolder(value="commoncapabilities")
@PrefixGameTestTemplate(value=false)
public class GameTestsVanillaCapabilitiesRecipeHandler {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerCapBrewingStand(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.BREWING_STAND);
        helper.succeedIf(() -> {
            IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(recipeHandler != null, "Recipe handler does not exist");
            helper.assertValueEqual(recipeHandler.getRecipeInputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), "Input components are incorrect");
            helper.assertValueEqual(recipeHandler.getRecipeOutputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), "Output components are incorrect");
            helper.assertTrue(recipeHandler.getRecipes().size() >= 279, "Recipe count is less than 279");
            for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                helper.assertTrue(recipeHandler.simulate(MixedIngredients.fromRecipeInput(recipe)) != null, "Recipe simulation failed for " + String.valueOf(recipe));
            }
        });
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerCapFurnace(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.FURNACE);
        helper.succeedIf(() -> {
            IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(recipeHandler != null, "Recipe handler does not exist");
            helper.assertValueEqual(recipeHandler.getRecipeInputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), "Input components are incorrect");
            helper.assertValueEqual(recipeHandler.getRecipeOutputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), "Output components are incorrect");
            helper.assertTrue(recipeHandler.getRecipes().size() >= 70, "Recipe count is less than 70");
            for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                helper.assertTrue(recipeHandler.simulate(MixedIngredients.fromRecipeInput(recipe)) != null, "Recipe simulation failed for " + String.valueOf(recipe));
            }
        });
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerCapBlastFurnace(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.BLAST_FURNACE);
        helper.succeedIf(() -> {
            IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(recipeHandler != null, "Recipe handler does not exist");
            helper.assertValueEqual(recipeHandler.getRecipeInputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), "Input components are incorrect");
            helper.assertValueEqual(recipeHandler.getRecipeOutputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), "Output components are incorrect");
            helper.assertTrue(recipeHandler.getRecipes().size() >= 24, "Recipe count is less than 24");
            for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                helper.assertTrue(recipeHandler.simulate(MixedIngredients.fromRecipeInput(recipe)) != null, "Recipe simulation failed for " + String.valueOf(recipe));
            }
        });
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerCapSmoker(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.SMOKER);
        helper.succeedIf(() -> {
            IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(recipeHandler != null, "Recipe handler does not exist");
            helper.assertValueEqual(recipeHandler.getRecipeInputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), "Input components are incorrect");
            helper.assertValueEqual(recipeHandler.getRecipeOutputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), "Output components are incorrect");
            helper.assertTrue(recipeHandler.getRecipes().size() >= 9, "Recipe count is less than 9");
            for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                helper.assertTrue(recipeHandler.simulate(MixedIngredients.fromRecipeInput(recipe)) != null, "Recipe simulation failed for " + String.valueOf(recipe));
            }
        });
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerCapCampFire(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.CAMPFIRE);
        helper.succeedIf(() -> {
            IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(recipeHandler != null, "Recipe handler does not exist");
            helper.assertValueEqual(recipeHandler.getRecipeInputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), "Input components are incorrect");
            helper.assertValueEqual(recipeHandler.getRecipeOutputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), "Output components are incorrect");
            helper.assertTrue(recipeHandler.getRecipes().size() >= 9, "Recipe count is less than 9");
            for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                helper.assertTrue(recipeHandler.simulate(MixedIngredients.fromRecipeInput(recipe)) != null, "Recipe simulation failed for " + String.valueOf(recipe));
            }
        });
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerCapCrafingTable(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.CRAFTING_TABLE);
        helper.succeedIf(() -> {
            IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(recipeHandler != null, "Recipe handler does not exist");
            helper.assertValueEqual(recipeHandler.getRecipeInputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), "Input components are incorrect");
            helper.assertValueEqual(recipeHandler.getRecipeOutputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), "Output components are incorrect");
            helper.assertTrue(recipeHandler.getRecipes().size() >= 888, "Recipe count is less than 888");
            for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                helper.assertTrue(recipeHandler.simulate(MixedIngredients.fromRecipeInput(recipe)) != null, "Recipe simulation failed for " + String.valueOf(recipe));
            }
        });
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerCapStoneCutter(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.STONECUTTER);
        helper.succeedIf(() -> {
            IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(recipeHandler != null, "Recipe handler does not exist");
            helper.assertValueEqual(recipeHandler.getRecipeInputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), "Input components are incorrect");
            helper.assertValueEqual(recipeHandler.getRecipeOutputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), "Output components are incorrect");
            helper.assertTrue(recipeHandler.getRecipes().size() >= 250, "Recipe count is less than 250");
            for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                helper.assertTrue(recipeHandler.simulate(recipe) != null, "Recipe simulation failed for " + String.valueOf(recipe));
            }
        });
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerCapSmithingTable(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.SMITHING_TABLE);
        helper.succeedIf(() -> {
            IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(recipeHandler != null, "Recipe handler does not exist");
            helper.assertValueEqual(recipeHandler.getRecipeInputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), "Input components are incorrect");
            helper.assertValueEqual(recipeHandler.getRecipeOutputComponents(), (Object)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), "Output components are incorrect");
            helper.assertTrue(recipeHandler.getRecipes().size() >= 0, "Recipe count is less than 0");
            for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                helper.assertTrue(recipeHandler.simulate(MixedIngredients.fromRecipeInput(recipe)) != null, "Recipe simulation failed for " + String.valueOf(recipe));
            }
        });
    }
}

