/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.commoncapabilities.api.capability.temperature.ITemperature;

@GameTestHolder(value="commoncapabilities")
@PrefixGameTestTemplate(value=false)
public class GameTestsVanillaCapabilitiesTemperature {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    @GameTest(template="empty10")
    public void testBlockTemperatureCapFurnaceOff(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.FURNACE);
        helper.succeedIf(() -> {
            ITemperature temperature = (ITemperature)helper.getLevel().getCapability(Capabilities.Temperature.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(temperature != null, "Temperature handler does not exist");
            helper.assertValueEqual((Object)temperature.getTemperature(), (Object)273.15, "Temperature does not match");
            helper.assertValueEqual((Object)temperature.getMaximumTemperature(), (Object)Double.MAX_VALUE, "Temperature max does not match");
            helper.assertValueEqual((Object)temperature.getMinimumTemperature(), (Object)273.15, "Temperature min does not match");
            helper.assertValueEqual((Object)temperature.getDefaultTemperature(), (Object)273.15, "Temperature default does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockTemperatureCapFurnaceOn(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.FURNACE);
        FurnaceBlockEntity blockEntity = (FurnaceBlockEntity)helper.getBlockEntity(POS);
        blockEntity.setItem(0, new ItemStack((ItemLike)Blocks.COBBLESTONE));
        blockEntity.setItem(1, new ItemStack((ItemLike)Items.COAL));
        helper.succeedWhen(() -> {
            ITemperature temperature = (ITemperature)helper.getLevel().getCapability(Capabilities.Temperature.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(temperature != null, "Temperature handler does not exist");
            helper.assertValueEqual((Object)temperature.getTemperature(), (Object)1873.15, "Temperature does not match");
            helper.assertValueEqual((Object)temperature.getMaximumTemperature(), (Object)Double.MAX_VALUE, "Temperature max does not match");
            helper.assertValueEqual((Object)temperature.getMinimumTemperature(), (Object)273.15, "Temperature min does not match");
            helper.assertValueEqual((Object)temperature.getDefaultTemperature(), (Object)273.15, "Temperature default does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockTemperatureCapBlastFurnaceOff(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.BLAST_FURNACE);
        helper.succeedIf(() -> {
            ITemperature temperature = (ITemperature)helper.getLevel().getCapability(Capabilities.Temperature.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(temperature != null, "Temperature handler does not exist");
            helper.assertValueEqual((Object)temperature.getTemperature(), (Object)273.15, "Temperature does not match");
            helper.assertValueEqual((Object)temperature.getMaximumTemperature(), (Object)Double.MAX_VALUE, "Temperature max does not match");
            helper.assertValueEqual((Object)temperature.getMinimumTemperature(), (Object)273.15, "Temperature min does not match");
            helper.assertValueEqual((Object)temperature.getDefaultTemperature(), (Object)273.15, "Temperature default does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockTemperatureCapBlastFurnaceOn(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.BLAST_FURNACE);
        BlastFurnaceBlockEntity blockEntity = (BlastFurnaceBlockEntity)helper.getBlockEntity(POS);
        blockEntity.setItem(0, new ItemStack((ItemLike)Blocks.IRON_ORE));
        blockEntity.setItem(1, new ItemStack((ItemLike)Items.COAL));
        helper.succeedWhen(() -> {
            ITemperature temperature = (ITemperature)helper.getLevel().getCapability(Capabilities.Temperature.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(temperature != null, "Temperature handler does not exist");
            helper.assertValueEqual((Object)temperature.getTemperature(), (Object)1073.15, "Temperature does not match");
            helper.assertValueEqual((Object)temperature.getMaximumTemperature(), (Object)Double.MAX_VALUE, "Temperature max does not match");
            helper.assertValueEqual((Object)temperature.getMinimumTemperature(), (Object)273.15, "Temperature min does not match");
            helper.assertValueEqual((Object)temperature.getDefaultTemperature(), (Object)273.15, "Temperature default does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockTemperatureCapSmokerOff(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.SMOKER);
        helper.succeedIf(() -> {
            ITemperature temperature = (ITemperature)helper.getLevel().getCapability(Capabilities.Temperature.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(temperature != null, "Temperature handler does not exist");
            helper.assertValueEqual((Object)temperature.getTemperature(), (Object)273.15, "Temperature does not match");
            helper.assertValueEqual((Object)temperature.getMaximumTemperature(), (Object)Double.MAX_VALUE, "Temperature max does not match");
            helper.assertValueEqual((Object)temperature.getMinimumTemperature(), (Object)273.15, "Temperature min does not match");
            helper.assertValueEqual((Object)temperature.getDefaultTemperature(), (Object)273.15, "Temperature default does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockTemperatureCapSmokerOn(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.SMOKER);
        SmokerBlockEntity blockEntity = (SmokerBlockEntity)helper.getBlockEntity(POS);
        blockEntity.setItem(0, new ItemStack((ItemLike)Items.PORKCHOP));
        blockEntity.setItem(1, new ItemStack((ItemLike)Items.COAL));
        helper.succeedWhen(() -> {
            ITemperature temperature = (ITemperature)helper.getLevel().getCapability(Capabilities.Temperature.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(temperature != null, "Temperature handler does not exist");
            helper.assertValueEqual((Object)temperature.getTemperature(), (Object)1073.15, "Temperature does not match");
            helper.assertValueEqual((Object)temperature.getMaximumTemperature(), (Object)Double.MAX_VALUE, "Temperature max does not match");
            helper.assertValueEqual((Object)temperature.getMinimumTemperature(), (Object)273.15, "Temperature min does not match");
            helper.assertValueEqual((Object)temperature.getDefaultTemperature(), (Object)273.15, "Temperature default does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockTemperatureCapCampfireOff(GameTestHelper helper) {
        helper.setBlock(POS, (BlockState)Blocks.CAMPFIRE.defaultBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)));
        helper.succeedIf(() -> {
            ITemperature temperature = (ITemperature)helper.getLevel().getCapability(Capabilities.Temperature.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(temperature != null, "Temperature handler does not exist");
            helper.assertValueEqual((Object)temperature.getTemperature(), (Object)273.15, "Temperature does not match");
            helper.assertValueEqual((Object)temperature.getMaximumTemperature(), (Object)1373.15, "Temperature max does not match");
            helper.assertValueEqual((Object)temperature.getMinimumTemperature(), (Object)273.15, "Temperature min does not match");
            helper.assertValueEqual((Object)temperature.getDefaultTemperature(), (Object)273.15, "Temperature default does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockTemperatureCapCampfireOn(GameTestHelper helper) {
        helper.setBlock(POS, (BlockState)Blocks.CAMPFIRE.defaultBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(true)));
        helper.succeedWhen(() -> {
            ITemperature temperature = (ITemperature)helper.getLevel().getCapability(Capabilities.Temperature.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(temperature != null, "Temperature handler does not exist");
            helper.assertValueEqual((Object)temperature.getTemperature(), (Object)1373.15, "Temperature does not match");
            helper.assertValueEqual((Object)temperature.getMaximumTemperature(), (Object)1373.15, "Temperature max does not match");
            helper.assertValueEqual((Object)temperature.getMinimumTemperature(), (Object)273.15, "Temperature min does not match");
            helper.assertValueEqual((Object)temperature.getDefaultTemperature(), (Object)273.15, "Temperature default does not match");
        });
    }

    @GameTest(template="empty10")
    public void testItemTemperatureCapBucketEmpty(GameTestHelper helper) {
        ItemStack itemStack = new ItemStack((ItemLike)Items.BUCKET);
        helper.succeedIf(() -> {
            ITemperature temperature = (ITemperature)itemStack.getCapability(Capabilities.Temperature.ITEM);
            helper.assertTrue(temperature != null, "Temperature handler does not exist");
            helper.assertValueEqual((Object)temperature.getTemperature(), (Object)0.0, "Temperature does not match");
            helper.assertValueEqual((Object)temperature.getMaximumTemperature(), (Object)Double.MAX_VALUE, "Temperature max does not match");
            helper.assertValueEqual((Object)temperature.getMinimumTemperature(), (Object)273.15, "Temperature min does not match");
            helper.assertValueEqual((Object)temperature.getDefaultTemperature(), (Object)0.0, "Temperature default does not match");
        });
    }

    @GameTest(template="empty10")
    public void testItemTemperatureCapBucketWater(GameTestHelper helper) {
        ItemStack itemStack = new ItemStack((ItemLike)Items.WATER_BUCKET);
        helper.succeedIf(() -> {
            ITemperature temperature = (ITemperature)itemStack.getCapability(Capabilities.Temperature.ITEM);
            helper.assertTrue(temperature != null, "Temperature handler does not exist");
            helper.assertValueEqual((Object)temperature.getTemperature(), (Object)300.0, "Temperature does not match");
            helper.assertValueEqual((Object)temperature.getMaximumTemperature(), (Object)Double.MAX_VALUE, "Temperature max does not match");
            helper.assertValueEqual((Object)temperature.getMinimumTemperature(), (Object)273.15, "Temperature min does not match");
            helper.assertValueEqual((Object)temperature.getDefaultTemperature(), (Object)300.0, "Temperature default does not match");
        });
    }

    @GameTest(template="empty10")
    public void testItemTemperatureCapBucketLava(GameTestHelper helper) {
        ItemStack itemStack = new ItemStack((ItemLike)Items.LAVA_BUCKET);
        helper.succeedIf(() -> {
            ITemperature temperature = (ITemperature)itemStack.getCapability(Capabilities.Temperature.ITEM);
            helper.assertTrue(temperature != null, "Temperature handler does not exist");
            helper.assertValueEqual((Object)temperature.getTemperature(), (Object)1300.0, "Temperature does not match");
            helper.assertValueEqual((Object)temperature.getMaximumTemperature(), (Object)Double.MAX_VALUE, "Temperature max does not match");
            helper.assertValueEqual((Object)temperature.getMinimumTemperature(), (Object)273.15, "Temperature min does not match");
            helper.assertValueEqual((Object)temperature.getDefaultTemperature(), (Object)1300.0, "Temperature default does not match");
        });
    }
}

