/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.commoncapabilities.api.capability.work.IWorker;

@GameTestHolder(value="commoncapabilities")
@PrefixGameTestTemplate(value=false)
public class GameTestsVanillaCapabilitiesWorker {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    @GameTest(template="empty10")
    public void testBlockWorkerCapFurnaceOff(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.FURNACE);
        helper.succeedIf(() -> {
            IWorker worker = (IWorker)helper.getLevel().getCapability(Capabilities.Worker.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(worker != null, "Worker does not exist");
            helper.assertValueEqual((Object)worker.hasWork(), (Object)false, "Worker has work does not match");
            helper.assertValueEqual((Object)worker.canWork(), (Object)false, "Worker can work does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockWorkerCapFurnaceOn(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.FURNACE);
        FurnaceBlockEntity blockEntity = (FurnaceBlockEntity)helper.getBlockEntity(POS);
        blockEntity.setItem(0, new ItemStack((ItemLike)Blocks.COBBLESTONE));
        blockEntity.setItem(1, new ItemStack((ItemLike)Items.COAL));
        helper.succeedWhen(() -> {
            IWorker worker = (IWorker)helper.getLevel().getCapability(Capabilities.Worker.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(worker != null, "Worker does not exist");
            helper.assertValueEqual((Object)worker.hasWork(), (Object)true, "Worker has work does not match");
            helper.assertValueEqual((Object)worker.canWork(), (Object)true, "Worker can work does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockWorkerCapFurnaceLit(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.FURNACE);
        FurnaceBlockEntity blockEntity = (FurnaceBlockEntity)helper.getBlockEntity(POS);
        blockEntity.setItem(1, new ItemStack((ItemLike)Items.COAL));
        helper.succeedWhen(() -> {
            IWorker worker = (IWorker)helper.getLevel().getCapability(Capabilities.Worker.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(worker != null, "Worker does not exist");
            helper.assertValueEqual((Object)worker.hasWork(), (Object)false, "Worker has work does not match");
            helper.assertValueEqual((Object)worker.canWork(), (Object)true, "Worker can work does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockWorkerCapBlastFurnaceOff(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.BLAST_FURNACE);
        helper.succeedIf(() -> {
            IWorker worker = (IWorker)helper.getLevel().getCapability(Capabilities.Worker.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(worker != null, "Worker does not exist");
            helper.assertValueEqual((Object)worker.hasWork(), (Object)false, "Worker has work does not match");
            helper.assertValueEqual((Object)worker.canWork(), (Object)false, "Worker can work does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockWorkerCapBlastFurnaceOn(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.BLAST_FURNACE);
        BlastFurnaceBlockEntity blockEntity = (BlastFurnaceBlockEntity)helper.getBlockEntity(POS);
        blockEntity.setItem(0, new ItemStack((ItemLike)Blocks.IRON_ORE));
        blockEntity.setItem(1, new ItemStack((ItemLike)Items.COAL));
        helper.succeedWhen(() -> {
            IWorker worker = (IWorker)helper.getLevel().getCapability(Capabilities.Worker.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(worker != null, "Worker does not exist");
            helper.assertValueEqual((Object)worker.hasWork(), (Object)true, "Worker has work does not match");
            helper.assertValueEqual((Object)worker.canWork(), (Object)true, "Worker can work does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockWorkerCapSmokerOff(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.SMOKER);
        helper.succeedIf(() -> {
            IWorker worker = (IWorker)helper.getLevel().getCapability(Capabilities.Worker.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(worker != null, "Worker does not exist");
            helper.assertValueEqual((Object)worker.hasWork(), (Object)false, "Worker has work does not match");
            helper.assertValueEqual((Object)worker.canWork(), (Object)false, "Worker can work does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockWorkerCapSmokerOn(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.SMOKER);
        SmokerBlockEntity blockEntity = (SmokerBlockEntity)helper.getBlockEntity(POS);
        blockEntity.setItem(0, new ItemStack((ItemLike)Items.PORKCHOP));
        blockEntity.setItem(1, new ItemStack((ItemLike)Items.COAL));
        helper.succeedWhen(() -> {
            IWorker worker = (IWorker)helper.getLevel().getCapability(Capabilities.Worker.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(worker != null, "Worker does not exist");
            helper.assertValueEqual((Object)worker.hasWork(), (Object)true, "Worker has work does not match");
            helper.assertValueEqual((Object)worker.canWork(), (Object)true, "Worker can work does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockWorkerCapCampfireOff(GameTestHelper helper) {
        helper.setBlock(POS, (BlockState)Blocks.CAMPFIRE.defaultBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)));
        helper.succeedIf(() -> {
            IWorker worker = (IWorker)helper.getLevel().getCapability(Capabilities.Worker.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(worker != null, "Worker does not exist");
            helper.assertValueEqual((Object)worker.hasWork(), (Object)false, "Worker has work does not match");
            helper.assertValueEqual((Object)worker.canWork(), (Object)false, "Worker can work does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockWorkerCapCampfireOn(GameTestHelper helper) {
        helper.setBlock(POS, (BlockState)Blocks.CAMPFIRE.defaultBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(true)));
        helper.succeedWhen(() -> {
            IWorker worker = (IWorker)helper.getLevel().getCapability(Capabilities.Worker.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(worker != null, "Worker does not exist");
            helper.assertValueEqual((Object)worker.hasWork(), (Object)false, "Worker has work does not match");
            helper.assertValueEqual((Object)worker.canWork(), (Object)true, "Worker can work does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockWorkerCapCampfireFilled(GameTestHelper helper) {
        helper.setBlock(POS, (BlockState)Blocks.CAMPFIRE.defaultBlockState().setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)));
        CampfireBlockEntity blockEntity = (CampfireBlockEntity)helper.getBlockEntity(POS);
        blockEntity.placeFood((LivingEntity)helper.makeMockPlayer(GameType.SURVIVAL), new ItemStack((ItemLike)Items.PORKCHOP), 10);
        helper.succeedWhen(() -> {
            IWorker worker = (IWorker)helper.getLevel().getCapability(Capabilities.Worker.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(worker != null, "Worker does not exist");
            helper.assertValueEqual((Object)worker.hasWork(), (Object)true, "Worker has work does not match");
            helper.assertValueEqual((Object)worker.canWork(), (Object)false, "Worker can work does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockWorkerCapBrewingstandOff(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.BREWING_STAND);
        helper.succeedIf(() -> {
            IWorker worker = (IWorker)helper.getLevel().getCapability(Capabilities.Worker.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(worker != null, "Worker does not exist");
            helper.assertValueEqual((Object)worker.hasWork(), (Object)false, "Worker has work does not match");
            helper.assertValueEqual((Object)worker.canWork(), (Object)false, "Worker can work does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockWorkerCapBrewingstandFueled(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.BREWING_STAND);
        BrewingStandBlockEntity blockEntity = (BrewingStandBlockEntity)helper.getBlockEntity(POS);
        blockEntity.fuel = 10;
        helper.succeedIf(() -> {
            IWorker worker = (IWorker)helper.getLevel().getCapability(Capabilities.Worker.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(worker != null, "Worker does not exist");
            helper.assertValueEqual((Object)worker.hasWork(), (Object)false, "Worker has work does not match");
            helper.assertValueEqual((Object)worker.canWork(), (Object)true, "Worker can work does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockWorkerCapBrewingstandValidInput(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.BREWING_STAND);
        BrewingStandBlockEntity blockEntity = (BrewingStandBlockEntity)helper.getBlockEntity(POS);
        ItemStack waterBottle = new ItemStack((ItemLike)Items.POTION);
        waterBottle.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WATER));
        blockEntity.setItem(0, waterBottle);
        blockEntity.setItem(1, waterBottle);
        blockEntity.setItem(2, waterBottle);
        blockEntity.setItem(3, new ItemStack((ItemLike)Items.NETHER_WART));
        helper.succeedIf(() -> {
            IWorker worker = (IWorker)helper.getLevel().getCapability(Capabilities.Worker.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(worker != null, "Worker does not exist");
            helper.assertValueEqual((Object)worker.hasWork(), (Object)true, "Worker has work does not match");
            helper.assertValueEqual((Object)worker.canWork(), (Object)false, "Worker can work does not match");
        });
    }
}

