/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.client.room;

import dev.compactmods.gander.level.VirtualLevel;
import dev.compactmods.gander.render.geometry.BakedLevel;
import dev.compactmods.gander.render.geometry.LevelBakery;
import dev.compactmods.machines.api.attachment.CMDataAttachments;
import dev.compactmods.machines.client.room.MachineRoomScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;

public class ClientRoomPacketHandler {
    public static void handleBlockData(StructureTemplate blocks) {
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        if (screen instanceof MachineRoomScreen) {
            MachineRoomScreen mrs = (MachineRoomScreen)screen;
            AABB bounds = AABB.of((BoundingBox)blocks.getBoundingBox(new StructurePlaceSettings(), BlockPos.ZERO));
            VirtualLevel virtualLevel = new VirtualLevel(Minecraft.getInstance().level.registryAccess(), true, level -> {
                level.refreshBlockEntityModels();
                BakedLevel bakedLevel = LevelBakery.bakeVertices((Level)level, (AABB)bounds, (Vector3f)new Vector3f());
                mrs.updateScene(bakedLevel);
            });
            virtualLevel.setBounds(bounds);
            blocks.placeInWorld((ServerLevelAccessor)virtualLevel, BlockPos.ZERO, BlockPos.ZERO, new StructurePlaceSettings().setKnownShape(true), RandomSource.create(), 2);
            virtualLevel.refreshBlockEntityModels();
            BakedLevel bakedLevel = LevelBakery.bakeVertices((Level)virtualLevel, (AABB)bounds, (Vector3f)new Vector3f());
            mrs.updateScene(bakedLevel);
        }
    }

    public static void handleRoomSync(String roomCode) {
        Minecraft mc = Minecraft.getInstance();
        mc.player.setData(CMDataAttachments.CURRENT_ROOM_CODE, (Object)roomCode);
    }
}

