/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.graph.node;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.feather.node.Node;
import dev.compactmods.machines.api.machine.MachineColor;
import dev.compactmods.machines.api.room.RoomInstance;
import dev.compactmods.machines.api.room.spatial.IRoomBoundaries;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class RoomRegistrationNode
extends Record
implements Node<Data>,
IRoomBoundaries {
    private final UUID id;
    private final Data data;
    public static final Codec<RoomRegistrationNode> CODEC = RecordCodecBuilder.create(i -> i.group((App)UUIDUtil.CODEC.fieldOf("id").forGetter(RoomRegistrationNode::id), (App)Data.CODEC.fieldOf("data").forGetter(RoomRegistrationNode::data)).apply((Applicative)i, RoomRegistrationNode::new));

    public RoomRegistrationNode(UUID id, Data data) {
        this.id = id;
        this.data = data;
    }

    public String code() {
        return this.data.code;
    }

    public MachineColor defaultMachineColor() {
        return this.data.defaultMachineColor;
    }

    public AABB outerBounds() {
        return this.data.boundaries;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{RoomRegistrationNode.class, "id;data", "id", "data"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RoomRegistrationNode.class, "id;data", "id", "data"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RoomRegistrationNode.class, "id;data", "id", "data"}, this, o);
    }

    public UUID id() {
        return this.id;
    }

    public Data data() {
        return this.data;
    }

    public record Data(String code, MachineColor defaultMachineColor, AABB boundaries) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("code").forGetter(Data::code), (App)MachineColor.CODEC.fieldOf("color").forGetter(Data::defaultMachineColor), (App)Vec3.CODEC.fieldOf("dimensions").forGetter(Data::dimensions), (App)Vec3.CODEC.fieldOf("center").forGetter(x -> x.boundaries.getCenter())).apply((Applicative)i, Data::new));

        public Data(RoomInstance inst) {
            this(inst.code(), inst.defaultMachineColor(), inst.boundaries().outerBounds());
        }

        private Data(String code, MachineColor defaultMachineColor, Vec3 dimensions, Vec3 center) {
            this(code, defaultMachineColor, AABB.ofSize((Vec3)center, (double)dimensions.x(), (double)dimensions.y(), (double)dimensions.z()));
        }

        private Vec3 dimensions() {
            return new Vec3(this.boundaries.getXsize(), this.boundaries.getYsize(), this.boundaries.getZsize());
        }
    }
}

