/*
 * Decompiled with CFR 0.152.
 */
package net.sashiro.compressedblocks.neoforge.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.sashiro.compressedblocks.neoforge.data.providers.CBBlockStateProvider;
import net.sashiro.compressedblocks.neoforge.data.providers.CBBlockTagsProvider;
import net.sashiro.compressedblocks.neoforge.data.providers.CBItemModelProvider;
import net.sashiro.compressedblocks.neoforge.data.providers.CBItemTagsProvider;
import net.sashiro.compressedblocks.neoforge.data.providers.CBLanguageProvider;
import net.sashiro.compressedblocks.neoforge.data.providers.CBLootTableProvider;
import net.sashiro.compressedblocks.neoforge.data.providers.CBRecipeProvider;

@EventBusSubscriber(modid="compressedblocks", bus=EventBusSubscriber.Bus.MOD)
public class CBNeoForgeDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent e) {
        DataGenerator gen = e.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        ExistingFileHelper existingFileHelper = e.getExistingFileHelper();
        CompletableFuture lookupProvider = e.getLookupProvider();
        gen.addProvider(true, (DataProvider)new CBBlockStateProvider(packOutput, existingFileHelper));
        gen.addProvider(true, (DataProvider)new CBItemModelProvider(packOutput, existingFileHelper));
        gen.addProvider(true, (DataProvider)new CBLanguageProvider(packOutput, "en_us"));
        gen.addProvider(true, (DataProvider)new CBRecipeProvider(packOutput, lookupProvider));
        gen.addProvider(true, (DataProvider)CBLootTableProvider.create(packOutput, lookupProvider));
        TagsProvider tagsProvider = (TagsProvider)gen.addProvider(true, (DataProvider)new CBBlockTagsProvider(packOutput, lookupProvider, "compressedblocks", existingFileHelper));
        gen.addProvider(true, (DataProvider)new CBItemTagsProvider(packOutput, lookupProvider, tagsProvider.contentsGetter(), "compressedblocks", existingFileHelper));
    }
}

