/*
 * Decompiled with CFR 0.152.
 */
package net.manmaed.cottonly.datagenerators;

import java.util.concurrent.CompletableFuture;
import net.manmaed.cottonly.blocks.CBlocks;
import net.manmaed.cottonly.items.CItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

public class CottonTagsProvider {
    public static void addTags(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture completableFuture = event.getLookupProvider();
        CottonBlockTags blockTag = new CottonBlockTags(packOutput, completableFuture, fileHelper);
        generator.addProvider(true, (DataProvider)blockTag);
        generator.addProvider(true, (DataProvider)new CottonItemTags(packOutput, completableFuture, blockTag.contentsGetter(), fileHelper));
    }

    static class CottonBlockTags
    extends BlockTagsProvider {
        public CottonBlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "cottonly", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider lookup) {
            this.tag(BlockTags.CROPS).add((Object)((Block)CBlocks.COTTON_PLANT.get()));
        }
    }

    static class CottonItemTags
    extends ItemTagsProvider {
        public CottonItemTags(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(packOutput, completableFuture, blockTagProvider, "cottonly", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider lookup) {
            this.tag(ItemTags.DYEABLE).add((Object)((Item)CItems.COTTON_HAT.get()));
            this.tag(ItemTags.DYEABLE).add((Object)((Item)CItems.COTTON_SHIRT.get()));
            this.tag(ItemTags.DYEABLE).add((Object)((Item)CItems.COTTON_TROUSERS.get()));
            this.tag(ItemTags.DYEABLE).add((Object)((Item)CItems.COTTON_SOCKS.get()));
            this.tag(ItemTags.VILLAGER_PLANTABLE_SEEDS).add((Object)((Item)CItems.COTTON_SEED.get()));
            this.tag(Tags.Items.SEEDS).add((Object)((Item)CItems.COTTON_SEED.get()));
            this.tag(Tags.Items.CROPS).add((Object)((Item)CItems.COTTON_BALL.get()));
        }
    }
}

