/*
 * Decompiled with CFR 0.152.
 */
package com.ofekn.crafting_on_a_stick;

import com.mojang.logging.LogUtils;
import com.ofekn.crafting_on_a_stick.COASConfig;
import com.ofekn.crafting_on_a_stick.COASUtils;
import com.ofekn.crafting_on_a_stick.ItemOnAStick;
import com.ofekn.crafting_on_a_stick.MinecraftMenuBuilder;
import com.ofekn.crafting_on_a_stick.api.Ref;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.CartographyTableMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.LoomMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class ModItems {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Items REGISTER = DeferredRegister.createItems((String)"crafting_on_a_stick");
    public static final DeferredItem<ItemOnAStick> CRAFTING_TABLE = ModItems.createSimpleItem(Blocks.CRAFTING_TABLE, "crafting", (a, b, c) -> new CraftingMenu(a, b, c){

        public boolean stillValid(Player player) {
            return ModItems.doPlayerHave(player, CRAFTING_TABLE);
        }

        public void removed(Player player) {
            ModItems.onContainerClosed(player, CRAFTING_TABLE, (AbstractContainerMenu)this, 1, 9);
            super.removed(player);
        }
    });
    public static final DeferredItem<ItemOnAStick> LOOM = ModItems.createSimpleItem(Blocks.LOOM, "loom", (a, b, c) -> new LoomMenu(a, b, c){

        public boolean stillValid(Player player) {
            return ModItems.doPlayerHave(player, LOOM);
        }
    });
    public static final DeferredItem<ItemOnAStick> GRINDSTONE = ModItems.createSimpleItem(Blocks.GRINDSTONE, "grindstone_title", (a, b, c) -> new GrindstoneMenu(a, b, c){

        public boolean stillValid(Player player) {
            return ModItems.doPlayerHave(player, GRINDSTONE);
        }
    });
    public static final DeferredItem<ItemOnAStick> CARTOGRAPHY_TABLE = ModItems.createSimpleItem(Blocks.CARTOGRAPHY_TABLE, "cartography_table", (a, b, c) -> new CartographyTableMenu(a, b, c){

        public boolean stillValid(Player player) {
            return ModItems.doPlayerHave(player, CARTOGRAPHY_TABLE);
        }
    });
    public static final DeferredItem<ItemOnAStick> STONECUTTER = ModItems.createSimpleItem(Blocks.STONECUTTER, "stonecutter", (a, b, c) -> new StonecutterMenu(a, b, c){

        public boolean stillValid(Player player) {
            return ModItems.doPlayerHave(player, STONECUTTER);
        }
    });
    public static final DeferredItem<ItemOnAStick> SMITHING_TABLE = ModItems.createSimpleItem(Blocks.SMITHING_TABLE, "upgrade", (a, b, c) -> new SmithingMenu(a, b, c){

        public boolean stillValid(Player player) {
            return ModItems.doPlayerHave(player, SMITHING_TABLE);
        }
    });
    public static final DeferredItem<ItemOnAStick> ANVIL = ModItems.createAnvil(Blocks.ANVIL);
    public static final DeferredItem<ItemOnAStick> CHIPPED_ANVIL = ModItems.createAnvil(Blocks.CHIPPED_ANVIL);
    public static final DeferredItem<ItemOnAStick> DAMAGED_ANVIL = ModItems.createAnvil(Blocks.DAMAGED_ANVIL);

    private ModItems() {
    }

    private static Optional<Ref<ItemStack>> searchInventory(Player player, DeferredItem<ItemOnAStick> itemReg, Predicate<ItemStack> filter) {
        Item item = (Item)itemReg.get();
        List<Ref<ItemStack>> inventory = COASUtils.getFullInventory(player);
        for (Ref<ItemStack> ref : inventory) {
            ItemStack invStack = ref.get();
            if (invStack.isEmpty() || invStack.getItem() != item || !filter.test(invStack)) continue;
            return Optional.of(ref);
        }
        return Optional.empty();
    }

    private static boolean doPlayerHave(Player player, DeferredItem<ItemOnAStick> itemReg) {
        return ModItems.searchInventory(player, itemReg, stack -> true).isPresent();
    }

    private static void onContainerClosed(Player player, DeferredItem<ItemOnAStick> itemReg, AbstractContainerMenu menu, int offset, int slotCount) {
        if (!COASConfig.getStoreItems()) {
            return;
        }
        ModItems.searchInventory(player, itemReg, stack -> !stack.has(DataComponents.CONTAINER)).ifPresent(ref -> {
            ItemStack stack = (ItemStack)ref.get();
            ItemContainerContents result = ModItems.getWorkbenchContent(menu, offset, slotCount);
            stack.set(DataComponents.CONTAINER, (Object)result);
            ref.set(stack);
        });
    }

    private static boolean shouldKeepItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.getItem().canFitInsideContainerItems();
    }

    @Nullable
    private static ItemContainerContents getWorkbenchContent(AbstractContainerMenu menu, int offset, int slotCount) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < offset; ++i) {
            result.add(ItemStack.EMPTY);
        }
        boolean hasItems = false;
        for (int i = 0; i < slotCount; ++i) {
            Slot slot = menu.getSlot(offset + i);
            ItemStack stack = slot.getItem();
            if (!ModItems.shouldKeepItem(stack)) {
                result.add(ItemStack.EMPTY);
                continue;
            }
            hasItems = true;
            result.add(stack);
            slot.set(ItemStack.EMPTY);
        }
        if (!hasItems) {
            return null;
        }
        return ItemContainerContents.fromItems(result);
    }

    private static DeferredItem<ItemOnAStick> createSimpleItem(Block block, String containerName, MinecraftMenuBuilder builder) {
        return ModItems.createItem(block, path -> new ItemOnAStick((String)path, containerName, builder));
    }

    private static <T extends Item> DeferredItem<T> createItem(Block block, Function<String, T> itemConstructor) {
        ResourceKey blockKey = (ResourceKey)BuiltInRegistries.BLOCK.getResourceKey((Object)block).orElseThrow();
        String path = blockKey.location().getPath();
        return REGISTER.register(path, () -> (Item)itemConstructor.apply(path));
    }

    private static DeferredItem<ItemOnAStick> createAnvil(Block block) {
        MinecraftMenuBuilder builder = (a, b, c) -> new AnvilMenu(a, b, c){

            public boolean stillValid(Player player) {
                return ModItems.doPlayerHave(player, DAMAGED_ANVIL) || ModItems.doPlayerHave(player, CHIPPED_ANVIL) || ModItems.doPlayerHave(player, ANVIL);
            }

            protected void onTake(Player p_150474_, ItemStack p_150475_) {
                if (!p_150474_.getAbilities().instabuild) {
                    p_150474_.giveExperienceLevels(-this.getCost());
                }
                float breakChance = CommonHooks.onAnvilRepair((Player)p_150474_, (ItemStack)p_150475_, (ItemStack)this.inputSlots.getItem(0), (ItemStack)this.inputSlots.getItem(1));
                this.inputSlots.setItem(0, ItemStack.EMPTY);
                if (this.repairItemCountCost > 0) {
                    ItemStack itemstack = this.inputSlots.getItem(1);
                    if (!itemstack.isEmpty() && itemstack.getCount() > this.repairItemCountCost) {
                        itemstack.shrink(this.repairItemCountCost);
                        this.inputSlots.setItem(1, itemstack);
                    } else {
                        this.inputSlots.setItem(1, ItemStack.EMPTY);
                    }
                } else {
                    this.inputSlots.setItem(1, ItemStack.EMPTY);
                }
                this.setMaximumCost(0L);
                this.access.execute((p_150479_, p_150480_) -> p_150479_.levelEvent(ModItems.damageAnvil(p_150474_, breakChance) ? 1029 : 1030, p_150480_, 0));
            }
        };
        return ModItems.createItem(block, path -> new ItemOnAStick((String)path, "repair", builder){

            @Override
            public ItemStack getWheelRepresentative(Player player, ItemStack stack) {
                return stack.transmuteCopy(ANVIL, 1);
            }
        });
    }

    private static boolean damageAnvil(Player player, float breakChance) {
        if (player.getAbilities().instabuild || player.getRandom().nextFloat() >= breakChance) {
            return false;
        }
        Optional<Ref<ItemStack>> anvilRef = ModItems.searchInventory(player, DAMAGED_ANVIL, stack -> true);
        if (anvilRef.isPresent()) {
            Ref<ItemStack> ref = anvilRef.get();
            ref.set(ItemStack.EMPTY);
            return true;
        }
        anvilRef = ModItems.searchInventory(player, CHIPPED_ANVIL, stack -> true);
        if (anvilRef.isPresent()) {
            Ref<ItemStack> ref = anvilRef.get();
            ref.set(ref.get().transmuteCopy(DAMAGED_ANVIL));
            return false;
        }
        anvilRef = ModItems.searchInventory(player, ANVIL, stack -> true);
        if (anvilRef.isPresent()) {
            Ref<ItemStack> ref = anvilRef.get();
            ref.set(ref.get().transmuteCopy(CHIPPED_ANVIL));
            return false;
        }
        LOGGER.warn("failed to get anvil to damage for {}", (Object)player);
        return false;
    }
}

