/*
 * Decompiled with CFR 0.152.
 */
package com.ofekn.crafting_on_a_stick.client;

import com.ofekn.crafting_on_a_stick.client.WheelLayoutSupplier;
import com.ofekn.crafting_on_a_stick.client.WheelPolygon;
import org.joml.Vector2f;

public enum PolygonalWheelLayout implements WheelLayoutSupplier
{
    INSTANCE;


    @Override
    public WheelPolygon[] apply(int numOptions) {
        if (numOptions == 0) {
            return new WheelPolygon[0];
        }
        int numAround = numOptions - 1;
        Vector2f[] points = new Vector2f[numAround * 2];
        float anglePerSection = (float)Math.PI * 2 / (float)numAround;
        float r1 = 32.0f;
        float r2 = 64.0f;
        for (int i = 0; i < numAround; ++i) {
            float rad = ((float)i - 0.5f) * anglePerSection;
            float dx = org.joml.Math.sin((float)rad);
            float dy = -org.joml.Math.cos((float)rad);
            points[i] = new Vector2f(r1 * dx, r1 * dy);
            points[i + numAround] = new Vector2f(r2 * dx, r2 * dy);
        }
        WheelPolygon[] result = new WheelPolygon[numOptions];
        Vector2f[] innerPoints = new Vector2f[numAround];
        for (int i = 0; i < numAround; ++i) {
            innerPoints[i] = points[numAround - i - 1];
        }
        result[0] = new WheelPolygon(innerPoints, new Vector2f(0.0f, 0.0f));
        float r = 48.0f;
        for (int i = 0; i < numAround; ++i) {
            float rad = (float)i * anglePerSection;
            float dx = org.joml.Math.sin((float)rad);
            float dy = -org.joml.Math.cos((float)rad);
            Vector2f center = new Vector2f(r * dx, r * dy);
            int i2 = (i + 1) % numAround;
            result[i + 1] = new WheelPolygon(new Vector2f[]{points[i + numAround], points[i], points[i2], points[i2 + numAround]}, center);
        }
        return result;
    }

    public String getSerializedName() {
        return "polygonal";
    }
}

