/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.compat;

import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;

public class SophisticatedStorageCompat {
    public static Component fixDisplayName(BlockEntity blockEntity) {
        MutableComponent mutableComponent;
        if (blockEntity instanceof WoodStorageBlockEntity) {
            WoodStorageBlockEntity woodStorage = (WoodStorageBlockEntity)blockEntity;
            String translationKey = Util.makeDescriptionId((String)"block", (ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)woodStorage.getBlockState().getBlock()));
            if (woodStorage.getCustomName() != null) {
                return woodStorage.getCustomName();
            }
            return (Component)woodStorage.getWoodType().map(woodType -> {
                MutableComponent woodName = Component.translatable((String)("wood_name.sophisticatedstorage." + woodType.name().toLowerCase(Locale.ROOT)));
                return Component.translatable((String)translationKey, (Object[])new Object[]{woodName, " "});
            }).orElseGet(() -> Component.translatable((String)translationKey, (Object[])new Object[]{"", ""}));
        }
        if (blockEntity instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)blockEntity;
            mutableComponent = menuProvider.getDisplayName();
        } else {
            mutableComponent = blockEntity.getBlockState().getBlock().getName();
        }
        return mutableComponent;
    }
}

