/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.compat.framedblocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.satherov.crystalix.common.block.CrystalixGlass;
import dev.satherov.crystalix.common.item.CrystalixWand;
import dev.satherov.crystalix.common.properties.CSProperties;
import dev.satherov.crystalix.compat.framedblocks.CrystalixGlassCamoContainer;
import dev.satherov.crystalix.core.CSRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.camo.TriggerRegistrar;
import xfacthd.framedblocks.api.camo.block.AbstractBlockCamoContainer;
import xfacthd.framedblocks.api.camo.block.AbstractBlockCamoContainerFactory;
import xfacthd.framedblocks.api.util.CamoMessageVerbosity;
import xfacthd.framedblocks.api.util.ConfigView;
import xfacthd.framedblocks.api.util.Utils;

final class CrystalixGlassCamoContainerFactory
extends AbstractBlockCamoContainerFactory<CrystalixGlassCamoContainer> {
    private static final MapCodec<CrystalixGlassCamoContainer> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)BlockState.CODEC.fieldOf("state").forGetter(AbstractBlockCamoContainer::getState), (App)Codec.INT.fieldOf("color").forGetter(CrystalixGlassCamoContainer::getTintColor)).apply((Applicative)inst, CrystalixGlassCamoContainer::new));
    private static final StreamCodec<RegistryFriendlyByteBuf, CrystalixGlassCamoContainer> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY), AbstractBlockCamoContainer::getState, (StreamCodec)ByteBufCodecs.INT, CrystalixGlassCamoContainer::getTintColor, CrystalixGlassCamoContainer::new);
    private static final int DEFAULT_TINT = 0xFFFFFF;

    CrystalixGlassCamoContainerFactory() {
    }

    protected CrystalixGlassCamoContainer createContainer(BlockState camoState, Level level, BlockPos pos, Player player, ItemStack stack) {
        return CrystalixGlassCamoContainerFactory.createContainer(camoState, CrystalixWand.find(player), 0xFFFFFF);
    }

    private static CrystalixGlassCamoContainer createContainer(BlockState camoState, ItemStack wandStack, int tintColor) {
        if (!((Boolean)wandStack.getOrDefault(CSRegistry.APPLY_COLORLESS, (Object)false)).booleanValue()) {
            tintColor = (Integer)wandStack.getOrDefault(CSRegistry.COLOR, (Object)0xFFFFFF);
        }
        return new CrystalixGlassCamoContainer(camoState, tintColor);
    }

    @Nullable
    protected BlockState getStateFromItemStack(Level level, BlockPos pos, Player player, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            return CrystalixGlassCamoContainerFactory.applyWandModifiers(item2.getBlock().defaultBlockState(), CrystalixWand.find(player));
        }
        return null;
    }

    private static BlockState applyWandModifiers(BlockState state, ItemStack wand) {
        Block block = state.getBlock();
        if (!(block instanceof CrystalixGlass)) {
            return state;
        }
        CrystalixGlass glass = (CrystalixGlass)block;
        BlockState newState = (BlockState)((BlockState)((BlockState)glass.fromStack(state, wand).setValue((Property)CrystalixGlass.WATERLOGGABLE, (Comparable)Boolean.valueOf(false))).setValue((Property)CrystalixGlass.REDSTONE, (Comparable)Boolean.valueOf(false))).setValue(CrystalixGlass.GHOST, (Comparable)((Object)CSProperties.Ghost.BLOCK_ALL));
        CSProperties.Light light = (CSProperties.Light)((Object)newState.getValue(CrystalixGlass.LIGHT));
        if (light != CSProperties.Light.NONE && light != CSProperties.Light.LIGHT) {
            newState = (BlockState)newState.setValue(CrystalixGlass.LIGHT, (Comparable)((Object)CSProperties.Light.NONE));
        }
        return newState;
    }

    protected CrystalixGlassCamoContainer copyContainerWithState(CrystalixGlassCamoContainer container, BlockState newCamoState) {
        return new CrystalixGlassCamoContainer(newCamoState, container.getTintColor());
    }

    protected ItemStack createItemStack(Level level, BlockPos pos, Player player, ItemStack stack, CrystalixGlassCamoContainer container) {
        return this.dropCamo(container);
    }

    public ItemStack dropCamo(CrystalixGlassCamoContainer container) {
        return new ItemStack((ItemLike)container.getState().getBlock());
    }

    public boolean canApplyInCraftingRecipe(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            return this.isValidBlock(item2.getBlock().defaultBlockState(), (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO, null);
        }
        return false;
    }

    public CrystalixGlassCamoContainer applyCamoInCraftingRecipe(ItemStack stack) {
        BlockItem item;
        BlockState state;
        Item item2 = stack.getItem();
        if (item2 instanceof BlockItem && this.isValidBlock(state = (item = (BlockItem)item2).getBlock().defaultBlockState(), (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO, null)) {
            return new CrystalixGlassCamoContainer(state, 0xFFFFFF);
        }
        throw new IllegalStateException("applyCamoInCraftingRecipe() called without canApplyInCraftingRecipe() check");
    }

    public ItemStack getCraftingRemainder(ItemStack stack) {
        if (!ConfigView.Server.INSTANCE.shouldConsumeCamoItem()) {
            return stack.copyWithCount(1);
        }
        return ItemStack.EMPTY;
    }

    public CrystalixGlassCamoContainer handleInteraction(Level level, BlockPos pos, Player player, CrystalixGlassCamoContainer camo, ItemStack stack, InteractionHand hand) {
        if (stack.is(CSRegistry.WAND)) {
            BlockState state = CrystalixGlassCamoContainerFactory.applyWandModifiers(camo.getState(), stack);
            return CrystalixGlassCamoContainerFactory.createContainer(state, stack, camo.getTintColor());
        }
        return camo;
    }

    protected boolean isValidBlock(BlockState camoState, BlockGetter level, BlockPos pos, @Nullable Player player) {
        if (!(camoState.getBlock() instanceof CrystalixGlass)) {
            return false;
        }
        if (camoState.is(Utils.BLOCK_BLACKLIST)) {
            CrystalixGlassCamoContainerFactory.displayValidationMessage((Player)player, (Component)MSG_BLACKLISTED, (CamoMessageVerbosity)CamoMessageVerbosity.DEFAULT);
            return false;
        }
        return true;
    }

    public boolean canTriviallyConvertToItemStack() {
        return true;
    }

    protected void writeToNetwork(CompoundTag tag, CrystalixGlassCamoContainer container) {
        tag.putInt("state", Block.getId((BlockState)container.getState()));
        tag.putInt("color", container.getTintColor());
    }

    protected CrystalixGlassCamoContainer readFromNetwork(CompoundTag tag) {
        return new CrystalixGlassCamoContainer(Block.stateById((int)tag.getInt("state")), tag.getInt("color"));
    }

    public MapCodec<CrystalixGlassCamoContainer> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, CrystalixGlassCamoContainer> streamCodec() {
        return STREAM_CODEC;
    }

    public void registerTriggerItems(TriggerRegistrar registrar) {
        CSRegistry.ENTRIES.values().stream().map(Holder::value).map(Block::asItem).forEach(arg_0 -> ((TriggerRegistrar)registrar).registerApplicationItem(arg_0));
        registrar.registerRemovalItem((Item)Utils.FRAMED_HAMMER.value());
    }
}

