/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.config;

import dev.satherov.crystalix.config.ConfigEnum;
import dev.satherov.crystalix.config.annotation.Config;
import dev.satherov.crystalix.config.annotation.ConfigVal;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.neoforged.fml.ModList;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigLoader.class);
    private final List<Cache> caches = new ArrayList<Cache>();

    public static ConfigLoader create() {
        return new ConfigLoader();
    }

    public void discover(FMLModContainer container) {
        HashMap<ModConfig.Type, List> configs = new HashMap<ModConfig.Type, List>();
        for (ModFileScanData data : ModList.get().getAllScanData()) {
            for (ModFileScanData.AnnotationData annotation : data.getAnnotations()) {
                if (!annotation.annotationType().equals((Object)Type.getType(Config.class))) continue;
                try {
                    Class<?> clazz = Class.forName(annotation.clazz().getClassName());
                    Config config = clazz.getAnnotation(Config.class);
                    configs.computeIfAbsent(config.value(), type -> new ArrayList()).add(clazz);
                }
                catch (ClassNotFoundException e) {
                    log.error("Failed to load config class {}", (Object)annotation.clazz().getClassName(), (Object)e);
                }
            }
        }
        configs.forEach((type, list) -> list.forEach(clazz -> {
            Cache cache = new Cache();
            ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
            this.generate((Class<?>)clazz, cache, builder);
            ModConfigSpec spec = builder.build();
            cache.setSpec(spec);
            this.caches.add(cache);
            container.registerConfig(type, (IConfigSpec)spec, "crystalix/crystalix-" + type.extension() + ".toml");
        }));
    }

    public void update(IConfigSpec spec) {
        this.caches.forEach(cache -> {
            if (cache.getSpec() == spec) {
                cache.getValues().forEach((field, value) -> {
                    try {
                        field.setAccessible(true);
                        field.set(null, value.get());
                    }
                    catch (IllegalAccessException e) {
                        log.error("Failed to update config field {}", (Object)field.getName(), (Object)e);
                    }
                });
            }
        });
    }

    protected void generate(Class<?> clazz, Cache cache, ModConfigSpec.Builder builder) {
        for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
            if (!clazz2.isAnnotationPresent(Config.Group.class)) continue;
            Config.Group group = clazz2.getAnnotation(Config.Group.class);
            String name = group.value().isEmpty() ? clazz2.getSimpleName() : group.value();
            builder.push(name);
            this.generate(clazz2, cache, builder);
            builder.pop();
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredFields()) {
            if (!((AccessibleObject)annotatedElement).isAnnotationPresent(ConfigVal.class)) continue;
            ConfigVal val = ((Field)annotatedElement).getAnnotation(ConfigVal.class);
            try {
                ModConfigSpec.ConfigValue spec;
                ((Field)annotatedElement).setAccessible(true);
                Object obj = ((Field)annotatedElement).get(null);
                if (((AccessibleObject)annotatedElement).isAnnotationPresent(ConfigVal.String.class)) {
                    if (obj == null) {
                        throw new NullPointerException("Config Field " + ((Field)annotatedElement).getName() + " is null");
                    }
                    if (!(obj instanceof String)) {
                        throw new IllegalArgumentException("Config Field " + ((Field)annotatedElement).getName() + " is not a String");
                    }
                    value = (String)obj;
                    builder.comment(" " + val.comment());
                    builder.comment(" Default: " + (String)value);
                    spec = builder.define(val.name(), value);
                } else if (((AccessibleObject)annotatedElement).isAnnotationPresent(ConfigVal.Boolean.class)) {
                    if (obj == null) {
                        throw new NullPointerException("Config Field " + ((Field)annotatedElement).getName() + " is null");
                    }
                    if (!(obj instanceof Boolean)) {
                        throw new IllegalArgumentException("Config Field " + ((Field)annotatedElement).getName() + " is not a Boolean");
                    }
                    value = (Boolean)obj;
                    builder.comment(" " + val.comment());
                    builder.comment(" Default: " + (Boolean)value);
                    spec = builder.define(val.name(), value);
                } else if (((AccessibleObject)annotatedElement).isAnnotationPresent(ConfigVal.Integer.class)) {
                    entry = ((Field)annotatedElement).getAnnotation(ConfigVal.Integer.class);
                    if (obj == null) {
                        throw new NullPointerException("Config Field " + ((Field)annotatedElement).getName() + " is null");
                    }
                    if (!(obj instanceof Integer)) {
                        throw new IllegalArgumentException("Config Field " + ((Field)annotatedElement).getName() + " is not an Integer");
                    }
                    value = (Integer)obj;
                    builder.comment(" " + val.comment());
                    spec = builder.defineInRange(val.name(), ((Integer)value).intValue(), entry.min(), entry.max());
                } else if (((AccessibleObject)annotatedElement).isAnnotationPresent(ConfigVal.Long.class)) {
                    entry = ((Field)annotatedElement).getAnnotation(ConfigVal.Long.class);
                    if (obj == null) {
                        throw new NullPointerException("Config Field " + ((Field)annotatedElement).getName() + " is null");
                    }
                    if (!(obj instanceof Long)) {
                        throw new IllegalArgumentException("Config Field " + ((Field)annotatedElement).getName() + " is not a Long");
                    }
                    value = (Long)obj;
                    builder.comment(" " + val.comment());
                    spec = builder.defineInRange(val.name(), ((Long)value).longValue(), entry.min(), entry.max());
                } else if (((AccessibleObject)annotatedElement).isAnnotationPresent(ConfigVal.Double.class)) {
                    entry = ((Field)annotatedElement).getAnnotation(ConfigVal.Double.class);
                    if (obj == null) {
                        throw new NullPointerException("Config Field " + ((Field)annotatedElement).getName() + " is null");
                    }
                    if (!(obj instanceof Double)) {
                        throw new IllegalArgumentException("Config Field " + ((Field)annotatedElement).getName() + " is not a Double");
                    }
                    value = (Double)obj;
                    builder.comment(" " + val.comment());
                    spec = builder.defineInRange(val.name(), ((Double)value).doubleValue(), entry.min(), entry.max());
                } else if (((AccessibleObject)annotatedElement).isAnnotationPresent(ConfigVal.Enum.class)) {
                    entry = ((Field)annotatedElement).getAnnotation(ConfigVal.Enum.class);
                    if (obj == null) {
                        throw new NullPointerException("Config Field " + ((Field)annotatedElement).getName() + " is null");
                    }
                    if (!(obj instanceof ConfigEnum)) {
                        throw new IllegalArgumentException("Config Field " + ((Field)annotatedElement).getName() + " is not a Config Enum");
                    }
                    value = (ConfigEnum)obj;
                    builder.comment(" " + val.comment());
                    builder.comment(" Default: " + String.valueOf(obj));
                    Arrays.stream(entry.value().getEnumConstants()).forEach(e -> {
                        ConfigEnum cfg = (ConfigEnum)((Object)e);
                        builder.comment(" " + cfg.name() + " - " + cfg.comment());
                    });
                    spec = builder.defineEnum(val.name(), (Enum)value);
                } else {
                    throw new IllegalArgumentException("Field is annotated with @ConfigVal, but has no defined type");
                }
                cache.values.put((Field)annotatedElement, spec);
            }
            catch (IllegalAccessException e2) {
                log.error("Failed to access field {}", (Object)((Field)annotatedElement).getName(), (Object)e2);
            }
            catch (NullPointerException e3) {
                log.error("Config Field value {} is null or not static", (Object)((Field)annotatedElement).getName(), (Object)e3);
            }
        }
    }

    protected static class Cache {
        public ModConfigSpec spec;
        public Map<Field, ModConfigSpec.ConfigValue<?>> values = new HashMap();

        @Generated
        public Cache() {
        }

        @Generated
        public ModConfigSpec getSpec() {
            return this.spec;
        }

        @Generated
        public void setSpec(ModConfigSpec spec) {
            this.spec = spec;
        }

        @Generated
        public Map<Field, ModConfigSpec.ConfigValue<?>> getValues() {
            return this.values;
        }
    }
}

