/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.cyclopscore.helper.IModHelpers;

public interface IBlockGui {
    default public void writeExtraGuiData(FriendlyByteBuf packetBuffer, Level world, Player player, BlockPos blockPos, BlockHitResult rayTraceResult) {
    }

    @Nullable
    default public Stat<ResourceLocation> getOpenStat() {
        return null;
    }

    public static InteractionResult onBlockActivatedHook(IBlockGui block, IBlockContainerProvider blockContainerProvider, BlockState blockState, Level world, BlockPos blockPos, Player player, BlockHitResult rayTraceResult) {
        MenuProvider containerProvider;
        if (player.isCrouching()) {
            return InteractionResult.PASS;
        }
        if (!world.isClientSide() && (containerProvider = blockContainerProvider.get(blockState, world, blockPos)) != null) {
            IModHelpers.get().getMinecraftHelpers().openMenu((ServerPlayer)player, containerProvider, packetBuffer -> block.writeExtraGuiData((FriendlyByteBuf)packetBuffer, world, player, blockPos, rayTraceResult));
            Stat<ResourceLocation> openStat = block.getOpenStat();
            if (openStat != null) {
                player.awardStat(openStat);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static interface IBlockContainerProvider {
        @Nullable
        public MenuProvider get(BlockState var1, Level var2, BlockPos var3);
    }
}

