/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.config.ConfigHandlerNeoForge;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeActionForge;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.ModBaseCommon;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.item.ItemInformationProviderCommon;

@EventBusSubscriber(modid="cyclopscore", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class BlockActionNeoForge
extends ConfigurableTypeActionForge<BlockConfig, Block> {
    protected static final List<BlockConfig> MODEL_ENTRIES = Lists.newArrayList();
    protected static final List<BlockConfig> COLOR_ENTRIES = Lists.newArrayList();

    public static void register(@Nullable BiFunction<BlockConfig, Block, ? extends Item> itemBlockConstructor, BlockConfig config, @Nullable Callable<?> callback) {
        BlockActionNeoForge.register(config, itemBlockConstructor == null ? callback : null);
        if (itemBlockConstructor != null) {
            ItemConfig itemConfig = new ItemConfig((ModBase<?>)config.getMod(), config.getNamedId(), (Function<ItemConfig, ? extends Item>)((Function<ItemConfig, Item>)iConfig -> {
                Item itemBlock = (Item)itemBlockConstructor.apply(config, (Block)config.getInstance());
                Objects.requireNonNull(itemBlock, "Received a null item for the item block constructor of " + config.getNamedId());
                return itemBlock;
            }));
            ((ConfigHandlerNeoForge)((ModBase)config.getMod()).getConfigHandler()).registerToRegistry(BuiltInRegistries.ITEM, itemConfig, () -> {
                config.setItemInstance((Item)itemConfig.getInstance());
                try {
                    if (callback != null) {
                        callback.call();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            });
        }
    }

    @Override
    public void onRegisterForgeFilled(BlockConfig eConfig) {
        BlockActionNeoForge.register(eConfig.getItemConstructor(), eConfig, () -> {
            eConfig.onForgeRegistered();
            this.polish(eConfig);
            return null;
        });
    }

    public static void handleDynamicBlockModel(BlockConfig extendedConfig) {
        MODEL_ENTRIES.add(extendedConfig);
    }

    protected void polish(BlockConfig config) {
        for (ItemStack itemStack : config.getDefaultCreativeTabEntriesPublic()) {
            ((ModBaseCommon)config.getMod()).registerDefaultCreativeTabEntry(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        Item item = config.getItemInstance();
        if (item != null) {
            ItemInformationProviderCommon.registerItem(item);
        }
        if (((ModBase)config.getMod()).getModHelpers().getMinecraftHelpers().isClientSide()) {
            BlockConfig blockConfig;
            BlockColor blockColorHandler;
            if (config.getInstance() instanceof IDynamicModelElement && ((IDynamicModelElement)config.getInstance()).hasDynamicModel()) {
                BlockActionNeoForge.handleDynamicBlockModel(config);
            }
            if (config instanceof BlockConfig && (blockColorHandler = (blockConfig = config).getBlockColorHandler()) != null) {
                COLOR_ENTRIES.add(config);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModelRegistryLoad(ModelEvent.RegisterAdditional event) {
        for (BlockConfig config : MODEL_ENTRIES) {
            Pair<ModelResourceLocation, ModelResourceLocation> resourceLocations = config.registerDynamicModel();
            config.dynamicBlockVariantLocation = (ModelResourceLocation)resourceLocations.getLeft();
            config.dynamicItemVariantLocation = (ModelResourceLocation)resourceLocations.getRight();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModelBakeEvent(ModelEvent.ModifyBakingResult event) {
        for (BlockConfig config : MODEL_ENTRIES) {
            IDynamicModelElement dynamicModelElement = (IDynamicModelElement)config.getInstance();
            BakedModel dynamicModel = dynamicModelElement.createDynamicModel(event);
            if (config.dynamicBlockVariantLocation != null) {
                event.getModels().put(config.dynamicBlockVariantLocation, dynamicModel);
            }
            if (config.dynamicItemVariantLocation == null) continue;
            event.getModels().put(config.dynamicItemVariantLocation, dynamicModel);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static <M extends ModBase> void onRegisterColorHandlers(RegisterColorHandlersEvent.Block event) {
        for (BlockConfig blockConfig : COLOR_ENTRIES) {
            BlockColor colorHander = blockConfig.getBlockColorHandler();
            event.register(colorHander, new Block[]{(Block)blockConfig.getInstance()});
        }
    }
}

