/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedButton
extends Button {
    private InfoSection target;
    protected ScreenInfoBook gui;
    private Button.OnPress onPress;

    public AdvancedButton() {
        super(0, 0, 0, 0, (Component)Component.literal((String)""), null, Button.DEFAULT_NARRATION);
    }

    public void setOnPress(Button.OnPress onPress) {
        this.onPress = onPress;
    }

    public Button.OnPress getOnPress() {
        return this.onPress;
    }

    public void onPress() {
        if (this.onPress != null) {
            this.onPress.onPress((Button)this);
        }
    }

    public void update(int x, int y, Component displayName, InfoSection target, ScreenInfoBook gui) {
        this.setX(x);
        this.setY(y);
        this.setMessage(displayName);
        this.target = target;
        this.gui = gui;
        this.width = 16;
        this.height = 16;
        this.active = this.isVisible();
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible() && this.isHover(mouseX, mouseY)) {
            Minecraft.getInstance().font.drawInBatch((Component)((MutableComponent)this.getMessage()).withStyle(ChatFormatting.UNDERLINE), (float)this.getX(), (float)this.getY(), Helpers.RGBToInt(100, 100, 150), false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    public void renderTooltip(GuiGraphics guiGraphics, Font font, int mx, int my) {
    }

    protected boolean isHover(int mouseX, int mouseY) {
        return mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
    }

    public boolean isVisible() {
        return this.visible && this.getTarget() != null;
    }

    public InfoSection getTarget() {
        return this.target;
    }
}

