/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import org.cyclops.cyclopscore.inventory.INBTInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

@Deprecated
public class SimpleInventory
implements INBTInventory,
WorldlyContainer {
    public static final Codec<SimpleInventory> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("size").forGetter(SimpleInventory::getContainerSize), (App)Codec.INT.fieldOf("stackLimit").forGetter(SimpleInventory::getMaxStackSize), (App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("contents").forGetter(i -> Arrays.asList(i.getItemStacks()))).apply((Applicative)builder, SimpleInventory::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SimpleInventory> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SimpleInventory::getContainerSize, (StreamCodec)ByteBufCodecs.INT, SimpleInventory::getMaxStackSize, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()), i -> Arrays.asList(i.getItemStacks()), SimpleInventory::new);
    protected final ItemStack[] contents;
    private final int stackLimit;
    private final List<IDirtyMarkListener> dirtyMarkListeners = Lists.newLinkedList();
    private int hash;

    public SimpleInventory() {
        this(0, 0);
    }

    public SimpleInventory(int size, int stackLimit) {
        this.contents = new ItemStack[size];
        for (int i = 0; i < this.contents.length; ++i) {
            this.contents[i] = ItemStack.EMPTY;
        }
        this.stackLimit = stackLimit;
    }

    public SimpleInventory(int size, int stackLimit, List<ItemStack> contents) {
        this.contents = new ItemStack[size];
        for (int i = 0; i < this.contents.length; ++i) {
            this.contents[i] = contents.get(i);
        }
        this.stackLimit = stackLimit;
    }

    public synchronized void addDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.add(dirtyMarkListener);
    }

    public synchronized void removeDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.remove(dirtyMarkListener);
    }

    public int getContainerSize() {
        return this.contents.length;
    }

    public ItemStack getItem(int slotId) {
        return this.contents[slotId];
    }

    public ItemStack removeItem(int slotId, int count) {
        ItemStack stack = this.getItem(slotId);
        if (slotId < this.getContainerSize() && !stack.isEmpty()) {
            if (stack.getCount() > count) {
                ItemStack slotContents = stack.copy();
                ItemStack result = slotContents.split(count);
                this.setItem(slotId, slotContents);
                return result;
            }
            this.setItem(slotId, ItemStack.EMPTY);
            this.onInventoryChanged();
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int slotId, ItemStack itemstack) {
        if (slotId >= this.getContainerSize()) {
            return;
        }
        this.contents[slotId] = Objects.requireNonNull(itemstack);
        if (!itemstack.isEmpty() && itemstack.getCount() > this.getMaxStackSize()) {
            itemstack.setCount(this.getMaxStackSize());
        }
        this.onInventoryChanged();
    }

    public int getMaxStackSize() {
        return this.stackLimit;
    }

    protected void onInventoryChanged() {
        this.setChanged();
    }

    public boolean stillValid(Player entityplayer) {
        return true;
    }

    public void startOpen(Player playerIn) {
    }

    public void stopOpen(Player playerIn) {
    }

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag data) {
        this.readFromNBT(provider, data, "items");
    }

    public void readFromNBT(HolderLookup.Provider provider, CompoundTag data, String tag) {
        int j;
        ListTag nbttaglist = data.getList(tag, 10);
        for (j = 0; j < this.getContainerSize(); ++j) {
            this.contents[j] = ItemStack.EMPTY;
        }
        for (j = 0; j < nbttaglist.size(); ++j) {
            CompoundTag slot = nbttaglist.getCompound(j);
            int index = slot.contains("index") ? slot.getInt("index") : (int)slot.getByte("Slot");
            if (index < 0 || index >= this.getContainerSize()) continue;
            this.contents[index] = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)slot);
        }
    }

    @Override
    public void write(HolderLookup.Provider provider, CompoundTag data) {
        this.writeToNBT(provider, data, "items");
    }

    public void writeToNBT(HolderLookup.Provider provider, CompoundTag data, String tag) {
        ListTag slots = new ListTag();
        for (byte index = 0; index < this.getContainerSize(); index = (byte)((byte)(index + 1))) {
            ItemStack itemStack = this.getItem(index);
            if (itemStack.isEmpty() || itemStack.getCount() <= 0) continue;
            CompoundTag slot = new CompoundTag();
            slot.putByte("Slot", index);
            slots.add((Object)itemStack.save(provider, (Tag)slot));
        }
        data.put(tag, (Tag)slots);
    }

    public ItemStack removeItemNoUpdate(int slotId) {
        ItemStack stackToTake = this.getItem(slotId);
        if (stackToTake.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.setItem(slotId, ItemStack.EMPTY);
        return stackToTake;
    }

    public ItemStack[] getItemStacks() {
        return this.contents;
    }

    public boolean canPlaceItem(int i, ItemStack itemstack) {
        return i < this.getContainerSize() && i >= 0;
    }

    public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.contents[i] = ItemStack.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChanged() {
        LinkedList dirtyMarkListeners;
        ++this.hash;
        SimpleInventory simpleInventory = this;
        synchronized (simpleInventory) {
            dirtyMarkListeners = Lists.newLinkedList(this.dirtyMarkListeners);
        }
        for (IDirtyMarkListener dirtyMarkListener : dirtyMarkListeners) {
            dirtyMarkListener.onDirty();
        }
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public CompoundTag toNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.write(provider, tag);
        return tag;
    }

    @Override
    public void fromNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.read(provider, tag);
    }

    public IItemHandler getItemHandler() {
        return new InvWrapper((Container)this);
    }

    public IItemHandler getItemHandlerSided(Direction side) {
        return new SidedInvWrapper((WorldlyContainer)this, side);
    }

    public int getState() {
        return this.hash;
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return true;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleInventory)) {
            return false;
        }
        SimpleInventory that = (SimpleInventory)o;
        if (this.stackLimit != that.stackLimit) {
            return false;
        }
        if (this.contents.length != that.contents.length) {
            return false;
        }
        for (int i = 0; i < this.contents.length; ++i) {
            if (ItemStack.isSameItemSameComponents((ItemStack)this.contents[i], (ItemStack)that.contents[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }
}

