/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.loot.modifier;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class LootModifierInjectItem
extends LootModifier {
    public static final Supplier<MapCodec<LootModifierInjectItem>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> LootModifierInjectItem.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ItemStack.CODEC.fieldOf("item").forGetter(LootModifierInjectItem::getItemStack), (App)Codec.list((Codec)Codec.STRING).fieldOf("loot_tables").forGetter(LootModifierInjectItem::getLootTables), (App)Codec.INT.optionalFieldOf("maxStackSize", (Object)1).forGetter(LootModifierInjectItem::getMaxStackSize))).apply((Applicative)inst, LootModifierInjectItem::new)));
    private final ItemStack itemStack;
    private final List<String> lootTables;
    private final int maxStackSize;

    public LootModifierInjectItem(LootItemCondition[] conditionsIn, ItemStack itemStack, List<String> lootTables, int maxStackSize) {
        super(conditionsIn);
        this.itemStack = itemStack;
        this.lootTables = lootTables;
        this.maxStackSize = maxStackSize;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public List<String> getLootTables() {
        return this.lootTables;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.getLootTables().contains(context.getQueriedLootTableId().toString())) {
            ItemStack stack = this.getItemStack().copy();
            stack.setCount(context.getRandom().nextInt(1, this.getMaxStackSize() + 1));
            generatedLoot.add((Object)stack);
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

