/*
 * Decompiled with CFR 0.152.
 */
package com.derenderpatcher;

import com.derenderpatcher.Config;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.reflect.Field;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;

@EventBusSubscriber(modid="derenderpatcher")
public class DebugCommand {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"derender").requires(source -> source.hasPermission(0))).then(Commands.literal((String)"status").executes(DebugCommand::checkConfig)));
    }

    private static int checkConfig(CommandContext<CommandSourceStack> context) {
        String status;
        Object config;
        Field configField;
        StringBuilder message = new StringBuilder("\u00a76[Draconic Render Patcher Fix Config Status]\u00a7r\n\n");
        boolean isFixEnabled = (Boolean)Config.ENABLE_FIX.get();
        message.append("\u00a7e[Draconic Render Patcher]\u00a7r\n");
        message.append("  enableFix: ").append(isFixEnabled).append(" ").append(isFixEnabled ? "\u00a7a\u2713 ENABLED" : "\u00a7c\u2717 DISABLED").append("\n\n");
        try {
            Class<?> ifClass = Class.forName("net.raphimc.immediatelyfast.ImmediatelyFast");
            configField = ifClass.getDeclaredField("config");
            configField.setAccessible(true);
            config = configField.get(null);
            Field hudBatching = config.getClass().getDeclaredField("hud_batching");
            hudBatching.setAccessible(true);
            boolean hudValue = hudBatching.getBoolean(config);
            status = hudValue ? "\u00a7c\u2717 ENABLED" : "\u00a7a\u2713 DISABLED";
            message.append("\u00a7b[ImmediatelyFast]\u00a7r\n");
            message.append("  hud_batching: ").append(hudValue).append(" ").append(status).append("\n\n");
        }
        catch (ClassNotFoundException e) {
            message.append("\u00a7b[ImmediatelyFast]\u00a7r \u00a77(NOT FOUND)\u00a7r\n\n");
        }
        catch (Exception e) {
            message.append("\u00a7b[ImmediatelyFast]\u00a7r \u00a7cFAILED TO VERIFY STATUS\u00a7r\n\n");
        }
        try {
            Class<?> irisClass = Class.forName("net.irisshaders.iris.Iris");
            configField = irisClass.getDeclaredField("irisConfig");
            configField.setAccessible(true);
            config = configField.get(null);
            Field allowUnknownField = config.getClass().getDeclaredField("allowUnknownShaders");
            allowUnknownField.setAccessible(true);
            boolean allowValue = allowUnknownField.getBoolean(config);
            status = allowValue ? "\u00a7a\u2713 ENABLED" : "\u00a7c\u2717 DISABLED";
            message.append("\u00a7d[Iris]\u00a7r\n");
            message.append("  allowUnknownShaders: ").append(allowValue).append(" ").append(status).append("\n");
        }
        catch (ClassNotFoundException e) {
            message.append("\u00a7d[Iris]\u00a7r \u00a77(NOT FOUND)\u00a7r\n");
        }
        catch (Exception e) {
            message.append("\u00a7d[Iris]\u00a7r \u00a7cFAILED TO VERIFY STATUS\u00a7r\n");
        }
        String finalMessage = message.toString();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)finalMessage), false);
        return 1;
    }
}

