/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.customization.DrippyOverlayScreen;
import de.keksuccino.drippyloadingscreen.mixin.MixinCache;
import de.keksuccino.drippyloadingscreen.mixin.mixins.common.client.IMixinMinecraft;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.events.screen.CloseScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenCompletedEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenStartingEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenPostInitEvent;
import de.keksuccino.fancymenu.events.screen.RenderScreenEvent;
import de.keksuccino.fancymenu.events.screen.ScreenTickEvent;
import de.keksuccino.fancymenu.util.event.acara.EventBase;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LoadingOverlay.class})
public class MixinLoadingOverlay {
    @Unique
    private static final Logger LOGGER_DRIPPY = LogManager.getLogger();
    @Unique
    private static boolean initializedDrippy = false;
    @Unique
    private static DrippyOverlayScreen drippyOverlayScreen = new DrippyOverlayScreen();
    @Unique
    private int lastScreenWidthDrippy = 0;
    @Unique
    private int lastScreenHeightDrippy = 0;
    @Unique
    private float cachedBackgroundOpacityDrippy = 1.0f;
    @Unique
    private float cachedElementOpacityDrippy = 1.0f;
    @Unique
    private double cachedOverlayScaleDrippy = 1.0;
    @Shadow
    private float currentProgress;
    @Shadow
    private long fadeInStart;
    @Shadow
    @Final
    private boolean fadeIn;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void afterConstructDrippy(Minecraft mc, ReloadInstance reload, Consumer<?> consumer, boolean b, CallbackInfo info) {
        if (!initializedDrippy) {
            LOGGER_DRIPPY.info("[DRIPPY LOADING SCREEN] Initializing fonts for text rendering..");
            this.loadFontsDrippy();
            initializedDrippy = true;
        }
        this.setNewOverlayScreenDrippy();
        this.lastScreenWidthDrippy = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        this.lastScreenHeightDrippy = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        this.initOverlayScreenDrippy(false);
        this.setBackgroundOpacityDrippy(1.0f);
        this.setElementsOpacityDrippy(1.0f);
        this.tickOverlayUpdateDrippy();
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void afterRenderDrippy(GuiGraphics graphics, int mouseX, int mouseY, float partial, CallbackInfo info) {
        if (this.shouldRenderVanillaDrippy()) {
            return;
        }
        MixinCache.cachedCurrentLoadingScreenProgress = this.currentProgress;
        this.tickOverlayUpdateDrippy();
        this.updateFadeInOpacityCacheDrippy();
        this.setBackgroundOpacityDrippy(this.cachedBackgroundOpacityDrippy);
        this.setElementsOpacityDrippy((Boolean)DrippyLoadingScreen.getOptions().earlyFadeOutElements.getValue() != false ? this.cachedElementOpacityDrippy : this.cachedBackgroundOpacityDrippy);
        this.runMenuHandlerTaskDrippy(() -> {
            EventHandler.INSTANCE.postEvent((EventBase)new ScreenTickEvent.Pre((Screen)drippyOverlayScreen));
            drippyOverlayScreen.tick();
            EventHandler.INSTANCE.postEvent((EventBase)new ScreenTickEvent.Post((Screen)drippyOverlayScreen));
            this.restoreRenderDefaultsDrippy(graphics);
            float renderScale = UIBase.calculateFixedScale((float)((float)this.cachedOverlayScaleDrippy));
            double guiScale = Minecraft.getInstance().getWindow().getGuiScale();
            Minecraft.getInstance().getWindow().setGuiScale(this.cachedOverlayScaleDrippy);
            graphics.pose().pushPose();
            graphics.pose().scale(renderScale, renderScale, renderScale);
            EventHandler.INSTANCE.postEvent((EventBase)new RenderScreenEvent.Pre((Screen)drippyOverlayScreen, graphics, mouseX, mouseY, partial));
            drippyOverlayScreen.render(graphics, mouseX, mouseY, partial);
            this.restoreRenderDefaultsDrippy(graphics);
            EventHandler.INSTANCE.postEvent((EventBase)new RenderScreenEvent.Post((Screen)drippyOverlayScreen, graphics, mouseX, mouseY, partial));
            graphics.pose().scale(1.0f, 1.0f, 1.0f);
            graphics.pose().popPose();
            Minecraft.getInstance().getWindow().setGuiScale(guiScale);
            this.restoreRenderDefaultsDrippy(graphics);
        });
    }

    @WrapOperation(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V")})
    private void wrap_Screen_render_in_render_Drippy(Screen instance, GuiGraphics graphics, int mouseX, int mouseY, float partial, Operation<Void> original) {
        if (!((Boolean)DrippyLoadingScreen.getOptions().fadeInOutLoadingScreen.getValue()).booleanValue()) {
            return;
        }
        RenderingUtils.setTooltipRenderingBlocked((boolean)true);
        RenderSystem.disableDepthTest();
        RenderingUtils.setDepthTestLocked((boolean)true);
        Objects.requireNonNull(Minecraft.getInstance().screen).renderWithTooltip(graphics, mouseX, mouseY, partial);
        RenderingUtils.setDepthTestLocked((boolean)false);
        RenderSystem.enableDepthTest();
        RenderingUtils.setTooltipRenderingBlocked((boolean)false);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setOverlay(Lnet/minecraft/client/gui/screens/Overlay;)V")})
    private void beforeCloseOverlayDrippy(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, CallbackInfo info) {
        EventHandler.INSTANCE.postEvent((EventBase)new CloseScreenEvent((Screen)drippyOverlayScreen, null));
    }

    @Inject(method={"drawProgressBar"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelOriginalProgressBarRenderingDrippy(GuiGraphics graphics, int minX, int minY, int maxX, int maxY, float opacity, CallbackInfo info) {
        if (!this.shouldRenderVanillaDrippy()) {
            info.cancel();
            this.cachedElementOpacityDrippy = (Boolean)DrippyLoadingScreen.getOptions().fadeInOutLoadingScreen.getValue() != false ? opacity : 1.0f;
            RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        }
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIIIFFIIII)V")})
    private boolean cancelOriginalLogoRenderingDrippy(GuiGraphics instance, ResourceLocation atlasLocation, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        return this.shouldRenderVanillaDrippy();
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(Lnet/minecraft/client/renderer/RenderType;IIIII)V")})
    private boolean cancelBackgroundRenderingDrippy(GuiGraphics instance, RenderType renderType, int minX, int minY, int maxX, int maxY, int color) {
        this.cachedBackgroundOpacityDrippy = (Boolean)DrippyLoadingScreen.getOptions().fadeInOutLoadingScreen.getValue() != false ? Math.min(1.0f, Math.max(0.0f, (float)FastColor.ARGB32.alpha((int)color) / 255.0f)) : 1.0f;
        return this.shouldRenderVanillaDrippy();
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_clear(IZ)V", shift=At.Shift.AFTER, remap=false)})
    private void clearColorAfterBackgroundRenderingDrippy(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, CallbackInfo info) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    @Unique
    private void restoreRenderDefaultsDrippy(GuiGraphics graphics) {
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
    }

    @Unique
    private boolean shouldRenderVanillaDrippy() {
        return drippyOverlayScreen == null || this.getLayerDrippy() == null;
    }

    @Unique
    private void setBackgroundOpacityDrippy(float opacity) {
        if (this.getLayerDrippy() == null) {
            return;
        }
        this.getLayerDrippy().backgroundOpacity = opacity;
        MixinLoadingOverlay.drippyOverlayScreen.backgroundOpacity = opacity;
    }

    @Unique
    private void setElementsOpacityDrippy(float opacity) {
        boolean shouldBeVisible;
        if (opacity < 0.02f) {
            opacity = 0.02f;
        }
        boolean bl = shouldBeVisible = opacity > 0.02f;
        if (this.getLayerDrippy() != null) {
            for (AbstractElement i : this.getLayerDrippy().allElements) {
                i.opacity = opacity;
                i.visible = shouldBeVisible;
            }
        }
    }

    @Unique
    @Nullable
    private ScreenCustomizationLayer getLayerDrippy() {
        if (drippyOverlayScreen == null) {
            return null;
        }
        ScreenCustomizationLayer l = ScreenCustomizationLayerHandler.getLayerOfScreen((Screen)drippyOverlayScreen);
        if (l != null) {
            l.loadEarly = true;
        }
        return l;
    }

    @Unique
    private void loadFontsDrippy() {
        MainThreadTaskExecutor.executeInMainThread(() -> {
            try {
                FontManager fontManager = ((IMixinMinecraft)Minecraft.getInstance()).getFontManagerDrippy();
                fontManager.apply((FontManager.Preparation)fontManager.prepare(Minecraft.getInstance().getResourceManager(), (Executor)Util.backgroundExecutor()).get(), (ProfilerFiller)InactiveProfiler.INSTANCE);
            }
            catch (Exception ex) {
                LOGGER_DRIPPY.error("[DRIPPY LOADING SCREEN] Failed to load fonts!", (Throwable)ex);
            }
        }, (MainThreadTaskExecutor.ExecuteTiming)MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
    }

    @Unique
    private void tickOverlayUpdateDrippy() {
        try {
            int screenWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
            int screenHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
            if (screenWidth != this.lastScreenWidthDrippy || screenHeight != this.lastScreenHeightDrippy) {
                this.initOverlayScreenDrippy(true);
            }
            this.lastScreenWidthDrippy = screenWidth;
            this.lastScreenHeightDrippy = screenHeight;
        }
        catch (Exception ex) {
            LOGGER_DRIPPY.error("[DRIPPY LOADING SCREEN] Error while updating overlay!", (Throwable)ex);
        }
    }

    @Unique
    private void updateFadeInOpacityCacheDrippy() {
        if (!((Boolean)DrippyLoadingScreen.getOptions().fadeInOutLoadingScreen.getValue()).booleanValue()) {
            return;
        }
        float fadeInOpacity = this.getFadeInOpacityDrippy();
        if (fadeInOpacity >= 0.0f && fadeInOpacity < 1.0f) {
            this.cachedBackgroundOpacityDrippy = fadeInOpacity;
            this.cachedElementOpacityDrippy = fadeInOpacity;
        }
    }

    @Unique
    private float getFadeInOpacityDrippy() {
        if (!this.fadeIn) {
            return -1.0f;
        }
        if (this.fadeInStart < 0L) {
            return -1.0f;
        }
        long now = Util.getMillis();
        float progress = (float)(now - this.fadeInStart) / 500.0f;
        return Mth.clamp((float)progress, (float)0.02f, (float)1.0f);
    }

    @Unique
    private void setNewOverlayScreenDrippy() {
        drippyOverlayScreen = new DrippyOverlayScreen();
        ScreenCustomizationLayerHandler.registerScreen((Screen)drippyOverlayScreen);
        this.getLayerDrippy();
    }

    @Unique
    private void initOverlayScreenDrippy(boolean resize) {
        this.runMenuHandlerTaskDrippy(() -> {
            try {
                double scale = Minecraft.getInstance().getWindow().getGuiScale();
                RenderingUtils.resetGuiScale();
                if (!resize) {
                    EventHandler.INSTANCE.postEvent((EventBase)new OpenScreenEvent((Screen)drippyOverlayScreen));
                }
                MixinLoadingOverlay.drippyOverlayScreen.width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
                MixinLoadingOverlay.drippyOverlayScreen.height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
                EventHandler.INSTANCE.postEvent((EventBase)new InitOrResizeScreenStartingEvent((Screen)drippyOverlayScreen, resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                EventHandler.INSTANCE.postEvent((EventBase)new InitOrResizeScreenEvent.Pre((Screen)drippyOverlayScreen, resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                drippyOverlayScreen.init(Minecraft.getInstance(), MixinLoadingOverlay.drippyOverlayScreen.width, MixinLoadingOverlay.drippyOverlayScreen.height);
                EventHandler.INSTANCE.postEvent((EventBase)new InitOrResizeScreenEvent.Post((Screen)drippyOverlayScreen, resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                EventHandler.INSTANCE.postEvent((EventBase)new InitOrResizeScreenCompletedEvent((Screen)drippyOverlayScreen, resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                if (!resize) {
                    EventHandler.INSTANCE.postEvent((EventBase)new OpenScreenPostInitEvent((Screen)drippyOverlayScreen));
                }
                MixinCache.cachedLoadingOverlayScale = this.cachedOverlayScaleDrippy = Minecraft.getInstance().getWindow().getGuiScale();
                Minecraft.getInstance().getWindow().setGuiScale(scale);
            }
            catch (Exception ex) {
                LOGGER_DRIPPY.error("[DRIPPY LOADING SCREEN] Error while initializing Drippy's overlay screen!", (Throwable)ex);
            }
        });
    }

    @Unique
    private void runMenuHandlerTaskDrippy(Runnable run) {
        try {
            boolean customizationEnabled = ScreenCustomization.isScreenCustomizationEnabled();
            ScreenCustomization.setScreenCustomizationEnabled((boolean)true);
            Screen current = Minecraft.getInstance().screen;
            if (!(current instanceof DrippyOverlayScreen)) {
                Minecraft.getInstance().screen = drippyOverlayScreen;
                run.run();
                Minecraft.getInstance().screen = current;
            }
            ScreenCustomization.setScreenCustomizationEnabled((boolean)customizationEnabled);
        }
        catch (Exception ex) {
            LOGGER_DRIPPY.error("[DRIPPY LOADING SCREEN] Error while running menu handler task!", (Throwable)ex);
        }
    }
}

