/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.datacomponents;

import com.mojang.serialization.Codec;
import de.maxhenkel.easypiglins.items.ModItems;
import de.maxhenkel.easypiglins.items.PiglinItem;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class PiglinData {
    public static final Codec<PiglinData> CODEC = CompoundTag.CODEC.xmap(PiglinData::of, d -> d.nbt);
    public static final StreamCodec<RegistryFriendlyByteBuf, PiglinData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, PiglinData>(){

        public PiglinData decode(RegistryFriendlyByteBuf buf) {
            return new PiglinData(buf.readNbt());
        }

        public void encode(RegistryFriendlyByteBuf buf, PiglinData piglinData) {
            buf.writeNbt((Tag)piglinData.nbt);
        }
    };
    private WeakReference<Piglin> piglinCache = new WeakReference<Object>(null);
    private final CompoundTag nbt;

    private PiglinData(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public static PiglinData of(CompoundTag nbt) {
        return new PiglinData(nbt.copy());
    }

    public static PiglinData of(Piglin piglin) {
        CompoundTag nbt = new CompoundTag();
        piglin.addAdditionalSaveData(nbt);
        return new PiglinData(nbt);
    }

    @Nullable
    public static PiglinData get(ItemStack stack) {
        if (!(stack.getItem() instanceof PiglinItem)) {
            throw new IllegalArgumentException("Tried to set piglin data to non-piglin item (%s)".formatted(stack.getHoverName().getString()));
        }
        PiglinData.convert(stack);
        return (PiglinData)stack.get(ModItems.PIGLIN_DATA_COMPONENT);
    }

    public static PiglinData getOrCreate(ItemStack stack) {
        PiglinData piglinData = PiglinData.get(stack);
        if (piglinData == null) {
            piglinData = PiglinData.setEmptyPiglinTag(stack);
        }
        return piglinData;
    }

    public Piglin getCachePiglin(Level level) {
        Piglin piglin = (Piglin)this.piglinCache.get();
        if (piglin == null) {
            piglin = this.createPiglin(level, null);
            this.piglinCache = new WeakReference<Piglin>(piglin);
        }
        return piglin;
    }

    public Piglin createPiglin(Level level, @Nullable ItemStack stack) {
        Component customName;
        Piglin v = new Piglin(EntityType.PIGLIN, level);
        v.readAdditionalSaveData(this.nbt);
        if (stack != null && (customName = (Component)stack.get(DataComponents.CUSTOM_NAME)) != null) {
            v.setCustomName(customName);
        }
        v.hurtTime = 0;
        v.yHeadRot = 0.0f;
        v.yHeadRotO = 0.0f;
        return v;
    }

    public static Piglin createPiglin(ItemStack stack, Level level) {
        PiglinData data = PiglinData.getOrCreate(stack);
        return data.createPiglin(level, stack);
    }

    public static void applyToItem(ItemStack stack, Piglin piglin) {
        if (stack.isEmpty()) {
            return;
        }
        stack.set(ModItems.PIGLIN_DATA_COMPONENT, (Object)PiglinData.of(piglin));
        if (piglin.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)piglin.getCustomName());
        }
    }

    public static Piglin getCachePiglin(ItemStack stack, Level level) {
        return PiglinData.getOrCreate(stack).getCachePiglin(level);
    }

    public static void convertInventory(CompoundTag tag, NonNullList<ItemStack> stacks, HolderLookup.Provider provider) {
        ListTag listtag = tag.getList("Items", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag itemTag = listtag.getCompound(i);
            int pos = itemTag.getByte("Slot") & 0xFF;
            if (pos >= stacks.size()) continue;
            ItemStack convert = PiglinData.convert(provider, itemTag);
            stacks.set(pos, (Object)convert);
        }
    }

    public static ItemStack convert(HolderLookup.Provider provider, CompoundTag itemCompound) {
        ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemCompound);
        if (stack.isEmpty()) {
            return stack;
        }
        if (!(stack.getItem() instanceof PiglinItem)) {
            return stack;
        }
        if (stack.has(ModItems.PIGLIN_DATA_COMPONENT)) {
            return stack;
        }
        if (!itemCompound.contains("tag", 10)) {
            return stack;
        }
        CompoundTag tag = itemCompound.getCompound("tag");
        if (!tag.contains("Piglin", 10)) {
            return stack;
        }
        CompoundTag piglinTag = tag.getCompound("Piglin");
        PiglinData piglinData = PiglinData.of(piglinTag);
        stack.set(ModItems.PIGLIN_DATA_COMPONENT, (Object)piglinData);
        return stack;
    }

    public static void convert(ItemStack stack) {
        if (!(stack.getItem() instanceof PiglinItem)) {
            return;
        }
        if (stack.has(ModItems.PIGLIN_DATA_COMPONENT)) {
            return;
        }
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            PiglinData.setEmptyPiglinTag(stack);
            return;
        }
        CompoundTag customTag = customData.copyTag();
        if (!customTag.contains("Piglin", 10)) {
            PiglinData.setEmptyPiglinTag(stack);
            return;
        }
        CompoundTag piglinTag = customTag.getCompound("Piglin");
        customTag.remove("Piglin");
        if (customTag.isEmpty()) {
            stack.remove(DataComponents.CUSTOM_DATA);
        } else {
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customTag));
        }
        PiglinData piglinData = PiglinData.of(piglinTag);
        stack.set(ModItems.PIGLIN_DATA_COMPONENT, (Object)piglinData);
    }

    private static PiglinData setEmptyPiglinTag(ItemStack stack) {
        PiglinData piglinData = new PiglinData(new CompoundTag());
        stack.set(ModItems.PIGLIN_DATA_COMPONENT, (Object)piglinData);
        return piglinData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiglinData piglinData = (PiglinData)o;
        return Objects.equals(this.nbt, piglinData.nbt);
    }

    public int hashCode() {
        return Objects.hashCode(this.nbt);
    }
}

