/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ArrowButton
extends AbstractButton {
    private static final ResourceLocation ARROW_LEFT = ResourceLocation.fromNamespaceAndPath((String)"easy_villagers", (String)"textures/gui/arrow_left.png");
    private static final ResourceLocation ARROW_RIGHT = ResourceLocation.fromNamespaceAndPath((String)"easy_villagers", (String)"textures/gui/arrow_right.png");
    private final boolean left;
    private final OnPress onPress;

    public ArrowButton(int x, int y, boolean left, OnPress onPress) {
        super(x, y, 16, 20, (Component)Component.empty());
        this.left = left;
        this.onPress = onPress;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.renderWidget(guiGraphics, mouseX, mouseY, delta);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(this.left ? ARROW_LEFT : ARROW_RIGHT, this.getX(), this.getY() + 2, 0.0f, 0.0f, this.width, this.height, 16, 16);
    }

    public void onPress() {
        this.onPress.onPress(this);
    }

    protected void updateWidgetNarration(NarrationElementOutput elementOutput) {
    }

    @FunctionalInterface
    public static interface OnPress {
        public void onPress(ArrowButton var1);
    }
}

