/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.network.PacketDistributor;
import website.eccentric.tome.EccentricDataComponents;
import website.eccentric.tome.core.TomeData;
import website.eccentric.tome.network.SelectBookPacket;

public class TomeScreen
extends Screen {
    private static final int LEFT_CLICK = 0;
    private final ItemStack tome;
    private String selectedMod;
    private int selectedIndex;

    public TomeScreen(ItemStack tome) {
        super((Component)Component.empty());
        this.tome = tome;
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (button != 0 || this.selectedMod == null) {
            return super.mouseClicked(x, y, button);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new SelectBookPacket(this.selectedMod, this.selectedIndex), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Minecraft minecraft = this.minecraft;
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (minecraft != null && minecraft.options.keyInventory.isActiveAndMatches(key)) {
            this.onClose();
            return true;
        }
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float ticks) {
        Minecraft minecraft = this.minecraft;
        if (minecraft == null) {
            return;
        }
        super.render(gui, mouseX, mouseY, ticks);
        TomeData data = (TomeData)this.tome.getOrDefault(EccentricDataComponents.TOME_DATA.get(), (Object)TomeData.EMPTY);
        List books = data.books().values().stream().flatMap(Collection::stream).toList();
        Window window = minecraft.getWindow();
        int booksPerRow = 6;
        int rows = books.size() / booksPerRow + 1;
        int iconSize = 20;
        int startX = window.getGuiScaledWidth() / 2 - booksPerRow * iconSize / 2;
        int startY = window.getGuiScaledHeight() / 2 - rows * iconSize + 45;
        int padding = 4;
        gui.fill(startX - padding, startY - padding, startX + iconSize * booksPerRow + padding, startY + iconSize * rows + padding, 0x22000000);
        this.selectedMod = null;
        this.selectedIndex = -1;
        int displayIndex = 0;
        for (Map.Entry<String, List<ItemStack>> entry : data.books().entrySet()) {
            String modId = entry.getKey();
            List<ItemStack> modBooks = entry.getValue();
            for (int bookIndex = 0; bookIndex < modBooks.size(); ++bookIndex) {
                ItemStack book = modBooks.get(bookIndex);
                if (book.is(Items.AIR)) continue;
                int stackX = startX + displayIndex % booksPerRow * iconSize;
                int stackY = startY + displayIndex / booksPerRow * iconSize;
                if (mouseX > stackX && mouseY > stackY && mouseX <= stackX + 16 && mouseY <= stackY + 16) {
                    this.selectedMod = modId;
                    this.selectedIndex = bookIndex;
                    gui.renderComponentTooltip(this.font, TomeScreen.getTooltipFromItem((Minecraft)minecraft, (ItemStack)book), mouseX, mouseY);
                }
                gui.renderItem(book, stackX, stackY);
                gui.renderItemDecorations(this.font, book, mouseX, mouseY);
                ++displayIndex;
            }
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }
}

