/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome.network;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import website.eccentric.tome.EccentricTome;
import website.eccentric.tome.core.TomeManager;

public record SelectBookPacket(String modId, int index) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SelectBookPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"eccentrictome", (String)"select_book"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SelectBookPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SelectBookPacket::modId, (StreamCodec)ByteBufCodecs.INT, SelectBookPacket::index, SelectBookPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SelectBookPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ItemStack tomeStack;
            ItemStack bookStack;
            Player player = context.player();
            InteractionHand hand = TomeManager.getTomeHand(player);
            if (hand != null && !(bookStack = TomeManager.selectBook(tomeStack = player.getItemInHand(hand), packet.modId, packet.index)).isEmpty()) {
                player.setItemInHand(hand, bookStack);
                EccentricTome.LOGGER.debug("Selected book: {} at index {}", (Object)packet.modId, (Object)packet.index);
            }
        });
    }
}

