/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.mixin.features.render.immediate.buffer_builder.sorting;

import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MeshData.SortState.class})
public class MeshDataSortStateMixin {
    @Shadow
    @Final
    private Vector3f[] centroids;
    @Shadow
    @Final
    private VertexFormat.IndexType indexType;
    @Unique
    private static final int[] VERTEX_ORDER = new int[]{0, 1, 2, 2, 3, 0};

    @Overwrite
    public ByteBufferBuilder.Result buildSortedIndexBuffer(ByteBufferBuilder buffer, VertexSorting sorting) {
        int[] indices = sorting.sort(this.centroids);
        this.writePrimitiveIndices(buffer, indices);
        return buffer.build();
    }

    @Unique
    private void writePrimitiveIndices(ByteBufferBuilder builder, int[] indices) {
        long ptr = builder.reserve(indices.length * 6 * this.indexType.bytes);
        switch (this.indexType.bytes) {
            case 2: {
                for (int index : indices) {
                    int start = index * 4;
                    for (int offset : VERTEX_ORDER) {
                        MemoryUtil.memPutShort((long)ptr, (short)((short)(start + offset)));
                        ptr += 2L;
                    }
                }
                break;
            }
            case 4: {
                for (int index : indices) {
                    int start = index * 4;
                    for (int offset : VERTEX_ORDER) {
                        MemoryUtil.memPutInt((long)ptr, (int)(start + offset));
                        ptr += 4L;
                    }
                }
                break;
            }
        }
    }
}

