/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.terrain.material;

import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.material.FluidState;
import org.embeddedt.embeddium.impl.render.chunk.terrain.DefaultTerrainRenderPasses;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.parameters.AlphaCutoffParameter;

public class DefaultMaterials {
    public static final Material SOLID = new Material(DefaultTerrainRenderPasses.SOLID, AlphaCutoffParameter.ZERO, true);
    public static final Material CUTOUT = new Material(DefaultTerrainRenderPasses.CUTOUT, AlphaCutoffParameter.ONE_TENTH, false);
    public static final Material CUTOUT_MIPPED = new Material(DefaultTerrainRenderPasses.CUTOUT, AlphaCutoffParameter.ONE_TENTH, true);
    public static final Material TRANSLUCENT = new Material(DefaultTerrainRenderPasses.TRANSLUCENT, AlphaCutoffParameter.ZERO, true);

    public static Material forFluidState(FluidState state) {
        return DefaultMaterials.forRenderLayer(ItemBlockRenderTypes.getRenderLayer((FluidState)state));
    }

    public static Material forRenderLayer(RenderType layer) {
        if (layer == RenderType.solid()) {
            return SOLID;
        }
        if (layer == RenderType.cutout()) {
            return CUTOUT;
        }
        if (layer == RenderType.cutoutMipped() || layer == RenderType.tripwire()) {
            return CUTOUT_MIPPED;
        }
        if (layer == RenderType.translucent()) {
            return TRANSLUCENT;
        }
        throw new IllegalArgumentException("No material mapping exists for " + String.valueOf(layer));
    }
}

