/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.client;

import com.teamresourceful.resourcefullib.common.utils.modinfo.ModInfoUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import tech.alexnijjar.endermanoverhaul.EndermanOverhaul;
import tech.alexnijjar.endermanoverhaul.client.compat.mekanism.ReplacedBabyEndermanRenderer;
import tech.alexnijjar.endermanoverhaul.client.config.EndermanOverhaulClientConfig;
import tech.alexnijjar.endermanoverhaul.client.gui.FlashOverlay;
import tech.alexnijjar.endermanoverhaul.client.particles.EndermanParticle;
import tech.alexnijjar.endermanoverhaul.client.renderer.EndIslandsEndermanRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.EnderBulletRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.MushroomFieldsEndermanRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.ReplacedEndermanRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.base.BaseEndermanEntityRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.summons.ScarabRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.summons.SpiritRenderer;
import tech.alexnijjar.endermanoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.endermanoverhaul.common.registry.ModItems;
import tech.alexnijjar.endermanoverhaul.common.registry.ModParticleTypes;

@EventBusSubscriber(value={Dist.CLIENT}, modid="endermanoverhaul", bus=EventBusSubscriber.Bus.MOD)
public class EndermanOverhaulClient {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        EndermanOverhaul.CONFIGURATOR.register(EndermanOverhaulClientConfig.class);
        ItemProperties.register((Item)((Item)ModItems.CORRUPTED_SHIELD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"blocking"), (stack, level, entity, i) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        event.enqueueWork(() -> {
            if (EndermanOverhaulClientConfig.replaceMekanismBabyEnderman && ModInfoUtils.isModLoaded((String)"mekanismadditions")) {
                ReplacedBabyEndermanRenderer.register();
            }
        });
    }

    @SubscribeEvent
    public static void onRegisterParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticleTypes.DUST.get(), spriteSet -> new EndermanParticle.Provider(spriteSet, 0.7f, 0.7f, 0.7f));
        event.registerSpriteSet((ParticleType)ModParticleTypes.SNOW.get(), EndermanParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.SAND.get(), spriteSet -> new EndermanParticle.Provider(spriteSet, 0.86f, 0.83f, 0.63f));
        event.registerSpriteSet((ParticleType)ModParticleTypes.SOUL_FIRE_FLAME.get(), EndermanParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.BUBBLE.get(), EndermanParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.FRIENDERMAN.get(), spriteSet -> new EndermanParticle.Provider(spriteSet, 0.07f, 0.93f, 0.84f));
    }

    @SubscribeEvent
    private static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        if (EndermanOverhaulClientConfig.replaceDefaultEnderman) {
            event.registerEntityRenderer(EntityType.ENDERMAN, ReplacedEndermanRenderer::new);
        }
        event.registerEntityRenderer((EntityType)ModEntityTypes.BADLANDS_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.BADLANDS_ENDERMAN.get()));
        event.registerEntityRenderer((EntityType)ModEntityTypes.CAVE_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.CAVE_ENDERMAN.get()));
        event.registerEntityRenderer((EntityType)ModEntityTypes.CRIMSON_FOREST_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.CRIMSON_FOREST_ENDERMAN.get()));
        event.registerEntityRenderer((EntityType)ModEntityTypes.DARK_OAK_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.DARK_OAK_ENDERMAN.get(), BaseEndermanEntityRenderer.DARK_OAK_ANIMATION));
        event.registerEntityRenderer((EntityType)ModEntityTypes.DESERT_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.DESERT_ENDERMAN.get(), BaseEndermanEntityRenderer.DESERT_ANIMATION));
        event.registerEntityRenderer((EntityType)ModEntityTypes.END_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.END_ENDERMAN.get(), BaseEndermanEntityRenderer.END_ANIMATION, false));
        event.registerEntityRenderer((EntityType)ModEntityTypes.END_ISLANDS_ENDERMAN.get(), EndIslandsEndermanRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.FLOWER_FIELDS_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.FLOWER_FIELDS_ENDERMAN.get(), BaseEndermanEntityRenderer.FLOWER_FIELDS_ANIMATION));
        event.registerEntityRenderer((EntityType)ModEntityTypes.ICE_SPIKES_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.ICE_SPIKES_ENDERMAN.get(), BaseEndermanEntityRenderer.ICE_SPIKES_ANIMATION));
        event.registerEntityRenderer((EntityType)ModEntityTypes.MUSHROOM_FIELDS_ENDERMAN.get(), MushroomFieldsEndermanRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.NETHER_WASTES_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.NETHER_WASTES_ENDERMAN.get()));
        event.registerEntityRenderer((EntityType)ModEntityTypes.CORAL_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.CORAL_ENDERMAN.get(), BaseEndermanEntityRenderer.CORAL_ANIMATION));
        event.registerEntityRenderer((EntityType)ModEntityTypes.SAVANNA_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.SAVANNA_ENDERMAN.get()));
        event.registerEntityRenderer((EntityType)ModEntityTypes.SNOWY_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.SNOWY_ENDERMAN.get(), BaseEndermanEntityRenderer.SNOWY_ANIMATION));
        event.registerEntityRenderer((EntityType)ModEntityTypes.SOULSAND_VALLEY_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.SOULSAND_VALLEY_ENDERMAN.get(), BaseEndermanEntityRenderer.SOULSAND_VALLEY_ANIMATION, false));
        event.registerEntityRenderer((EntityType)ModEntityTypes.SWAMP_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.SWAMP_ENDERMAN.get()));
        event.registerEntityRenderer((EntityType)ModEntityTypes.WARPED_FOREST_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.WARPED_FOREST_ENDERMAN.get(), BaseEndermanEntityRenderer.WARPED_FOREST_ANIMATION));
        event.registerEntityRenderer((EntityType)ModEntityTypes.WINDSWEPT_HILLS_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.WINDSWEPT_HILLS_ENDERMAN.get(), BaseEndermanEntityRenderer.WINDSWEPT_HILLS_ANIMATION));
        event.registerEntityRenderer((EntityType)ModEntityTypes.PET_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.PET_ENDERMAN.get()));
        event.registerEntityRenderer((EntityType)ModEntityTypes.HAMMERHEAD_PET_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.HAMMERHEAD_PET_ENDERMAN.get()));
        event.registerEntityRenderer((EntityType)ModEntityTypes.AXOLOTL_PET_ENDERMAN.get(), c -> new BaseEndermanEntityRenderer(c, (EntityType)ModEntityTypes.AXOLOTL_PET_ENDERMAN.get()));
        event.registerEntityRenderer((EntityType)ModEntityTypes.SCARAB.get(), ScarabRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.SPIRIT.get(), SpiritRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.ENDER_BULLET.get(), EnderBulletRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.CORRUPTED_PEARL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.ANCIENT_PEARL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.SOUL_PEARL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.BUBBLE_PEARL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.SUMMONER_PEARL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.ICY_PEARL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.CRIMSON_PEARL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.WARPED_PEARL.get(), ThrownItemRenderer::new);
    }

    public static void onRegisterClientHud(RenderGuiEvent.Post event) {
        FlashOverlay.render(event.getGuiGraphics());
    }

    public static Level getLevel() {
        return Minecraft.getInstance().level;
    }
}

