/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity;

import cn.leolezury.eternalstarlight.common.item.menu.AlloyFurnaceMenu;
import cn.leolezury.eternalstarlight.common.item.recipe.AlloyRecipe;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import cn.leolezury.eternalstarlight.common.registry.ESRecipes;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AlloyFurnaceBlockEntity
extends BaseContainerBlockEntity {
    private static final String TAG_LIT_TICKS = "lit_ticks";
    private static final String TAG_TOTAL_LIT_TICKS = "total_lit_ticks";
    private static final String TAG_BURN_TICKS = "burn_ticks";
    private static final String TAG_TOTAL_BURN_TICKS = "total_burn_ticks";
    private static final String TAG_OVERHEAT_TICKS = "overheat_ticks";
    private static final String TAG_COOLING_TICKS = "cooling_ticks";
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int id) {
            return switch (id) {
                case 0 -> {
                    if (AlloyFurnaceBlockEntity.this.totalLitTicks > Short.MAX_VALUE) {
                        yield Mth.floor((double)((double)AlloyFurnaceBlockEntity.this.litTicks / (double)AlloyFurnaceBlockEntity.this.totalLitTicks * 32767.0));
                    }
                    yield AlloyFurnaceBlockEntity.this.litTicks;
                }
                case 1 -> Math.min(AlloyFurnaceBlockEntity.this.totalLitTicks, Short.MAX_VALUE);
                case 2 -> AlloyFurnaceBlockEntity.this.burnTicks;
                case 3 -> AlloyFurnaceBlockEntity.this.totalBurnTicks;
                case 4 -> AlloyFurnaceBlockEntity.this.overheatTicks;
                case 5 -> AlloyFurnaceBlockEntity.this.coolingTicks;
                default -> 0;
            };
        }

        public void set(int id, int value) {
            switch (id) {
                case 0: {
                    AlloyFurnaceBlockEntity.this.litTicks = value;
                    break;
                }
                case 1: {
                    AlloyFurnaceBlockEntity.this.totalLitTicks = value;
                    break;
                }
                case 2: {
                    AlloyFurnaceBlockEntity.this.burnTicks = value;
                    break;
                }
                case 3: {
                    AlloyFurnaceBlockEntity.this.totalBurnTicks = value;
                }
                case 4: {
                    AlloyFurnaceBlockEntity.this.overheatTicks = value;
                }
                case 5: {
                    AlloyFurnaceBlockEntity.this.coolingTicks = value;
                }
            }
        }

        public int getCount() {
            return 6;
        }
    };
    private final RecipeManager.CachedCheck<CraftingInput, AlloyRecipe> quickCheck;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)14, (Object)ItemStack.EMPTY);
    private int litTicks;
    private int totalLitTicks;
    private int burnTicks;
    private int totalBurnTicks;
    private int overheatTicks;
    private int coolingTicks;

    public AlloyFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super(ESBlockEntities.ALLOY_FURNACE.get(), pos, state);
        this.quickCheck = RecipeManager.createCheck(ESRecipes.ALLOY.get());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AlloyFurnaceBlockEntity entity) {
        if (!level.isClientSide) {
            ItemStack fuel;
            boolean changed = false;
            if (entity.litTicks > 0) {
                --entity.litTicks;
                if (entity.overheatTicks < 3600) {
                    ++entity.overheatTicks;
                }
            }
            if (entity.coolingTicks > 0) {
                --entity.coolingTicks;
            }
            if (entity.litTicks <= 0) {
                entity.totalLitTicks = 0;
            }
            List<ItemStack> ingredients = entity.getIngredientItems();
            RecipeHolder recipeHolder = entity.quickCheck.getRecipeFor((RecipeInput)CraftingInput.of((int)3, (int)3, ingredients), level).orElse(null);
            if (entity.canBurn() && entity.litTicks <= 0 && !(fuel = entity.getItem(9)).isEmpty() && AlloyFurnaceBlockEntity.isFuel(fuel)) {
                entity.litTicks = entity.totalLitTicks = ESPlatform.INSTANCE.getBurnTime(fuel, ESRecipes.ALLOY.get());
                fuel.shrink(1);
                if (ESPlatform.INSTANCE.hasCraftingRemainingItem(fuel)) {
                    ESPlatform.INSTANCE.getCraftingRemainingItem(fuel).ifPresent(remaining -> {
                        if (fuel.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)fuel, (ItemStack)remaining)) {
                            int remainingCount = fuel.getCount() + remaining.getCount() - remaining.getMaxStackSize();
                            entity.setItem(9, remaining.copyWithCount(Math.min(fuel.getCount() + remaining.getCount(), remaining.getMaxStackSize())));
                            if (remainingCount > 0) {
                                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)remaining.copyWithCount(remainingCount));
                            }
                        } else {
                            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)remaining.copy());
                        }
                    });
                }
                changed = true;
            }
            entity.burnTicks = entity.burnTicks + (entity.litTicks > 0 && entity.canBurn() ? 1 : -1);
            entity.burnTicks = Mth.clamp((int)entity.burnTicks, (int)0, (int)entity.totalBurnTicks);
            if (!entity.canBurn() || entity.burnTicks != entity.totalBurnTicks || recipeHolder != null) {
                // empty if block
            }
            if (changed) {
                entity.setChanged();
            }
        }
    }

    private List<ItemStack> getIngredientItems() {
        return this.getItems().subList(0, 9);
    }

    private boolean canBurn() {
        if (this.level == null) {
            return false;
        }
        Optional recipeHolder = this.quickCheck.getRecipeFor((RecipeInput)CraftingInput.of((int)3, (int)3, this.getIngredientItems()), this.level);
        if (this.getIngredientItems().stream().anyMatch(stack -> !stack.isEmpty()) && recipeHolder.isPresent()) {
            AlloyRecipe recipe = (AlloyRecipe)((RecipeHolder)recipeHolder.get()).value();
            for (int i = 0; i < Math.min(recipe.results().size(), 3); ++i) {
                ItemStack stack2 = (ItemStack)recipe.results().get(i);
                if (stack2.isEmpty()) {
                    return false;
                }
                ItemStack existingResult = this.getItem(11 + i);
                if (!existingResult.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)existingResult, (ItemStack)stack2)) {
                    return false;
                }
                if (existingResult.getCount() + stack2.getCount() <= stack2.getMaxStackSize()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isFuel(ItemStack stack) {
        return FurnaceBlockEntity.isFuel((ItemStack)stack);
    }

    public static boolean isFreezingItem(ItemStack stack) {
        return stack.is(ESTags.Items.COOLS_ALLOY_FURNACE);
    }

    public void setItem(int index, ItemStack stack) {
        boolean unchanged;
        ItemStack original = (ItemStack)this.items.get(index);
        boolean bl = unchanged = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)original, (ItemStack)stack);
        if (this.level != null && index >= 0 && index < 9 && !unchanged) {
            this.quickCheck.getRecipeFor((RecipeInput)CraftingInput.of((int)3, (int)3, this.getIngredientItems()), this.level).ifPresentOrElse(holder -> {
                this.totalBurnTicks = ((AlloyRecipe)holder.value()).burnTime();
            }, () -> {
                this.totalBurnTicks = 0;
            });
            this.burnTicks = 0;
            this.setChanged();
        }
        super.setItem(index, stack);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        if (index == 9 && !AlloyFurnaceBlockEntity.isFuel(stack)) {
            return false;
        }
        if (index == 10 && !AlloyFurnaceBlockEntity.isFreezingItem(stack)) {
            return false;
        }
        return super.canPlaceItem(index, stack);
    }

    public int getContainerSize() {
        return 14;
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.eternal_starlight.alloy_furnace");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return new AlloyFurnaceMenu(id, player.player.getInventory(), (Container)this, this.dataAccess);
    }
}

