/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.EnergyTransmitterBlock;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class EnergyTransmitterBlockEntity
extends BlockEntity {
    private static final String TAG_INPUT_OFFSET = "input_offset";
    private static final String TAG_OUTPUT_OFFSET = "output_offset";
    private Vec3i inputOffset = Vec3i.ZERO;
    private Vec3i outputOffset = Vec3i.ZERO;

    public void setInputOffset(Vec3i inputOffset) {
        this.inputOffset = inputOffset;
        this.setChanged();
    }

    public Vec3i getInputOffset() {
        return this.inputOffset;
    }

    public BlockState getInputState() {
        return this.getLevel() != null ? this.getLevel().getBlockState(this.getBlockPos().offset(this.inputOffset)) : Blocks.AIR.defaultBlockState();
    }

    public void setOutputOffset(Vec3i outputOffset) {
        this.outputOffset = outputOffset;
    }

    public EnergyTransmitterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(ESBlockEntities.ENERGY_TRANSMITTER.get(), blockPos, blockState);
    }

    public void setChanged() {
        super.setChanged();
        if (this.getLevel() != null) {
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EnergyTransmitterBlockEntity entity) {
        if (!level.isClientSide) {
            boolean powered;
            BlockPos inputPos;
            BlockEntity blockEntity;
            boolean receiver;
            if (entity.inputOffset.distManhattan(Vec3i.ZERO) > 64) {
                entity.inputOffset = Vec3i.ZERO;
                entity.setChanged();
            }
            if (entity.outputOffset.distManhattan(Vec3i.ZERO) > 64) {
                entity.outputOffset = Vec3i.ZERO;
            }
            if (!entity.inputOffset.equals((Object)Vec3i.ZERO) && !entity.outputOffset.equals((Object)Vec3i.ZERO)) {
                entity.outputOffset = Vec3i.ZERO;
            }
            int directOutputPower = 0;
            boolean bl = receiver = !entity.inputOffset.equals((Object)Vec3i.ZERO);
            if (receiver && (blockEntity = level.getBlockEntity(inputPos = pos.offset(entity.inputOffset))) instanceof EnergyTransmitterBlockEntity) {
                BlockState inputState;
                EnergyTransmitterBlockEntity inputEntity = (EnergyTransmitterBlockEntity)blockEntity;
                if (inputEntity.outputOffset.equals((Object)entity.inputOffset.multiply(-1)) && (inputState = level.getBlockState(inputPos)).hasProperty((Property)EnergyTransmitterBlock.DIRECT_POWER)) {
                    directOutputPower = Math.max((Integer)inputState.getValue((Property)EnergyTransmitterBlock.DIRECT_POWER) - 1, 0);
                }
            }
            boolean bl2 = receiver ? directOutputPower > 0 : (powered = state.hasProperty((Property)EnergyTransmitterBlock.DIRECT_POWER) && (Integer)state.getValue((Property)EnergyTransmitterBlock.DIRECT_POWER) > 0);
            if (state.hasProperty((Property)EnergyTransmitterBlock.POWER) && state.hasProperty((Property)EnergyTransmitterBlock.POWERED) && ((Integer)state.getValue((Property)EnergyTransmitterBlock.POWER) != directOutputPower || (Boolean)state.getValue((Property)EnergyTransmitterBlock.POWERED) != powered)) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)EnergyTransmitterBlock.POWER, (Comparable)Integer.valueOf(directOutputPower))).setValue((Property)EnergyTransmitterBlock.POWERED, (Comparable)Boolean.valueOf(powered)));
            }
        }
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        if (compoundTag.contains(TAG_INPUT_OFFSET)) {
            Vec3i.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get(TAG_INPUT_OFFSET)).resultOrPartial(s -> EternalStarlight.LOGGER.warn("Failed to parse Energy Transmitter input offset: {}", s)).ifPresent(pos -> {
                this.inputOffset = pos;
            });
        }
        if (compoundTag.contains(TAG_OUTPUT_OFFSET)) {
            Vec3i.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get(TAG_OUTPUT_OFFSET)).resultOrPartial(s -> EternalStarlight.LOGGER.warn("Failed to parse Energy Transmitter output offset: {}", s)).ifPresent(pos -> {
                this.outputOffset = pos;
            });
        }
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put(TAG_INPUT_OFFSET, (Tag)Vec3i.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.inputOffset).getOrThrow());
        compoundTag.put(TAG_OUTPUT_OFFSET, (Tag)Vec3i.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.outputOffset).getOrThrow());
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithFullMetadata(provider);
    }
}

