/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.MechanicalSpawnerBlock;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public abstract class MechanicalSpawner {
    public static final String TAG_SPAWN_DATA = "spawn_data";
    public static final String TAG_SPAWN_POTENTIALS = "spawn_potentials";
    private static final String TAG_SPAWN_DELAY = "spawn_delay";
    private static final String TAG_MIN_SPAWN_DELAY = "min_spawn_delay";
    private static final String TAG_MAX_SPAWN_DELAY = "max_spawn_delay";
    private static final String TAG_SPAWN_COUNT = "spawn_count";
    private static final String TAG_MAX_NEARBY_ENTITIES = "max_nearby_entities";
    private static final String TAG_REQUIRED_PLAYER_RANGE = "required_player_range";
    private static final String TAG_SPAWN_RANGE = "spawn_range";
    private static final int EVENT_SPAWN = 1;
    private int spawnDelay = 20;
    private SimpleWeightedRandomList<SpawnData> spawnPotentials = SimpleWeightedRandomList.empty();
    @Nullable
    private SpawnData nextSpawnData;
    private double spin;
    private double oSpin;
    private int minSpawnDelay = 20;
    private int maxSpawnDelay = 30;
    private int spawnCount = 1;
    @Nullable
    private Entity displayEntity;
    private int maxNearbyEntities = 6;
    private int requiredPlayerRange = 16;
    private int spawnRange = 4;

    public void setEntityId(EntityType<?> type, @Nullable Level level, RandomSource random, BlockPos pos) {
        this.getOrCreateNextSpawnData(level, random, pos).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(type).toString());
    }

    private boolean isNearPlayer(Level level, BlockPos pos, int range) {
        return !level.getEntitiesOfClass(Player.class, new AABB(pos).inflate((double)range)).stream().filter(player -> (level.isClientSide || MechanicalSpawner.inLineOfSight(level, pos.getCenter(), player.getEyePosition())) && !player.isCreative() && !player.isSpectator()).toList().isEmpty();
    }

    private static boolean inLineOfSight(Level level, Vec3 block, Vec3 target) {
        BlockHitResult blockHitResult = level.clip(new ClipContext(target, block, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        return blockHitResult.getBlockPos().equals((Object)BlockPos.containing((Position)block)) || blockHitResult.getType() == HitResult.Type.MISS;
    }

    public void clientTick(Level level, BlockPos pos) {
        this.oSpin = this.spin;
        if (this.isNearPlayer(level, pos, this.requiredPlayerRange)) {
            RandomSource random = level.getRandom();
            double x = (double)pos.getX() + random.nextDouble();
            double y = (double)pos.getY() + random.nextDouble() * 2.0 - 1.0;
            double z = (double)pos.getZ() + random.nextDouble();
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.spin = (this.spin + 1000.0 / ((double)this.spawnDelay + 200.0)) % 360.0;
        }
    }

    public void serverTick(ServerLevel serverLevel, BlockPos pos) {
        RandomSource random = serverLevel.getRandom();
        if (this.isNearPlayer((Level)serverLevel, pos, this.requiredPlayerRange)) {
            if (this.spawnDelay == -1) {
                this.delay((Level)serverLevel, pos);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            } else if (serverLevel.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
                boolean success = false;
                SpawnData spawnData = this.getOrCreateNextSpawnData((Level)serverLevel, random, pos);
                for (int i = 0; i < this.spawnCount; ++i) {
                    Mob mob;
                    SpawnData.CustomSpawnRules rules;
                    double z;
                    CompoundTag entityToSpawn = spawnData.getEntityToSpawn();
                    Optional type = EntityType.by((CompoundTag)entityToSpawn);
                    if (type.isEmpty()) {
                        this.delay((Level)serverLevel, pos);
                        return;
                    }
                    ListTag posTag = entityToSpawn.getList("Pos", 6);
                    int posSize = posTag.size();
                    double x = posSize >= 1 ? posTag.getDouble(0) : (double)pos.getX() + (random.nextDouble() - random.nextDouble()) * (double)this.spawnRange + 0.5;
                    double y = posSize >= 2 ? posTag.getDouble(1) : (double)(pos.getY() + random.nextInt(3) - 1);
                    double d = z = posSize >= 3 ? posTag.getDouble(2) : (double)pos.getZ() + (random.nextDouble() - random.nextDouble()) * (double)this.spawnRange + 0.5;
                    if (!serverLevel.noCollision(((EntityType)type.get()).getSpawnAABB(x, y, z)) || !MechanicalSpawner.inLineOfSight((Level)serverLevel, pos.getCenter(), new Vec3(x, y, z))) continue;
                    BlockPos spawnPos = BlockPos.containing((double)x, (double)y, (double)z);
                    if (!spawnData.getCustomSpawnRules().isPresent() ? !SpawnPlacements.checkSpawnRules((EntityType)((EntityType)type.get()), (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.TRIAL_SPAWNER, (BlockPos)spawnPos, (RandomSource)serverLevel.getRandom()) : !((EntityType)type.get()).getCategory().isFriendly() && serverLevel.getDifficulty() == Difficulty.PEACEFUL || !(rules = (SpawnData.CustomSpawnRules)spawnData.getCustomSpawnRules().get()).isValidPosition(spawnPos, serverLevel)) continue;
                    Entity entity = EntityType.loadEntityRecursive((CompoundTag)entityToSpawn, (Level)serverLevel, e -> {
                        e.moveTo(x, y, z, e.getYRot(), e.getXRot());
                        return e;
                    });
                    if (entity == null) {
                        this.delay((Level)serverLevel, pos);
                        return;
                    }
                    int entitiesCount = serverLevel.getEntities(EntityTypeTest.forExactClass(entity.getClass()), new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)).inflate((double)this.spawnRange), EntitySelector.NO_SPECTATORS).size();
                    if (entitiesCount >= this.maxNearbyEntities) {
                        this.delay((Level)serverLevel, pos);
                        return;
                    }
                    entity.moveTo(entity.getX(), entity.getY(), entity.getZ(), random.nextFloat() * 360.0f, 0.0f);
                    if (entity instanceof Mob) {
                        boolean shouldFinalize;
                        mob = (Mob)entity;
                        if (!mob.checkSpawnObstruction((LevelReader)serverLevel)) continue;
                        boolean bl = shouldFinalize = spawnData.getEntityToSpawn().size() == 1 && spawnData.getEntityToSpawn().contains("id", 8);
                        if (shouldFinalize) {
                            mob.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.TRIAL_SPAWNER, null);
                        }
                        spawnData.getEquipment().ifPresent(arg_0 -> ((Mob)mob).equip(arg_0));
                    }
                    if (!serverLevel.tryAddFreshEntityWithPassengers(entity)) {
                        this.delay((Level)serverLevel, pos);
                        return;
                    }
                    serverLevel.levelEvent(2004, pos, 0);
                    serverLevel.gameEvent(entity, (Holder)GameEvent.ENTITY_PLACE, spawnPos);
                    if (entity instanceof Mob) {
                        mob = (Mob)entity;
                        mob.spawnAnim();
                    }
                    for (int j = 0; j <= 10; ++j) {
                        ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.ENERGY, entity.getX() + (double)((random.nextFloat() - 0.5f) * entity.getBbWidth() * 1.2f), entity.getY(), entity.getZ() + (double)((random.nextFloat() - 0.5f) * entity.getBbWidth() * 1.2f), 0.0, 1.0, 0.0));
                    }
                    success = true;
                }
                if (success) {
                    this.delay((Level)serverLevel, pos);
                }
            }
        }
    }

    private void delay(Level level, BlockPos pos) {
        RandomSource random = level.getRandom();
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + random.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        BlockState state = level.getBlockState(pos);
        this.spawnDelay *= state.hasProperty((Property)MechanicalSpawnerBlock.POWER) ? 16 - (Integer)state.getValue((Property)MechanicalSpawnerBlock.POWER) : 1;
        this.spawnPotentials.getRandom(random).ifPresent(wrapper -> this.setNextSpawnData(level, pos, (SpawnData)wrapper.data()));
        this.broadcastEvent(level, pos, 1);
    }

    public void load(@Nullable Level level, BlockPos pos, CompoundTag tag) {
        boolean hasSpawnPotentials;
        this.spawnDelay = tag.getShort(TAG_SPAWN_DELAY);
        boolean hasSpawnData = tag.contains(TAG_SPAWN_DATA, 10);
        if (hasSpawnData) {
            SpawnData data = SpawnData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound(TAG_SPAWN_DATA)).resultOrPartial(s -> EternalStarlight.LOGGER.warn("Invalid SpawnData: {}", s)).orElseGet(SpawnData::new);
            this.setNextSpawnData(level, pos, data);
        }
        if (hasSpawnPotentials = tag.contains(TAG_SPAWN_POTENTIALS, 9)) {
            ListTag list = tag.getList(TAG_SPAWN_POTENTIALS, 10);
            this.spawnPotentials = SpawnData.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)list).resultOrPartial(s -> EternalStarlight.LOGGER.warn("Invalid SpawnPotentials list: {}", s)).orElseGet(SimpleWeightedRandomList::empty);
        } else {
            this.spawnPotentials = SimpleWeightedRandomList.single((Object)(this.nextSpawnData != null ? this.nextSpawnData : new SpawnData()));
        }
        if (tag.contains(TAG_MIN_SPAWN_DELAY, 99)) {
            this.minSpawnDelay = tag.getShort(TAG_MIN_SPAWN_DELAY);
        }
        if (tag.contains(TAG_MAX_SPAWN_DELAY, 99)) {
            this.maxSpawnDelay = tag.getShort(TAG_MAX_SPAWN_DELAY);
        }
        if (tag.contains(TAG_SPAWN_COUNT, 99)) {
            this.spawnCount = tag.getShort(TAG_SPAWN_COUNT);
        }
        if (tag.contains(TAG_MAX_NEARBY_ENTITIES, 99)) {
            this.maxNearbyEntities = tag.getShort(TAG_MAX_NEARBY_ENTITIES);
        }
        if (tag.contains(TAG_REQUIRED_PLAYER_RANGE, 99)) {
            this.requiredPlayerRange = tag.getShort(TAG_REQUIRED_PLAYER_RANGE);
        }
        if (tag.contains(TAG_SPAWN_RANGE, 99)) {
            this.spawnRange = tag.getShort(TAG_SPAWN_RANGE);
        }
        this.displayEntity = null;
    }

    public CompoundTag save(CompoundTag tag) {
        tag.putShort(TAG_SPAWN_DELAY, (short)this.spawnDelay);
        tag.putShort(TAG_MIN_SPAWN_DELAY, (short)this.minSpawnDelay);
        tag.putShort(TAG_MAX_SPAWN_DELAY, (short)this.maxSpawnDelay);
        tag.putShort(TAG_SPAWN_COUNT, (short)this.spawnCount);
        tag.putShort(TAG_MAX_NEARBY_ENTITIES, (short)this.maxNearbyEntities);
        tag.putShort(TAG_REQUIRED_PLAYER_RANGE, (short)this.requiredPlayerRange);
        tag.putShort(TAG_SPAWN_RANGE, (short)this.spawnRange);
        if (this.nextSpawnData != null) {
            tag.put(TAG_SPAWN_DATA, (Tag)SpawnData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.nextSpawnData).getOrThrow(s -> new IllegalStateException("Invalid SpawnData: " + s)));
        }
        tag.put(TAG_SPAWN_POTENTIALS, (Tag)SpawnData.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.spawnPotentials).getOrThrow());
        return tag;
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level level, BlockPos pos) {
        if (this.displayEntity == null) {
            CompoundTag tag = this.getOrCreateNextSpawnData(level, level.getRandom(), pos).getEntityToSpawn();
            if (!tag.contains("id", 8)) {
                return null;
            }
            this.displayEntity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)level, Function.identity());
        }
        return this.displayEntity;
    }

    public boolean onEventTriggered(Level level, BlockState state, int id) {
        if (id == 1) {
            if (level.isClientSide) {
                this.spawnDelay = this.minSpawnDelay * (state.hasProperty((Property)MechanicalSpawnerBlock.POWER) ? 16 - (Integer)state.getValue((Property)MechanicalSpawnerBlock.POWER) : 1);
            }
            return true;
        }
        return false;
    }

    protected void setNextSpawnData(@Nullable Level level, BlockPos pos, SpawnData nextSpawnData) {
        this.nextSpawnData = nextSpawnData;
    }

    private SpawnData getOrCreateNextSpawnData(@Nullable Level level, RandomSource random, BlockPos pos) {
        if (this.nextSpawnData == null) {
            this.setNextSpawnData(level, pos, this.spawnPotentials.getRandom(random).map(WeightedEntry.Wrapper::data).orElseGet(SpawnData::new));
        }
        return this.nextSpawnData;
    }

    public abstract void broadcastEvent(Level var1, BlockPos var2, int var3);

    public double getSpin() {
        return this.spin;
    }

    public double getOSpin() {
        return this.oSpin;
    }
}

