/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.StarfireBirdNestBlock;
import cn.leolezury.eternalstarlight.common.block.entity.SimpleContainerBlockEntity;
import cn.leolezury.eternalstarlight.common.entity.living.animal.StarfireBird;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class StarfireBirdNestBlockEntity
extends SimpleContainerBlockEntity {
    private static final String TAG_BIRDS = "birds";
    private static final String TAG_LAST_SEED_PLAYER = "last_seed_player";
    private static final String TAG_HATCH_TICKS = "hatch_ticks";
    private static final List<String> IGNORED_BIRD_TAGS = Arrays.asList("Air", "FallDistance", "FallFlying", "Fire", "HurtByTimestamp", "HurtTime", "Motion", "PortalCooldown", "Pos", "leash", "UUID");
    private final List<BirdData> stored = Lists.newArrayList();
    private NonNullList<ItemStack> items = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
    private UUID lastSeedPlayer = null;
    private int hatchTicks;

    public StarfireBirdNestBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(ESBlockEntities.STARFIRE_BIRD_NEST.get(), blockPos, blockState);
    }

    public void setChanged() {
        super.setChanged();
        if (this.getLevel() != null) {
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean addSeeds(ItemStack stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).isEmpty()) continue;
            this.items.set(i, (Object)stack);
            this.setChanged();
            return true;
        }
        return false;
    }

    public boolean removeSeeds() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).isEmpty()) continue;
            this.items.set(i, (Object)ItemStack.EMPTY);
            this.setChanged();
            return true;
        }
        return false;
    }

    public void setLastSeedPlayer(Player player) {
        this.lastSeedPlayer = player.getUUID();
    }

    public void releaseAllOccupants(BlockState state, boolean emergency) {
        ArrayList list = Lists.newArrayList();
        if (this.level != null) {
            this.stored.removeIf(birdData -> StarfireBirdNestBlockEntity.releaseOccupant(this.level, this.worldPosition, state, this, birdData.toOccupant(), list, emergency, 2400));
        }
        if (!list.isEmpty()) {
            this.setChanged();
        }
    }

    public int getOccupantCount() {
        return this.stored.size();
    }

    public int getContainerSize() {
        return 5;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return stack.is(ESTags.Items.STARFIRE_BIRD_FOOD) && this.getItem(index).isEmpty() && stack.getCount() <= this.getMaxStackSize();
    }

    @Override
    public boolean isEmpty() {
        return this.stored.isEmpty();
    }

    public boolean isFullForAdults() {
        return this.getAdults().size() >= 2;
    }

    public boolean isFullForBabies() {
        return this.getBabies().size() >= 3;
    }

    public List<BirdData> getAdults() {
        return this.stored.stream().filter(d -> {
            AgeableMob mob;
            Entity patt0$temp = d.getOrCreateEntityInstance(this.level, this.getBlockPos());
            return patt0$temp instanceof AgeableMob && !(mob = (AgeableMob)patt0$temp).isBaby();
        }).toList();
    }

    public List<BirdData> getBabies() {
        return this.stored.stream().filter(d -> {
            AgeableMob mob;
            Entity patt0$temp = d.getOrCreateEntityInstance(this.level, this.getBlockPos());
            return patt0$temp instanceof AgeableMob && (mob = (AgeableMob)patt0$temp).isBaby();
        }).toList();
    }

    public void addAdultOccupant(Entity entity) {
        this.addOccupant(entity, 600, false);
    }

    public void addBabyOccupant(Entity entity) {
        this.addOccupant(entity, 23980, true);
    }

    public void addOccupant(Entity entity, int minTicksInNest, boolean baby) {
        if (!baby && this.getAdults().size() < 2 || baby && this.getBabies().size() < 3) {
            entity.stopRiding();
            entity.ejectPassengers();
            this.storeBird(Occupant.of(entity, minTicksInNest));
            if (this.level != null) {
                BlockPos blockPos = this.getBlockPos();
                this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)entity, (BlockState)this.getBlockState()));
            }
            entity.discard();
            this.setChanged();
        }
    }

    public void storeBird(Occupant occupant) {
        this.stored.add(new BirdData(occupant));
        if (this.level != null) {
            this.stored.sort(Comparator.comparingInt(d -> {
                int n;
                Entity patt0$temp = d.getOrCreateEntityInstance(this.level, this.getBlockPos());
                if (patt0$temp instanceof AgeableMob) {
                    AgeableMob mob = (AgeableMob)patt0$temp;
                    n = -mob.getAge();
                } else {
                    n = 0;
                }
                return n;
            }));
        }
        this.setChanged();
    }

    private static boolean releaseOccupant(Level level, BlockPos blockPos, BlockState blockState, StarfireBirdNestBlockEntity blockEntity, Occupant occupant, @Nullable List<Entity> list, boolean emergency, int renterCooldown) {
        boolean hasCollisionShape;
        if (level.isRaining() && !emergency) {
            return false;
        }
        Direction facing = (Direction)blockState.getValue((Property)StarfireBirdNestBlock.FACING);
        BlockPos neighborBlock = blockPos.relative(facing);
        boolean bl = hasCollisionShape = !level.getBlockState(neighborBlock).getCollisionShape((BlockGetter)level, neighborBlock).isEmpty();
        if (hasCollisionShape && !emergency) {
            return false;
        }
        Entity entity = occupant.createEntity(level, blockPos, true);
        if (entity != null) {
            if (entity instanceof StarfireBird) {
                StarfireBird bird = (StarfireBird)entity;
                if (list != null) {
                    list.add((Entity)bird);
                }
                float bbWidth = entity.getBbWidth();
                double xzOffset = hasCollisionShape ? 0.0 : 0.55 + (double)bbWidth / 2.0;
                double x = (double)blockPos.getX() + 0.5 + xzOffset * (double)facing.getStepX();
                double y = (double)blockPos.getY() + 0.5 - (double)entity.getBbHeight() / 2.0;
                double z = (double)blockPos.getZ() + 0.5 + xzOffset * (double)facing.getStepZ();
                entity.moveTo(x, y, z, entity.getYRot(), entity.getXRot());
                if (level.getBlockState(blockPos).is(ESTags.Blocks.STARFIRE_BIRD_NESTS) && !emergency && !bird.isBaby() && bird.canFallInLove() && bird.getAge() == 0 && blockEntity.removeSeeds()) {
                    Player loveCause = null;
                    if (blockEntity.lastSeedPlayer != null) {
                        loveCause = level.getPlayerByUUID(blockEntity.lastSeedPlayer);
                    }
                    bird.setInLove(loveCause);
                }
                bird.addTrustedPlayer(blockEntity.lastSeedPlayer);
                bird.addGiftCount();
                bird.setStayOutOfNestTicks(renterCooldown);
            }
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)entity, (BlockState)level.getBlockState(blockPos)));
            return level.addFreshEntity(entity);
        }
        return false;
    }

    private static void tickOccupants(Level level, BlockPos pos, BlockState state, StarfireBirdNestBlockEntity blockEntity, List<BirdData> list) {
        boolean change = false;
        Iterator<BirdData> iterator = list.iterator();
        while (iterator.hasNext()) {
            BirdData data = iterator.next();
            if (!data.tick() || !StarfireBirdNestBlockEntity.releaseOccupant(level, pos, state, blockEntity, data.toOccupant(), null, false, 1200)) continue;
            change = true;
            iterator.remove();
        }
        int eggs = (Integer)state.getValue((Property)StarfireBirdNestBlock.EGGS);
        if (eggs > 0) {
            ++blockEntity.hatchTicks;
            if (!blockEntity.isFullForBabies() && blockEntity.hatchTicks > 6000) {
                StarfireBird baby = new StarfireBird(ESEntities.STARFIRE_BIRD.get(), level);
                baby.setBaby(true);
                baby.moveTo(pos.getCenter());
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    baby.finalizeSpawn((ServerLevelAccessor)serverLevel, level.getCurrentDifficultyAt(pos), MobSpawnType.BREEDING, null);
                }
                blockEntity.addBabyOccupant((Entity)baby);
                change = true;
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)StarfireBirdNestBlock.EGGS, (Comparable)Integer.valueOf(eggs - 1)));
                blockEntity.hatchTicks = 0;
            }
        } else {
            blockEntity.hatchTicks = 0;
        }
        if (change) {
            blockEntity.setChanged();
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, StarfireBirdNestBlockEntity blockEntity) {
        for (BirdData data : blockEntity.stored) {
            data.clientTick(level);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, StarfireBirdNestBlockEntity blockEntity) {
        StarfireBirdNestBlockEntity.tickOccupants(level, pos, state, blockEntity, blockEntity.stored);
        if (!blockEntity.stored.isEmpty() && level.getRandom().nextDouble() < 0.005) {
            level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, ESSoundEvents.STARFIRE_BIRD_AMBIENT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.stored.clear();
        if (compoundTag.contains(TAG_BIRDS)) {
            Occupant.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get(TAG_BIRDS)).resultOrPartial(string -> EternalStarlight.LOGGER.error("Failed to parse Starfire Birds: '{}'", string)).ifPresent(list -> list.forEach(this::storeBird));
        }
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
        if (compoundTag.hasUUID(TAG_LAST_SEED_PLAYER)) {
            this.lastSeedPlayer = compoundTag.getUUID(TAG_LAST_SEED_PLAYER);
        }
        this.hatchTicks = compoundTag.getInt(TAG_HATCH_TICKS);
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put(TAG_BIRDS, (Tag)Occupant.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.getBirds()).getOrThrow());
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
        if (this.lastSeedPlayer != null) {
            compoundTag.putUUID(TAG_LAST_SEED_PLAYER, this.lastSeedPlayer);
        }
        compoundTag.putInt(TAG_HATCH_TICKS, this.hatchTicks);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithFullMetadata(provider);
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.stored.clear();
        List occupants = (List)input.getOrDefault(ESDataComponents.BIRDS.get(), List.of());
        occupants.forEach(this::storeBird);
        this.setChanged();
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ESDataComponents.BIRDS.get(), this.getBirds());
    }

    @Override
    public void removeComponentsFromTag(CompoundTag compoundTag) {
        super.removeComponentsFromTag(compoundTag);
        compoundTag.remove(TAG_BIRDS);
    }

    private List<Occupant> getBirds() {
        return this.stored.stream().map(BirdData::toOccupant).toList();
    }

    public record Occupant(CustomData entityData, int ticksInNest, int minTicksInNest) {
        public static final Codec<Occupant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CustomData.CODEC.optionalFieldOf("entity_data", (Object)CustomData.EMPTY).forGetter(Occupant::entityData), (App)Codec.INT.fieldOf("ticks_in_nest").forGetter(Occupant::ticksInNest), (App)Codec.INT.fieldOf("min_ticks_in_nest").forGetter(Occupant::minTicksInNest)).apply((Applicative)instance, Occupant::new));
        public static final Codec<List<Occupant>> LIST_CODEC = CODEC.listOf();
        public static final StreamCodec<ByteBuf, Occupant> STREAM_CODEC = StreamCodec.composite((StreamCodec)CustomData.STREAM_CODEC, Occupant::entityData, (StreamCodec)ByteBufCodecs.VAR_INT, Occupant::ticksInNest, (StreamCodec)ByteBufCodecs.VAR_INT, Occupant::minTicksInNest, Occupant::new);

        public static Occupant of(Entity entity, int minTicksInNest) {
            CompoundTag compoundTag = new CompoundTag();
            entity.save(compoundTag);
            IGNORED_BIRD_TAGS.forEach(arg_0 -> ((CompoundTag)compoundTag).remove(arg_0));
            return new Occupant(CustomData.of((CompoundTag)compoundTag), 0, minTicksInNest);
        }

        public static Occupant create(RandomSource random, int ticksInNest) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(ESEntities.STARFIRE_BIRD.get()).toString());
            if (random.nextInt(20) == 0) {
                compoundTag.putBoolean("special_variant", true);
            }
            return new Occupant(CustomData.of((CompoundTag)compoundTag), ticksInNest, 600);
        }

        @Nullable
        public Entity createEntity(Level level, BlockPos blockPos, boolean setData) {
            CompoundTag compoundTag = this.entityData.copyTag();
            IGNORED_BIRD_TAGS.forEach(arg_0 -> ((CompoundTag)compoundTag).remove(arg_0));
            Entity entity = EntityType.loadEntityRecursive((CompoundTag)compoundTag, (Level)level, e -> e);
            if (entity != null) {
                entity.setNoGravity(true);
                if (entity instanceof StarfireBird) {
                    StarfireBird bird = (StarfireBird)entity;
                    bird.setNestPos(blockPos);
                    if (setData) {
                        Occupant.setBirdReleaseData(this.ticksInNest, bird);
                    }
                }
                return entity;
            }
            return null;
        }

        private static void setBirdReleaseData(int ticksInNest, StarfireBird bird) {
            int age = bird.getAge();
            if (age < 0) {
                bird.setAge(Math.min(0, age + ticksInNest));
            } else if (age > 0) {
                bird.setAge(Math.max(0, age - ticksInNest));
            }
            bird.setInLoveTime(Math.max(0, bird.getInLoveTime() - ticksInNest));
        }
    }

    public static class BirdData {
        private final Occupant occupant;
        private int ticksInNest;
        private Entity entityInstance;
        private int clientTickOffset = -1;

        private BirdData(Occupant occupant) {
            this.occupant = occupant;
            this.ticksInNest = occupant.ticksInNest();
        }

        public boolean tick() {
            return this.ticksInNest++ > this.occupant.minTicksInNest;
        }

        public void clientTick(Level level) {
            if (this.clientTickOffset == -1) {
                this.clientTickOffset = level.getRandom().nextInt(1000);
            }
            if (this.entityInstance != null) {
                ++this.entityInstance.tickCount;
                Entity entity = this.entityInstance;
                if (entity instanceof StarfireBird) {
                    StarfireBird bird = (StarfireBird)entity;
                    bird.idleAnimationState.startIfStopped(bird.tickCount - this.clientTickOffset);
                    bird.nestIdleAnimationState.startIfStopped(bird.tickCount - this.clientTickOffset);
                }
            }
        }

        public Occupant toOccupant() {
            return new Occupant(this.occupant.entityData, this.ticksInNest, this.occupant.minTicksInNest);
        }

        public Entity getOrCreateEntityInstance(Level level, BlockPos pos) {
            if (this.entityInstance == null) {
                this.entityInstance = this.occupant.createEntity(level, pos, false);
                if (this.entityInstance != null) {
                    LivingEntity living;
                    this.entityInstance.setXRot(0.0f);
                    this.entityInstance.xRotO = 0.0f;
                    this.entityInstance.setYRot(0.0f);
                    this.entityInstance.yRotO = 0.0f;
                    this.entityInstance.setYBodyRot(0.0f);
                    Entity entity = this.entityInstance;
                    if (entity instanceof LivingEntity) {
                        living = (LivingEntity)entity;
                        living.yBodyRotO = 0.0f;
                    }
                    this.entityInstance.setYHeadRot(0.0f);
                    entity = this.entityInstance;
                    if (entity instanceof LivingEntity) {
                        living = (LivingEntity)entity;
                        living.yHeadRotO = 0.0f;
                    }
                }
            }
            return this.entityInstance;
        }
    }
}

