/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.flammable;

import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;

public class ESFlammabilityRegistry {
    public static final Map<Supplier<? extends Block>, Flammability> BLOCK_TO_FLAMMABILITY = new HashMap<Supplier<? extends Block>, Flammability>();
    public static final Flammability WOOD = new Flammability(5, 30);
    public static final Flammability LEAVES = new Flammability(30, 60);

    public static Optional<Flammability> getBlockFlammability(Block block) {
        for (Supplier<? extends Block> blockSupplier : BLOCK_TO_FLAMMABILITY.keySet()) {
            if (!blockSupplier.get().defaultBlockState().is(block)) continue;
            return Optional.ofNullable(BLOCK_TO_FLAMMABILITY.get(blockSupplier));
        }
        return Optional.empty();
    }

    public static void registerDefaults() {
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.LUNAR_LEAVES, LEAVES);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.NORTHLAND_LEAVES, LEAVES);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.BANYIN_LEAVES, LEAVES);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.SCARLET_LEAVES, LEAVES);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.TORREYA_LEAVES, LEAVES);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.CRADLEWOOD_LEAVES, LEAVES);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.LUNAR_LOG, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.LUNAR_WOOD, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.STRIPPED_LUNAR_LOG, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.STRIPPED_LUNAR_WOOD, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.LUNAR_PLANKS, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.NORTHLAND_LOG, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.NORTHLAND_WOOD, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.STRIPPED_NORTHLAND_LOG, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.STRIPPED_NORTHLAND_WOOD, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.NORTHLAND_PLANKS, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.BANYIN_LOG, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.BANYIN_WOOD, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.STRIPPED_BANYIN_LOG, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.STRIPPED_BANYIN_WOOD, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.BANYIN_PLANKS, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.SCARLET_LOG, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.SCARLET_WOOD, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.STRIPPED_SCARLET_LOG, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.STRIPPED_SCARLET_WOOD, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.SCARLET_PLANKS, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.TORREYA_LOG, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.TORREYA_WOOD, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.STRIPPED_TORREYA_LOG, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.STRIPPED_TORREYA_WOOD, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.TORREYA_PLANKS, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.JINGLESTEM_LOG, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.JINGLESTEM_WOOD, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.STRIPPED_JINGLESTEM_LOG, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.STRIPPED_JINGLESTEM_WOOD, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.JINGLESTEM_PLANKS, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.CRADLEWOOD_LOG, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.CRADLEWOOD_WOOD, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.STRIPPED_CRADLEWOOD_LOG, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.STRIPPED_CRADLEWOOD_WOOD, WOOD);
        BLOCK_TO_FLAMMABILITY.put(ESBlocks.CRADLEWOOD_PLANKS, WOOD);
    }

    public record Flammability(int catchOdds, int burnOdds) {
    }
}

