/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.CreteorAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.monster.Creteor;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreteorModel<T extends Creteor>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("creteor"), "main");
    public static final ModelLayerLocation ARMOR_LOCATION = new ModelLayerLocation(EternalStarlight.id("creteor"), "armor");
    private final ModelPart root;
    private final ModelPart rotator;

    public CreteorModel(ModelPart root) {
        this.root = root.getChild("root");
        this.rotator = root.getChild("root").getChild("rotator");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation deformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition rotator = root.addOrReplaceChild("rotator", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -12.0f, -3.0f, 8.0f, 16.0f, 6.0f, deformation), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition crystal1 = rotator.addOrReplaceChild("crystal1", CubeListBuilder.create().texOffs(29, 1).addBox(-6.0f, -6.0f, 0.0f, 10.0f, 10.0f, 0.0f, deformation), PartPose.offset((float)-4.0f, (float)-12.0f, (float)0.0f));
        crystal1.addOrReplaceChild("crystal2", CubeListBuilder.create().texOffs(29, 12).addBox(-4.5f, -4.0f, 0.0f, 9.0f, 8.0f, 0.0f, deformation), PartPose.offsetAndRotation((float)-2.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)-0.7854f));
        PartDefinition crystal3 = rotator.addOrReplaceChild("crystal3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)3.0f, (float)-6.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        crystal3.addOrReplaceChild("crystal4", CubeListBuilder.create().texOffs(25, 21).mirror().addBox(0.0f, 0.0f, 0.0f, 4.0f, 0.0f, 4.0f, deformation).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        crystal3.addOrReplaceChild("crystal5", CubeListBuilder.create().texOffs(25, 21).mirror().addBox(0.0f, 0.0f, 0.0f, 4.0f, 0.0f, 4.0f, deformation).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)-0.7854f));
        rotator.addOrReplaceChild("crystal6", CubeListBuilder.create().texOffs(29, 26).addBox(-2.5f, -4.0f, 0.0f, 5.0f, 4.0f, 0.0f, deformation), PartPose.offsetAndRotation((float)4.0f, (float)-6.0f, (float)-2.0f, (float)-0.4363f, (float)0.0f, (float)1.5708f));
        PartDefinition leftLeg = rotator.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(20, 46).addBox(-0.5f, -2.0f, -2.5f, 5.0f, 10.0f, 5.0f, deformation), PartPose.offsetAndRotation((float)0.5f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2138f));
        leftLeg.addOrReplaceChild("crystal8", CubeListBuilder.create().texOffs(25, 21).mirror().addBox(0.0f, 0.0f, 0.0f, 4.0f, 0.0f, 4.0f, deformation).mirror(false), PartPose.offsetAndRotation((float)3.5f, (float)3.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.3927f));
        PartDefinition rightLeg = rotator.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 46).addBox(-4.5f, -2.0f, -2.5f, 5.0f, 10.0f, 5.0f, deformation), PartPose.offsetAndRotation((float)-0.5f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2138f));
        rightLeg.addOrReplaceChild("crystal7", CubeListBuilder.create().texOffs(29, 26).mirror().addBox(-4.0f, -4.0f, 0.0f, 5.0f, 4.0f, 0.0f, deformation).mirror(false), PartPose.offsetAndRotation((float)-4.5f, (float)4.0f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)-1.5708f));
        rotator.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 34).addBox(0.0f, -3.0f, 0.0f, 8.0f, 6.0f, 6.0f, deformation), PartPose.offset((float)4.0f, (float)-1.0f, (float)-3.0f));
        rotator.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 22).addBox(-8.0f, -3.0f, 0.0f, 8.0f, 6.0f, 6.0f, deformation), PartPose.offset((float)-4.0f, (float)-1.0f, (float)-3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(((Creteor)((Object)entity)).idleAnimationState, CreteorAnimation.IDLE, ageInTicks);
        this.rotator.xRot = -1.5707964f;
        this.rotator.zRot = 1.5707964f;
        this.rotator.yRot = -(Mth.rotLerp((float)Mth.frac((float)ageInTicks), (float)((Creteor)((Object)entity)).prevRollAngle, (float)((Creteor)((Object)entity)).rollAngle) + 90.0f) * ((float)Math.PI / 180);
        if (((Creteor)((Object)entity)).getSwell() >= 80) {
            this.root.yRot = Mth.lerp((float)Mth.frac((float)ageInTicks), (float)((Creteor)((Object)entity)).prevSpin, (float)((Creteor)((Object)entity)).spin) * ((float)Math.PI / 180);
        }
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

