/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.GrimstoneGolemAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.GrimstoneGolem;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GrimstoneGolemModel<T extends GrimstoneGolem>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("grimstone_golem"), "main");
    private final ModelPart root;

    public GrimstoneGolemModel(ModelPart root) {
        this.root = root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(24, 0).addBox(-2.0f, -12.0f, -5.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.0f, -16.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(26, 10).addBox(-3.0f, -8.0f, -3.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-3.0f, (float)0.0f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.0f, (float)-3.0f, (float)0.0f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 31).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)-8.0f, (float)0.0f));
        root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 31).mirror().addBox(-0.5f, 0.0f, -1.0f, 1.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.5f, (float)-8.0f, (float)0.0f));
        root.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(28, 27).mirror().addBox(-0.5f, 0.0f, -2.0f, 1.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)4.5f, (float)-15.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        root.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(28, 27).addBox(-0.5f, 0.0f, -2.0f, 1.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)-15.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(((GrimstoneGolem)((Object)entity)).raiseArmsAnimationState, GrimstoneGolemAnimation.RAISE_ARMS, ageInTicks);
        this.animate(((GrimstoneGolem)((Object)entity)).lowerArmsAnimationState, GrimstoneGolemAnimation.LOWER_ARMS, ageInTicks);
        this.animate(((GrimstoneGolem)((Object)entity)).displayAnimationState, GrimstoneGolemAnimation.DISPLAY, ageInTicks);
        this.animateWalk(GrimstoneGolemAnimation.WALK, limbSwing, limbSwingAmount, 2.5f, 1.2f);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

